/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.conversion_updater;

import com.bmc.ctmconvert.base.BaseMessageDialog;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.ZipUnpacker;
import com.bmc.ctmconvert.conversion_updater.FilesBackuper;
import com.bmc.ctmconvert.conversion_updater.UpdaterGlobals;
import com.bmc.ctmconvert.services.FilesManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.SwingWorker;

public class InstallUpdateWorker
extends SwingWorker<Boolean, String> {
    private IOException installException = null;

    @Override
    protected Boolean doInBackground() {
        boolean installResult = true;
        ZipUnpacker zipUnpacker = new ZipUnpacker();
        FilesBackuper backuper = new FilesBackuper();
        try {
            Set<String> backupList = zipUnpacker.getTopLevelEntries(UpdaterGlobals.UPDATE_PACKAGE_LOCAL_LOCATION);
            List<Path> toBackUp = this.convertToPathList(backupList);
            this.setProgress(25);
            backuper.backUp(UpdaterGlobals.BACK_UP_DIRECTORY, toBackUp);
            this.setProgress(50);
            zipUnpacker.unzip(UpdaterGlobals.UPDATE_PACKAGE_LOCAL_LOCATION, UpdaterGlobals.EXTRACTING_LOCATION);
            this.setProgress(75);
        }
        catch (IOException e) {
            installResult = false;
            this.installException = e;
        }
        return installResult;
    }

    @Override
    protected void done() {
        try {
            if (this.installException != null) {
                this.handleInstallationError();
            }
            this.cleanHomeDirectory();
        }
        catch (Exception e) {
            BaseMessageDialog.showMessageDialog("Install Failed", e.getMessage(), BaseMessageDialog.TYPE.ERROR_MESSAGE);
        }
        this.setProgress(100);
    }

    private void handleInstallationError() throws IOException {
        FilesManager filesManager = new FilesManager();
        ExceptionHandler.writeToExceptionFile(this.installException);
        BaseMessageDialog.showMessageDialog("Install Failed", this.installException.getMessage(), BaseMessageDialog.TYPE.ERROR_MESSAGE);
        filesManager.extractDirIntoDir(UpdaterGlobals.BACK_UP_DIRECTORY, Paths.get(UpdaterGlobals.EXTRACTING_LOCATION, new String[0]));
    }

    private void cleanHomeDirectory() throws IOException {
        Path updateZipPath;
        FilesManager filesManager = new FilesManager();
        if (Files.exists(UpdaterGlobals.BACK_UP_DIRECTORY, new LinkOption[0])) {
            filesManager.deleteDirectory(UpdaterGlobals.BACK_UP_DIRECTORY);
        }
        if (Files.exists(updateZipPath = Paths.get(UpdaterGlobals.UPDATE_PACKAGE_LOCAL_LOCATION, new String[0]), new LinkOption[0])) {
            Files.delete(updateZipPath);
        }
    }

    private List<Path> convertToPathList(Set<String> backupList) {
        ArrayList<Path> toRet = new ArrayList<Path>();
        for (String file : backupList) {
            toRet.add(Paths.get(UpdaterGlobals.HOME_DIR + Globs.DIRSEP + file, new String[0]));
        }
        return toRet;
    }
}

