/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.conversion_updater;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public class FilesBackuper {
    public void backUp(Path dest, List<Path> toBackUp) throws IOException {
        if (Files.notExists(dest, new LinkOption[0])) {
            Files.createDirectory(dest, new FileAttribute[0]);
        }
        for (Path source : toBackUp) {
            if (Files.notExists(source, new LinkOption[0])) {
                throw new FileNotFoundException(source.toString() + " not found");
            }
            if (Files.isDirectory(source, new LinkOption[0])) {
                this.copyFolder(source, dest.resolve(source.getFileName()));
                continue;
            }
            Path copyToPath = dest.resolve(source.getFileName());
            Files.copy(source, copyToPath, new CopyOption[0]);
        }
    }

    private void copyFolder(Path sourceFolder, Path destinationFolder) throws IOException {
        if (Files.isDirectory(sourceFolder, new LinkOption[0])) {
            String[] files;
            if (Files.notExists(destinationFolder, new LinkOption[0])) {
                Files.createDirectory(destinationFolder, new FileAttribute[0]);
            }
            File src = new File(sourceFolder.toString());
            for (String file : files = src.list()) {
                Path nextSource = sourceFolder.resolve(file);
                Path nextDest = destinationFolder.resolve(file);
                this.copyFolder(nextSource, nextDest);
            }
        } else {
            Files.copy(sourceFolder, destinationFolder, new CopyOption[0]);
        }
    }
}

