/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.maybe.conditions;

import com.bmc.ctmconvert.maybe.conditions.ArgumentParser;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class UtilityStreamRepository
implements AutoCloseable {
    protected static final String DEFAULT_OUTPUT_DIR = ".\\output";
    protected static final String REPORT_FILE_NAME = "maybeInheritedConditionReport.csv";
    protected static final String CTM_DATA_FILE_NAME = "updateCtmData.xml";
    protected static final String LOG_FILE_NAME = "log.txt";
    private String outputDirectory;
    private InputStream maybeInheritedConditionInputStream;
    private InputStream ctmDataInputStream;
    private Path reportPath;
    private Path updatedCtmDataPath;
    private Path logFilePath;
    private OutputStream logOutputStream;
    private OutputStream reportOutputStream;
    private OutputStream updatedCtmDataOutputStream;
    private Path maybeInheritedConditionPath;
    private Path inputCtmDataPath;
    private final FileSystem fileSystem;

    public UtilityStreamRepository(ArgumentParser argumentParser, FileSystem fileSystem) throws Exception {
        this.fileSystem = fileSystem;
        this.buildStreamsFromArgs(argumentParser);
    }

    public UtilityStreamRepository(ArgumentParser argumentParser) throws Exception {
        this(argumentParser, FileSystems.getDefault());
    }

    private void buildStreamsFromArgs(ArgumentParser argumentParser) throws Exception {
        String maybeInheritedConditionFile = argumentParser.getArgValue("maybeInheritedConditionFile");
        String ctmDataFile = argumentParser.getArgValue("ctmData");
        this.outputDirectory = this.createOutputFolder(argumentParser.getArgValue("outputDirectory"));
        this.maybeInheritedConditionPath = this.fileSystem.getPath(maybeInheritedConditionFile, new String[0]);
        this.maybeInheritedConditionInputStream = Files.newInputStream(this.maybeInheritedConditionPath, new OpenOption[0]);
        this.inputCtmDataPath = this.fileSystem.getPath(ctmDataFile, new String[0]);
        this.ctmDataInputStream = Files.newInputStream(this.inputCtmDataPath, new OpenOption[0]);
        this.reportPath = this.fileSystem.getPath(this.outputDirectory, REPORT_FILE_NAME);
        this.updatedCtmDataPath = this.fileSystem.getPath(this.outputDirectory, CTM_DATA_FILE_NAME);
        this.logFilePath = this.fileSystem.getPath(this.outputDirectory, LOG_FILE_NAME);
    }

    private String createOutputFolder(String outputFolder) throws IOException {
        Path outputPath;
        if (outputFolder == null || outputFolder.isEmpty()) {
            outputFolder = DEFAULT_OUTPUT_DIR;
            outputPath = this.fileSystem.getPath(outputFolder, new String[0]);
            if (!Files.isDirectory(outputPath, new LinkOption[0])) {
                Files.createDirectory(outputPath, new FileAttribute[0]);
            }
        } else {
            outputPath = this.fileSystem.getPath(outputFolder, new String[0]);
        }
        return outputPath.toRealPath(new LinkOption[0]).toString();
    }

    public InputStream getMaybeInheritedCondStream() {
        return this.maybeInheritedConditionInputStream;
    }

    public InputStream getCtmDataInputStream() {
        return this.ctmDataInputStream;
    }

    public OutputStream getReportOutputStream() throws IOException {
        if (this.reportOutputStream == null) {
            this.reportOutputStream = Files.newOutputStream(this.reportPath, new OpenOption[0]);
        }
        return this.reportOutputStream;
    }

    public OutputStream getCtmDataOutputStream() throws IOException {
        if (this.updatedCtmDataOutputStream == null) {
            this.updatedCtmDataOutputStream = Files.newOutputStream(this.updatedCtmDataPath, new OpenOption[0]);
        }
        return this.updatedCtmDataOutputStream;
    }

    public OutputStream getLogOutputStream() throws IOException {
        if (this.logOutputStream == null) {
            this.logOutputStream = Files.newOutputStream(this.logFilePath, new OpenOption[0]);
        }
        return this.logOutputStream;
    }

    public Path getLogFilePath() {
        return this.logFilePath;
    }

    public String getPathsUsedDescription() {
        String pathFormat = "%s: %s\n";
        return "Parameters used:\n" + String.format(pathFormat, "maybeInheritedConditionFile", this.maybeInheritedConditionPath) + String.format(pathFormat, "ctmData", this.inputCtmDataPath) + String.format(pathFormat, "outputDirectory", this.outputDirectory);
    }

    @Override
    public void close() {
        this.closeMe(this.maybeInheritedConditionInputStream);
        this.closeMe(this.ctmDataInputStream);
        this.closeMe(this.reportOutputStream);
        this.closeMe(this.updatedCtmDataOutputStream);
        this.closeMe(this.logOutputStream);
    }

    private void closeMe(Closeable toClose) {
        try {
            Closeable closeable = toClose;
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

