/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.maybe.conditions;

import com.bmc.ctmconvert.common.log.Logger;
import com.bmc.ctmconvert.maybe.conditions.ArgumentParser;
import com.bmc.ctmconvert.maybe.conditions.UtilityRunner;
import com.bmc.ctmconvert.maybe.conditions.UtilityStreamRepository;
import org.apache.commons.cli.ParseException;

public class MaybeInheritedConditionFileMain {
    public static void main(String[] args) {
        UtilityStreamRepository streamRepository;
        System.out.println("Running MaybeInheritedCondition ...\r\n");
        ArgumentParser argumentParser = new ArgumentParser();
        try {
            argumentParser.parse(args);
            streamRepository = new UtilityStreamRepository(argumentParser);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            System.out.println("The MaybeInheritedCondition utility uses report from comparison\r\nand data xml files as input files (created by the Conversion Tool\r\nor exported from Control-M).\r\nIt either adds prefix of M- to existing conditions to make them Maybe or\r\nadds new conditions with the prefix of I- to make sure job dependency\r\nwill be maintained, even if some of the jobs in the flow will not be ordered.\r\n\r\nWhen completed, the following files are created:\r\n-\tupdateCtmData.xml: Contains the updated Control-M data with new Condition names.\r\n-\tmaybeInheritedConditionReport.csv: Report on all actions taken by the tool.\r\n\r\nUsage: MaybeInheritedCondition\r\n        -maybeInheritedConditionFile < Mandatory. Path to the input file >\r\n        -ctmData < Mandatory. Path to the Control-M data that contains the input calendars file references > \r\n        [ -outputDirectory <Optional. Path to the directory where MaybeInheritedCondition outputs will be created > ]\r\n");
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        String pathsUsedDescription = streamRepository.getPathsUsedDescription();
        System.out.println(pathsUsedDescription);
        UtilityRunner runner = new UtilityRunner();
        try (UtilityStreamRepository utilityStreamRepository = streamRepository;){
            runner.run(streamRepository);
        }
        catch (Exception e) {
            String generalErrorMessage = String.format("Utility ended with errors, for more information, see %s", streamRepository.getLogFilePath());
            System.out.println(generalErrorMessage);
            Logger.getLogger().writeToLog(e);
            return;
        }
        System.out.println("Utility ended successfully.");
    }
}

