/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.draftanalyzer.criticalpath;

import com.bmc.ctmconvert.draftanalyzer.EntityNode;
import com.bmc.ctmconvert.draftanalyzer.EntityTree;
import com.bmc.ctmconvert.draftanalyzer.TreeHandler;
import com.bmc.ctmconvert.draftanalyzer.criticalpath.CriticalPathFinder;
import com.bmc.ctmconvert.draftanalyzer.criticalpath.CriticalPathReportWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;

public class CriticalPathRunner {
    private EntityTree entityTree;
    private CriticalPathFinder criticalPathFinder;
    private CriticalPathReportWriter criticalPathReportWriter;

    public CriticalPathRunner(InputStream draftInputStream) {
        TreeHandler treeHandler = new TreeHandler();
        this.entityTree = treeHandler.buildEntityTree(draftInputStream);
        this.criticalPathFinder = new CriticalPathFinder(this.entityTree);
        this.criticalPathReportWriter = new CriticalPathReportWriter();
    }

    public void runOverCriticalEntities(List<String> criticalEntities) {
        HashMap<String, String> exceptionEntity2cause = new HashMap<String, String>();
        for (String entityPath : criticalEntities) {
            EntityNode criticalEntity = this.entityTree.getNodeByPath(entityPath);
            if (criticalEntity == null) {
                System.out.println("[SKIP] No such entity: " + entityPath);
                exceptionEntity2cause.put(entityPath, "No such entity in the specified draft");
                continue;
            }
            if (this.entityTree.hasMoreThanOneEntityWithSamePath(criticalEntity)) {
                exceptionEntity2cause.put(entityPath, "There is more than one entity with the same path");
                System.out.println("[SKIP] There is more than one entity with the path: " + entityPath);
                continue;
            }
            this.criticalPathFinder.findCriticalPath(criticalEntity);
            List<EntityNode> predecessorsList = this.criticalPathFinder.getPredecessorsList();
            List<EntityNode> successorsList = this.criticalPathFinder.getSuccessorsList();
            this.criticalPathReportWriter.addEntitiyDependenciesToReport(predecessorsList, successorsList, criticalEntity);
        }
        this.criticalPathReportWriter.addExceptionsToReport(exceptionEntity2cause);
    }

    CriticalPathReportWriter getReportWriter() {
        return this.criticalPathReportWriter;
    }

    public void createReport(OutputStream outputStream) throws IOException {
        this.criticalPathReportWriter.write(outputStream);
    }
}

