/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.draftanalyzer.criticalpath;

import com.bmc.ctmconvert.draftanalyzer.ConditionHandler;
import com.bmc.ctmconvert.draftanalyzer.EntityNode;
import com.bmc.ctmconvert.draftanalyzer.EntityTree;
import com.bmc.ctmconvert.draftanalyzer.criticalpath.DependenciesGetter;
import com.bmc.ctmconvert.draftanalyzer.criticalpath.PredecessorsHandler;
import com.bmc.ctmconvert.draftanalyzer.criticalpath.SuccessorsHandler;
import java.util.ArrayList;
import java.util.List;

public class CriticalPathFinder {
    private EntityTree entityTree;
    private List<EntityNode> predecessorsList = new ArrayList<EntityNode>();
    private List<EntityNode> successorsList = new ArrayList<EntityNode>();

    public CriticalPathFinder(EntityTree entityTree) {
        this.entityTree = entityTree;
    }

    public void findCriticalPath(EntityNode criticalEntity) {
        System.out.println("[INFO] Searching dependencies for entity: " + criticalEntity.getPathAsString());
        ConditionHandler conditionHandler = this.entityTree.getConditionHandler();
        DependenciesGetter dependenciesGetter = new DependenciesGetter();
        PredecessorsHandler predeccesorHandler = new PredecessorsHandler(conditionHandler);
        dependenciesGetter.createDependenciesList(criticalEntity, predeccesorHandler);
        this.predecessorsList = dependenciesGetter.getDependenciesList();
        SuccessorsHandler successorsHandler = new SuccessorsHandler(conditionHandler);
        dependenciesGetter.createDependenciesList(criticalEntity, successorsHandler);
        this.successorsList = dependenciesGetter.getDependenciesList();
    }

    public List<EntityNode> getPredecessorsList() {
        return this.predecessorsList;
    }

    public List<EntityNode> getSuccessorsList() {
        return this.successorsList;
    }
}

