/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.draftanalyzer;

import com.bmc.ctmconvert.draftanalyzer.EntityNode;
import com.bmc.ctmconvert.draftanalyzer.EntityService;
import com.bmc.ctmconvert.draftanalyzer.EntityTree;
import com.bmc.ctmconvert.draftanalyzer.GroupSorter;
import com.bmc.toolbox.compare.condition_compare.DraftPath;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class ValidXmlGroupCreator {
    private EntityService entityService = new EntityService();
    private GroupSorter groupSorter = new GroupSorter();

    public List<List<EntityNode>> createValidGroups(EntityTree entityTree, List<Set<EntityNode>> groupsList) {
        List<List<EntityNode>> sortedList = this.groupSorter.sortSets(groupsList);
        this.addParentsToGroups(sortedList, entityTree);
        this.groupSorter.sortArrays(sortedList);
        return sortedList;
    }

    private void addParentsToGroups(List<List<EntityNode>> groupsList, EntityTree tree) {
        for (List<EntityNode> group : groupsList) {
            Set<DraftPath> missingPaths = this.entityService.getMissingPaths(group);
            Set<EntityNode> missingEntitiesGroup = this.getEntitiesGroup(missingPaths, tree);
            group.addAll(missingEntitiesGroup);
        }
    }

    private Set<EntityNode> getEntitiesGroup(Set<DraftPath> missingPaths, EntityTree tree) {
        TreeSet<EntityNode> entityNodeSet = new TreeSet<EntityNode>();
        for (DraftPath fullPath : missingPaths) {
            String path = fullPath.getPath();
            EntityNode node = tree.getNodeByPath(path);
            if (node == null) continue;
            entityNodeSet.add(node);
        }
        return entityNodeSet;
    }
}

