/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.draftanalyzer;

import com.bmc.ctmconvert.draftanalyzer.EntityNode;
import com.bmc.ctmconvert.draftanalyzer.JobHandler;
import com.bmc.ctmconvert.draftanalyzer.ReaderHandler;
import com.bmc.ctmconvert.draftanalyzer.XmlPredicatorService;
import com.bmc.toolbox.compare.condition_compare.DraftEntityImp;
import com.bmc.toolbox.compare.condition_compare.DraftPath;
import com.bmc.toolbox.compare.condition_compare.draftReader.EntitesCreator;
import com.bmc.toolbox.compare.condition_compare.draftReader.ReaderUtils;
import com.bmc.toolbox.compare.condition_compare.entitites.Job;
import com.bmc.toolbox.compare.condition_compare.entitites.MyAttribute;
import com.bmc.toolbox.compare.condition_compare.entitites.SubFolder;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class SubEntityReader {
    private DraftPath parent;
    private ReaderHandler readerHandler;
    private EntitesCreator entitesCreator;
    private List<MyAttribute> attributes;

    public SubEntityReader(ReaderHandler readerHandler, EntitesCreator entitesCreator) {
        this.readerHandler = readerHandler;
        this.entitesCreator = entitesCreator;
        this.attributes = null;
        this.parent = null;
    }

    public void readSubEntity(XMLEventReader eventReader, EntityNode parentNode) throws XMLStreamException {
        XMLEvent event = eventReader.peek();
        if (XmlPredicatorService.isStartOfJob(event)) {
            this.readJob(eventReader, parentNode);
        }
        if (XmlPredicatorService.isStartOfSubFolder(event)) {
            this.readSubFolder(eventReader, parentNode);
        }
    }

    private void readSubFolder(XMLEventReader eventReader, EntityNode parentNode) throws XMLStreamException {
        XMLEvent subFolderEvent = eventReader.nextEvent();
        this.setup(subFolderEvent, parentNode);
        SubFolder subFolder = this.getSubFolder(subFolderEvent);
        EntityNode subFolderNode = this.read((DraftEntityImp)subFolder, eventReader, parentNode);
        this.readerHandler.setFolderOSType(subFolderNode, this.attributes);
    }

    private void readJob(XMLEventReader eventReader, EntityNode parentNode) throws XMLStreamException {
        XMLEvent jobEvent = eventReader.nextEvent();
        this.setup(jobEvent, parentNode);
        JobHandler jobhandler = new JobHandler(this.attributes, this.readerHandler, this.entitesCreator);
        Job job = jobhandler.getJob(jobEvent, this.parent);
        EntityNode jobNode = this.read((DraftEntityImp)job, eventReader, parentNode);
        jobhandler.setJobOs(jobNode);
    }

    private void setup(XMLEvent event, EntityNode parentNode) {
        this.parent = parentNode.getDraftEntityImp().getPath();
        this.attributes = ReaderUtils.getEventAttributes((XMLEvent)event);
    }

    private EntityNode read(DraftEntityImp entityImp, XMLEventReader eventReader, EntityNode parentNode) throws XMLStreamException {
        EntityNode subNode = new EntityNode(entityImp, parentNode);
        this.readerHandler.readDescendants(eventReader, subNode);
        parentNode.addChild(subNode);
        return subNode;
    }

    private SubFolder getSubFolder(XMLEvent subFolderEvent) {
        String subFolderName = this.readerHandler.getValueFromAttributeList("JOBNAME", this.attributes);
        DraftPath subFolderPath = new DraftPath(subFolderName, this.parent);
        return this.entitesCreator.createSubFolder(subFolderEvent, subFolderPath);
    }
}

