/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.draftanalyzer;

import com.bmc.ctmconvert.draftanalyzer.EntityNode;
import com.bmc.toolbox.compare.condition_compare.DraftPath;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EntityService {
    public Set<DraftPath> getMissingPaths(List<EntityNode> group) {
        HashSet<DraftPath> missingPaths = new HashSet<DraftPath>();
        Set<DraftPath> existingPaths = this.getExistingDraftPathsGroup(group);
        for (DraftPath draftPath : existingPaths) {
            if (!draftPath.hasParent()) continue;
            Set<DraftPath> missingEntities = this.getMissingEntitiesInDraftPath(draftPath, existingPaths);
            missingPaths.addAll(missingEntities);
        }
        return missingPaths;
    }

    public Set<DraftPath> getExistingDraftPathsGroup(List<EntityNode> nodeList) {
        HashSet<DraftPath> existingDraftPaths = new HashSet<DraftPath>();
        if (nodeList == null) {
            return existingDraftPaths;
        }
        for (EntityNode entityNode : nodeList) {
            existingDraftPaths.add(entityNode.getDraftPath());
        }
        return existingDraftPaths;
    }

    private Set<DraftPath> getMissingEntitiesInDraftPath(DraftPath draftPath, Set<DraftPath> existingPaths) {
        HashSet<DraftPath> missingPaths = new HashSet<DraftPath>();
        List listOfPredecessors = draftPath.getListOfPredecessors();
        for (DraftPath predecessor : listOfPredecessors) {
            if (existingPaths.contains(predecessor)) continue;
            missingPaths.add(predecessor);
        }
        return missingPaths;
    }
}

