/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.draftanalyzer;

import com.bmc.ctmconvert.draftanalyzer.EntityNode;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class CsvHandler {
    public void createGroupsReport(String fileName, List<List<EntityNode>> validatedGroups) throws IOException {
        String FILE_HEADER = "Group,Entity,Type,OS,Number of Entities";
        String COMMA_DELIMITER = ",";
        String NEW_LINE_SEPARATOR = "\n";
        String groupTitle = "Group";
        FileWriter fileWriter = new FileWriter(fileName);
        fileWriter.append(FILE_HEADER.toString());
        fileWriter.append(NEW_LINE_SEPARATOR);
        int groupsCounter = 1;
        for (List<EntityNode> group : validatedGroups) {
            String groupName = groupTitle + "_" + groupsCounter;
            String groupID = groupName + ",,,," + group.size();
            fileWriter.append(groupID);
            fileWriter.append(NEW_LINE_SEPARATOR);
            for (EntityNode dividedEntityNode : group) {
                fileWriter.append(groupName);
                fileWriter.append(COMMA_DELIMITER);
                fileWriter.append(dividedEntityNode.getPathAsString());
                fileWriter.append(COMMA_DELIMITER);
                fileWriter.append(dividedEntityNode.getType());
                fileWriter.append(COMMA_DELIMITER);
                fileWriter.append(dividedEntityNode.getOsType());
                fileWriter.append(NEW_LINE_SEPARATOR);
            }
            ++groupsCounter;
        }
        try {
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException e) {
            System.out.println("Error while flushing/closing fileWriter !!!");
            e.printStackTrace();
        }
    }
}

