/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.draftanalyzer;

import com.bmc.ctmconvert.draftanalyzer.DivideConfigManager;
import com.bmc.ctmconvert.draftanalyzer.EntityNode;
import com.bmc.toolbox.compare.condition_compare.DraftEntityImp;
import com.bmc.toolbox.compare.condition_compare.entitites.DoCond;
import com.bmc.toolbox.compare.condition_compare.entitites.InCondition;
import com.bmc.toolbox.compare.condition_compare.entitites.On;
import com.bmc.toolbox.compare.condition_compare.entitites.OutCondition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConditionHandler {
    private HashMap<String, List<EntityNode>> inConditionsMap = new HashMap();
    private HashMap<String, List<EntityNode>> outConditionsMap = new HashMap();
    private HashMap<String, List<EntityNode>> doConditionsMap = new HashMap();

    public void readAllEntityConditions(EntityNode entityNode) {
        this.readInConditions(entityNode);
        this.readOutConditions(entityNode);
        this.readOnDoConditions(entityNode);
    }

    private List<InCondition> getInConditions(EntityNode entityNode) {
        return entityNode.getDraftEntityImp().getInConditions();
    }

    private List<OutCondition> getOutConditions(EntityNode entityNode) {
        return entityNode.getDraftEntityImp().getOutConditions();
    }

    private Map<On, List<DoCond>> getOndo(EntityNode entityNode) {
        return entityNode.getDraftEntityImp().getOndo();
    }

    private void readInConditions(EntityNode entityNode) {
        for (InCondition inCondition : this.getInConditions(entityNode)) {
            this.addConditionToList(inCondition.getName(), this.inConditionsMap, entityNode);
        }
    }

    private void readOutConditions(EntityNode entityNode) {
        for (OutCondition outCondition : this.getOutConditions(entityNode)) {
            this.addConditionToList(outCondition.getName(), this.outConditionsMap, entityNode);
        }
    }

    private void readOnDoConditions(EntityNode entityNode) {
        for (List<DoCond> onDo : this.getOndo(entityNode).values()) {
            for (DoCond doCond : onDo) {
                this.addConditionToList(doCond.getName(), this.doConditionsMap, entityNode);
            }
        }
    }

    private void addConditionToList(String condName, HashMap<String, List<EntityNode>> condMap, EntityNode entityNode) {
        List ConditionList = condMap.computeIfAbsent(condName, k -> new ArrayList());
        ConditionList.add(entityNode);
    }

    private boolean hasMatchingCondition(Set<String> conditionsNameSet, HashMap<String, List<EntityNode>> condMap) {
        for (String conditionName : conditionsNameSet) {
            if (condMap.get(conditionName) == null) continue;
            return true;
        }
        return false;
    }

    private boolean hasMatchConditions(DraftEntityImp draftEntityImp) {
        Set inConditionNameSet = draftEntityImp.getInConditionGroupName();
        Set outConditionNameSet = draftEntityImp.getOutConditionGroupName();
        Set onDoConditionNameSet = draftEntityImp.getOnDoConditionGroupName();
        if (this.hasMatchingCondition(inConditionNameSet, this.outConditionsMap)) {
            return true;
        }
        if (this.hasMatchingCondition(inConditionNameSet, this.doConditionsMap)) {
            return true;
        }
        if (this.hasMatchingCondition(outConditionNameSet, this.inConditionsMap)) {
            return true;
        }
        return this.hasMatchingCondition(onDoConditionNameSet, this.inConditionsMap);
    }

    public boolean hasConditions(DraftEntityImp draftEntityImp) {
        boolean hasConditions;
        boolean ignoreNoMatchConditions = DivideConfigManager.getInstance().isIgnoreNoMatchConditions();
        boolean hasInConditions = !draftEntityImp.getInConditions().isEmpty();
        boolean hasOutConditions = !draftEntityImp.getOutConditions().isEmpty();
        boolean hasDoConds = !draftEntityImp.getOndo().isEmpty();
        boolean bl = hasConditions = hasInConditions || hasOutConditions || hasDoConds;
        return hasConditions ? (ignoreNoMatchConditions ? this.hasMatchConditions(draftEntityImp) : true) : false;
    }

    public HashMap<String, List<EntityNode>> getInConditionMap() {
        return this.inConditionsMap;
    }

    public HashMap<String, List<EntityNode>> getOutConditionMap() {
        return this.outConditionsMap;
    }

    public HashMap<String, List<EntityNode>> getOnDoConditionMap() {
        return this.doConditionsMap;
    }
}

