/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.calendars.find.duplicate.rbcs;

import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.ArgumentParser;
import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.DuplicateRbcException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class UtilityStreamRepository {
    protected static final String DEFAULT_OUTPUT_DIR = "./output";
    protected static final String REPORT_FILE_NAME = "calDuplicatesRemovalReport.xlsx";
    protected static final String CTM_DATA_FILE_NAME = "updateCtmData.xml";
    protected static final String CALENDERS_FILE_NAME = "updateCalendars.xml";
    protected static final String LOG_FILE_NAME = "log.txt";
    private String outputDirectory;
    private InputStream calendarInputStream;
    private InputStream ctmDataInputStream;
    private Path reportPath;
    private Path updatedCtmDataPath;
    private Path updatedCalendersPath;
    private Path logFilePath;
    private OutputStream logOutputStream;
    private OutputStream reportOutputStream;
    private OutputStream updatedCtmDataOutputStream;
    private OutputStream updatedCalendersOutputStream;
    private Path inputCalendarPath;
    private Path inputCtmDataPath;
    private final FileSystem fileSystem;

    public UtilityStreamRepository(ArgumentParser argumentParser, FileSystem fileSystem) throws Exception {
        this.fileSystem = fileSystem;
        this.buildStreamsFromArgs(argumentParser);
    }

    public UtilityStreamRepository(ArgumentParser argumentParser) throws Exception {
        this(argumentParser, FileSystems.getDefault());
    }

    private void buildStreamsFromArgs(ArgumentParser argumentParser) throws Exception {
        String calendarFile = argumentParser.getArgValue("calendarFile");
        String ctmDataFile = argumentParser.getArgValue("ctmData");
        this.outputDirectory = this.createOutputFolder(argumentParser.getArgValue("outputDirectory"));
        this.inputCalendarPath = this.fileSystem.getPath(calendarFile, new String[0]);
        this.calendarInputStream = Files.newInputStream(this.inputCalendarPath, new OpenOption[0]);
        this.inputCtmDataPath = this.fileSystem.getPath(ctmDataFile, new String[0]);
        this.ctmDataInputStream = Files.newInputStream(this.inputCtmDataPath, new OpenOption[0]);
        this.reportPath = this.fileSystem.getPath(this.outputDirectory, REPORT_FILE_NAME);
        this.updatedCtmDataPath = this.fileSystem.getPath(this.outputDirectory, CTM_DATA_FILE_NAME);
        this.updatedCalendersPath = this.fileSystem.getPath(this.outputDirectory, CALENDERS_FILE_NAME);
        this.logFilePath = this.fileSystem.getPath(this.outputDirectory, LOG_FILE_NAME);
    }

    private String createOutputFolder(String outputFolder) throws IOException, DuplicateRbcException {
        Path outputPath;
        if (outputFolder == null || outputFolder.isEmpty()) {
            outputFolder = DEFAULT_OUTPUT_DIR;
            outputPath = this.fileSystem.getPath(outputFolder, new String[0]);
            if (!Files.isDirectory(outputPath, new LinkOption[0])) {
                Files.createDirectory(outputPath, new FileAttribute[0]);
            }
        } else {
            outputPath = this.fileSystem.getPath(outputFolder, new String[0]);
            if (!Files.isDirectory(outputPath, new LinkOption[0])) {
                throw new DuplicateRbcException("Invalid Output destination path (should represent directory)");
            }
        }
        return outputPath.toAbsolutePath().toString();
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public InputStream getCalendarInputStream() {
        return this.calendarInputStream;
    }

    public InputStream getCtmDataInputStream() {
        return this.ctmDataInputStream;
    }

    public OutputStream getReportOutputStream() throws IOException {
        if (this.reportOutputStream == null) {
            this.reportOutputStream = Files.newOutputStream(this.reportPath, new OpenOption[0]);
        }
        return this.reportOutputStream;
    }

    public OutputStream getCtmDataOutputStream() throws IOException {
        if (this.updatedCtmDataOutputStream == null) {
            this.updatedCtmDataOutputStream = Files.newOutputStream(this.updatedCtmDataPath, new OpenOption[0]);
        }
        return this.updatedCtmDataOutputStream;
    }

    public OutputStream getCalendersOutputStream() throws IOException {
        if (this.updatedCalendersOutputStream == null) {
            this.updatedCalendersOutputStream = Files.newOutputStream(this.updatedCalendersPath, new OpenOption[0]);
        }
        return this.updatedCalendersOutputStream;
    }

    public OutputStream getLogOutputStream() throws IOException {
        if (this.logOutputStream == null) {
            this.logOutputStream = Files.newOutputStream(this.logFilePath, new OpenOption[0]);
        }
        return this.logOutputStream;
    }

    public Path getReportPath() {
        return this.reportPath;
    }

    public Path getUpdatedCtmDataPath() {
        return this.updatedCtmDataPath;
    }

    public Path getUpdatedCalendersPath() {
        return this.updatedCalendersPath;
    }

    public Path getLogFilePath() {
        return this.logFilePath;
    }

    public Path getInputCalendarPath() {
        return this.inputCalendarPath;
    }

    public Path getInputCtmDataPath() {
        return this.inputCtmDataPath;
    }

    public String getPathsUsedDescription() {
        String pathFormat = "%s: %s\n";
        return "Parameters used:\n" + String.format(pathFormat, "calendarFile", this.inputCalendarPath) + String.format(pathFormat, "ctmData", this.inputCtmDataPath) + String.format(pathFormat, "outputDirectory", this.outputDirectory);
    }

    public void closeStreams() {
        try {
            if (this.calendarInputStream != null) {
                this.calendarInputStream.close();
            }
            if (this.ctmDataInputStream != null) {
                this.ctmDataInputStream.close();
            }
            if (this.reportOutputStream != null) {
                this.reportOutputStream.close();
            }
            if (this.updatedCtmDataOutputStream != null) {
                this.updatedCtmDataOutputStream.close();
            }
            if (this.updatedCalendersOutputStream != null) {
                this.updatedCalendersOutputStream.close();
            }
            if (this.logOutputStream != null) {
                this.logOutputStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

