/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.calendars.find.duplicate.rbcs;

import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.CalendarXmlElement;
import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.RbcItem;
import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.UtilityConstants;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.excel.ActionItem;
import com.bmc.ctmconvert.excel.ExcelWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DuplicateRbcReportHandler {
    private final Map<CalendarXmlElement, List<String>> uniqueRuleBasedCalendarsMap;
    private final Map<XmlElement, List<String>> uniqueRegularCalendarsMap;

    public DuplicateRbcReportHandler(Map<CalendarXmlElement, List<String>> uniqueRuleBasedCalendarsMap, Map<XmlElement, List<String>> uniqueRegularCalendarsMap) {
        this.uniqueRuleBasedCalendarsMap = uniqueRuleBasedCalendarsMap;
        this.uniqueRegularCalendarsMap = uniqueRegularCalendarsMap;
    }

    public void writeReport(OutputStream reportOutputStream) throws IOException {
        ArrayList<ActionItem> rbcActionItemsList = new ArrayList<ActionItem>();
        ArrayList<ActionItem> rbcActionSummaryItemsList = new ArrayList<ActionItem>();
        this.getActionItemListAndSummary(this.uniqueRuleBasedCalendarsMap, rbcActionItemsList, rbcActionSummaryItemsList);
        ArrayList<ActionItem> regularActionItemsList = new ArrayList<ActionItem>();
        ArrayList<ActionItem> regularActionSummaryItemsList = new ArrayList<ActionItem>();
        this.getActionItemListAndSummary(this.uniqueRegularCalendarsMap, regularActionItemsList, regularActionSummaryItemsList);
        this.write(reportOutputStream, rbcActionItemsList, rbcActionSummaryItemsList, regularActionItemsList, regularActionSummaryItemsList);
    }

    private <T extends XmlElement> void getActionItemListAndSummary(Map<T, List<String>> uniqueMap, List<ActionItem> actionItems, List<ActionItem> actionSummaryItemsList) {
        uniqueMap.forEach((key, value) -> {
            value.forEach(name -> {
                RbcItem rbcItem = new RbcItem(key.getAttribute("NAME"), (String)name, value.size());
                actionItems.add(rbcItem);
            });
            RbcItem rbcSummaryItem = new RbcItem(key.getAttribute("NAME"), value.size());
            actionSummaryItemsList.add(rbcSummaryItem);
        });
    }

    private void write(OutputStream reportOutputStream, List<ActionItem> rbcItemsList, List<ActionItem> rbcSummaryItemsList, List<ActionItem> regularItemsList, List<ActionItem> regularSummaryItemsList) throws IOException {
        ExcelWriter excelWriter = new ExcelWriter();
        excelWriter.addSheet("RBC Distribution", UtilityConstants.RBC_DISTRIBUTION_SHEET_HEADERS);
        excelWriter.addRowsToSheet(rbcItemsList, 0);
        excelWriter.addSheet("Summary", UtilityConstants.SUMMARY_SHEET_HEADERS);
        excelWriter.addRowsToSheet(rbcSummaryItemsList, 1);
        excelWriter.addSheet("Calendar Distribution", UtilityConstants.REGULAR_DISTRIBUTION_SHEET_HEADERS);
        excelWriter.addRowsToSheet(regularItemsList, 2);
        excelWriter.addSheet("Regular Summary", UtilityConstants.REGULAR_SUMMARY_SHEET_HEADERS);
        excelWriter.addRowsToSheet(regularSummaryItemsList, 3);
        excelWriter.writeReport(reportOutputStream);
    }
}

