/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.calendars.find.duplicate.rbcs;

import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.DuplicateRbcException;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.log.Logger;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.common.xml.XmlLoader;
import com.bmc.ctmconvert.common.xml.predicates.ComparablePredicate;
import com.bmc.ctmconvert.workspace.IWorkspaceData;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class CtmDataParser
implements IWorkspaceData {
    private XmlElement shallowRootElement;
    private final List<XmlElement> folders = new ArrayList<XmlElement>();

    public void parse(InputStream dataInputStream) throws DuplicateRbcException {
        XmlElement doc;
        try {
            doc = XmlLoader.from((InputStream)dataInputStream);
        }
        catch (Exception e) {
            Logger.getLogger().writeToLog(e);
            throw new DuplicateRbcException("Failed to parse Control-M data.");
        }
        this.shallowRootElement = new XmlElement((Element)doc.getElement().getOwnerDocument().importNode(doc.getElement(), false));
        List result = doc.filterAndReturnXmlElement(this.getFolderFilter());
        this.folders.addAll(result);
    }

    private ComparablePredicate getFolderFilter() {
        return new ComparablePredicate(this){

            public boolean testImpl(Element fld) {
                return fld.getTagName().equals(SchedEntity.TYPE.SMART_FOLDER.name()) || fld.getTagName().equals("FOLDER");
            }
        };
    }

    public String getHeaderName() {
        return "DEFTABLE";
    }

    public Map<String, String> getHeaderAttributes() {
        return this.shallowRootElement.getAttributes();
    }

    public List<XmlElement> getFolders() {
        return this.folders;
    }

    public Element getRootElement() {
        return this.shallowRootElement.getElement();
    }
}

