/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.calendars.find.duplicate.rbcs;

import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.CalendarXmlElement;
import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.DuplicateRbcException;
import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.RegularCalendarXmlElement;
import com.bmc.ctmconvert.common.log.Logger;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.workspace.IWorkspaceData;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CalendarsXmlParser
implements IWorkspaceData {
    private List<CalendarXmlElement> calendars = new ArrayList<CalendarXmlElement>();
    private String headerName = "DEFCAL";
    private XmlElement shallowRootElement;
    private List<XmlElement> regularCalendars = new ArrayList<XmlElement>();

    public void parse(InputStream calendarsInputStream) throws DuplicateRbcException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            dbFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            doc = dBuilder.parse(calendarsInputStream);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Logger.getLogger().writeToLog(e);
            throw new DuplicateRbcException("Failed to parse calendars file.");
        }
        doc.getDocumentElement().normalize();
        Node rootElement = doc.getElementsByTagName(this.headerName).item(0);
        this.shallowRootElement = new CalendarXmlElement((Element)doc.importNode(rootElement, false));
        this.loadRuleBasedCalendars(doc);
        this.loadOtherCalendars(doc);
    }

    private void loadOtherCalendars(Document doc) {
        NodeList tempCalendarsNodes = doc.getElementsByTagName("CALENDAR");
        for (int i = 0; i < tempCalendarsNodes.getLength(); ++i) {
            RegularCalendarXmlElement element = new RegularCalendarXmlElement((Element)tempCalendarsNodes.item(i));
            this.regularCalendars.add(element);
        }
    }

    private void loadRuleBasedCalendars(Document doc) {
        NodeList tempCalendarsNodes = doc.getElementsByTagName("RULE_BASED_CALENDAR");
        for (int i = 0; i < tempCalendarsNodes.getLength(); ++i) {
            CalendarXmlElement element = new CalendarXmlElement((Element)tempCalendarsNodes.item(i));
            this.calendars.add(element);
        }
    }

    public List<CalendarXmlElement> getRuleBasedCalendars() {
        return this.calendars;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public Map<String, String> getHeaderAttributes() {
        return this.shallowRootElement.getAttributes();
    }

    public List<XmlElement> getRegularCalendars() {
        return this.regularCalendars;
    }

    public Element getRootElement() {
        return this.shallowRootElement.getElement();
    }
}

