/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.oozie;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.oozie.OozieEntity;
import com.bmc.ctmconvert.oozie.OozieProperties;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OozieHierarchyMapping {
    private static OozieHierarchyMapping instance;
    private static String datasource;
    private Properties filesMapping;
    private Pattern variablePattern = Pattern.compile("\\$\\{(.*?)\\}");
    private final String coordinatorDefault = "coordinator.xml";
    private final String workflowDefault = "workflow.xml";
    private HashMap<String, HashMap<String, ArrayList<OozieEntity>>> parentsMap = new HashMap();
    private HashMap<String, HashMap<String, ArrayList<OozieEntity>>> childrenMap = new HashMap();
    private HashMap<String, OozieEntity> subEorkflowActionNameToEntityMap = new HashMap();

    public static OozieHierarchyMapping instance() {
        String datasourceName = Params.instance().getDatasourceName();
        if (instance == null || !datasourceName.equals(datasource)) {
            datasource = datasourceName;
            instance = new OozieHierarchyMapping();
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    public HashMap<String, ArrayList<OozieEntity>> getParentsMap(String entityType) {
        return this.parentsMap.get(entityType);
    }

    public HashMap<String, ArrayList<OozieEntity>> getChildrenMap(String entityType) {
        return this.childrenMap.get(entityType);
    }

    public ArrayList<OozieEntity> getEntityParents(String entityType, String entityFileName) {
        return this.getParentsMap(entityType).get(entityFileName);
    }

    public ArrayList<OozieEntity> getEntityChildrens(String entityType, String entityFileName) {
        return this.getChildrenMap(entityType).get(entityFileName);
    }

    private OozieHierarchyMapping() {
        this.filesMapping = new Properties();
        try {
            this.filesMapping.load(new FileReader(Params.instance().getDatasourcePath() + "filesMapping.properties"));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mapEntities("bundle", "coordinator", "coordinator.xml");
        this.mapEntities("coordinator", "workflow", "workflow.xml");
        this.mapEntities("workflow", "workflow", "workflow.xml");
    }

    private void mapEntities(String parentType, String childType, String entityDefaultFileName) {
        File entityDirectory;
        HashMap<String, ArrayList<OozieEntity>> currntChildrenMap;
        HashMap<String, ArrayList<OozieEntity>> currntParentsMap = this.parentsMap.get(childType);
        if (currntParentsMap == null) {
            currntParentsMap = new HashMap();
        }
        if ((currntChildrenMap = this.childrenMap.get(parentType)) == null) {
            currntChildrenMap = new HashMap();
        }
        if ((entityDirectory = new File(Params.instance().getDatasourcePath() + parentType)).exists() && entityDirectory.isDirectory()) {
            for (File file : entityDirectory.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".xml")) continue;
                OozieEntity parentEntity = new OozieEntity(file);
                OozieProperties entityProperties = null;
                try {
                    entityProperties = new OozieProperties(file.getAbsolutePath().replace(".xml", ".properties"), this.getParenProperties(parentType, file.getName()));
                }
                catch (FileNotFoundException e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                }
                catch (IOException e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                }
                NodeList children = parentEntity.getEntitiyData().getElementsByTagName("app-path");
                for (int i = 0; i < children.getLength(); ++i) {
                    String childPath = children.item(i).getTextContent();
                    if (entityProperties != null) {
                        Matcher matcher = this.variablePattern.matcher(childPath);
                        while (matcher.find()) {
                            String value = entityProperties.getResolvedProperty(matcher.group(1));
                            if (value == null) continue;
                            childPath = childPath.replace(matcher.group(0), value);
                        }
                    }
                    if (childPath.endsWith(entityDefaultFileName)) {
                        childPath = childPath.replace(entityDefaultFileName, "");
                    }
                    String[] childPathParts = childPath.split("[\\/]+");
                    int maxEqual = 0;
                    String bestMatchChildName = "";
                    OozieEntity childEntity = null;
                    block6: for (String childMapName : this.filesMapping.stringPropertyNames()) {
                        if (!childMapName.matches(childType + "-\\d+\\.xml")) continue;
                        String childMapPath = this.filesMapping.getProperty(childMapName);
                        if (childMapPath.endsWith(entityDefaultFileName)) {
                            childMapPath = childMapPath.replace(entityDefaultFileName, "");
                        }
                        String[] mapFileParts = childMapPath.split("[\\\\/]+");
                        int max = Math.max(childPathParts.length, mapFileParts.length);
                        for (int j = 1; j < max; ++j) {
                            if (mapFileParts[mapFileParts.length - j].equals(childPathParts[childPathParts.length - j])) continue;
                            if (j <= 1 || j <= maxEqual) continue block6;
                            maxEqual = j - 1;
                            bestMatchChildName = childMapName;
                            childEntity = new OozieEntity(new File(Params.instance().getDatasourcePath() + childType + Globs.DIRSEP + childMapName));
                            continue block6;
                        }
                    }
                    if (children.item(i).getParentNode().getNodeName().equals("sub-workflow")) {
                        Element parentElement = (Element)children.item(i).getParentNode().getParentNode();
                        this.subEorkflowActionNameToEntityMap.put(parentElement.getAttribute("name"), childEntity);
                    }
                    this.addToMap(currntParentsMap, bestMatchChildName, parentEntity);
                    this.addToMap(currntChildrenMap, parentEntity.getEntityFile().getName(), childEntity);
                }
            }
        }
        this.parentsMap.put(childType, currntParentsMap);
        this.childrenMap.put(parentType, currntChildrenMap);
    }

    public OozieProperties getProperties(File entityFile, String entityType) throws FileNotFoundException, IOException {
        return new OozieProperties(entityFile.getAbsolutePath().replace(".xml", ".properties"), this.getParenProperties(entityType, entityFile.getName()));
    }

    private OozieProperties getParenProperties(String parentType, String parentFileName) {
        OozieProperties parentProperties = null;
        try {
            String path = null;
            if (!parentType.equals("bundle")) {
                ArrayList<OozieEntity> parentsList = this.parentsMap.get(parentType).get(parentFileName);
                if (parentsList != null) {
                    path = parentsList.get(0).getEntityFile().getAbsolutePath();
                    if (path != null) {
                        path = path.replace(".xml", ".properties");
                    }
                    parentProperties = new OozieProperties(path, this.getParenProperties(parentsList.get(0).getEntityApplicationType(), parentsList.get(0).getEntityFile().getName()));
                } else {
                    parentProperties = new OozieProperties(path);
                }
            } else {
                parentProperties = new OozieProperties(path);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return parentProperties;
    }

    public OozieEntity getSubWorkflowEntity(String actionName) {
        return this.subEorkflowActionNameToEntityMap.get(actionName);
    }

    private void addToMap(HashMap<String, ArrayList<OozieEntity>> map, String key, OozieEntity item) {
        ArrayList<OozieEntity> list = map.get(key);
        if (list == null) {
            list = new ArrayList();
        }
        list.add(item);
        map.put(key, list);
    }

    static {
        datasource = "";
    }
}

