/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.oozie;

import com.bmc.ctmconvert.common.ExceptionHandler;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class OozieEntity {
    private String entitiyName;
    private String entityApplicationType;
    private File entityFile;
    private Element entityData;

    public OozieEntity(File data) {
        this.entityFile = data;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = parser.parse(data);
            this.entityData = document.getDocumentElement();
            this.entitiyName = this.entityData.getAttribute("name");
            this.entityApplicationType = this.entityData.getNodeName();
            if (this.entityApplicationType.endsWith("-app")) {
                this.entityApplicationType = this.entityApplicationType.toLowerCase().substring(0, this.entityApplicationType.indexOf("-app"));
            }
        }
        catch (ParserConfigurationException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        catch (SAXException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    public OozieEntity(Element data, String name) {
        this.entityData = data;
        this.entitiyName = name;
        this.entityApplicationType = this.entityData.getNodeName();
    }

    public String getEntitiyName() {
        return this.entitiyName;
    }

    public Element getEntitiyData() {
        return this.entityData;
    }

    public File getEntityFile() {
        return this.entityFile;
    }

    public String getEntityApplicationType() {
        return this.entityApplicationType;
    }

    public String toString() {
        return this.getEntityFile().getName();
    }
}

