/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.oozie;

import com.bmc.ctmconvert.common.AttrHolder;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.oozie.OozieEntity;
import com.bmc.ctmconvert.oozie.OozieHierarchyMapping;
import com.bmc.ctmconvert.oozie.OozieJob;
import com.bmc.ctmconvert.oozie.RbcGenerator;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OozieDefs
implements SourceDefinitions {
    private AttrHolderList top_level_parents;
    private ArrayList<String> messages = new ArrayList();
    private RulesDataSet oozieRules = RuleManager.instance().getCurrentRules();
    private HashMap<String, LinkedHashSet<Properties>> inCondMap;
    private HashMap<String, LinkedHashSet<Properties>> outCondCondMap;

    public OozieDefs() {
        Params.instance().setFirstDayOfTheWeek(this.oozieRules.getStringRule("Oozie rules", new String[]{"FIRST_DAY_OF_WEEK"}));
    }

    public AttrHolderList getTopLevelEntities() {
        this.top_level_parents = new AttrHolderList();
        HashMap header = AttrHolder.buildHeadersMap((String)"TYPE,NAME");
        HashMap<String, String> filterDetails = new HashMap<String, String>();
        for (String name : OozieHierarchyMapping.instance().getChildrenMap("coordinator").keySet()) {
            filterDetails.put("Coordinator name", name);
            if (!this.oozieRules.getFilterHandler().isFilter(filterDetails)) continue;
            this.top_level_parents.add((Object)new AttrHolder(new String[]{"coordinator", name}, (Map)header));
        }
        HashMap<String, ArrayList<OozieEntity>> workflowParentsMap = OozieHierarchyMapping.instance().getParentsMap("workflow");
        File workflowsDirectory = new File(Params.instance().getDatasourcePath() + "workflow");
        if (workflowsDirectory.exists() && workflowsDirectory.listFiles() != null) {
            for (File file : workflowsDirectory.listFiles()) {
                String name = file.getName();
                if (!name.endsWith(".xml")) continue;
                filterDetails.put("Workflow name", name);
                if (!this.oozieRules.getFilterHandler().isFilter(filterDetails) || workflowParentsMap.containsKey(name) && !workflowParentsMap.get(name).isEmpty()) continue;
                this.top_level_parents.add((Object)new AttrHolder(new String[]{"workflow", name}, (Map)header));
            }
        }
        return this.top_level_parents;
    }

    private void mapWorkFlowConditions() {
        File workFlowDir = new File(Params.instance().getDatasourcePath() + "workflow");
        if (workFlowDir.isDirectory()) {
            this.inCondMap = new HashMap();
            this.outCondCondMap = new HashMap();
            File[] workFlowFiles = workFlowDir.listFiles();
            for (int i = 0; i < workFlowFiles.length; ++i) {
                if (!workFlowFiles[i].getName().toLowerCase().endsWith(".xml")) continue;
                this.mapXmlToConds(workFlowFiles[i]);
            }
        }
    }

    private HashMap<String, ArrayList<String>> mapSkippedNodes(Document workFlowDoc) {
        HashMap skipMap = null;
        NodeList forkNodes = workFlowDoc.getElementsByTagName("fork");
        for (int i = 0; i < forkNodes.getLength(); ++i) {
            if (skipMap == null) {
                skipMap = new HashMap();
            }
            String skipOver = forkNodes.item(i).getAttributes().getNamedItem("name").getNodeValue();
            skipMap.put(skipOver, new ArrayList());
            NodeList skipTo = ((Element)forkNodes.item(i)).getElementsByTagName("path");
            for (int j = 0; j < skipTo.getLength(); ++j) {
                String to = skipTo.item(j).getAttributes().getNamedItem("start").getNodeValue();
                ((ArrayList)skipMap.get(skipOver)).add(to);
            }
        }
        if (skipMap != null) {
            NodeList joinNodes = workFlowDoc.getElementsByTagName("join");
            for (int i = 0; i < joinNodes.getLength(); ++i) {
                String skipOver = joinNodes.item(i).getAttributes().getNamedItem("name").getNodeValue();
                String skipTo = joinNodes.item(i).getAttributes().getNamedItem("to").getNodeValue();
                if (!skipMap.containsKey(skipOver)) {
                    skipMap.put(skipOver, new ArrayList());
                }
                ((ArrayList)skipMap.get(skipOver)).add(skipTo);
            }
        }
        return skipMap;
    }

    private void mapXmlToConds(File workFlowXml) {
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = parser.parse(workFlowXml);
            HashMap<String, ArrayList<String>> skipMap = this.mapSkippedNodes(document);
            this.nodeListToConds("ok", document.getElementsByTagName("ok"), skipMap);
            this.nodeListToConds("error", document.getElementsByTagName("error"), skipMap);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    private void nodeListToConds(String condStatus, NodeList nodes, HashMap<String, ArrayList<String>> skipMap) {
        String workFlowName = "";
        if (nodes.getLength() > 0) {
            workFlowName = ((Element)nodes.item(0).getParentNode().getParentNode()).getAttribute("name");
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            ArrayList<Object> toList;
            String to = ((Element)nodes.item(i)).getAttribute("to");
            String sender = ((Element)nodes.item(i).getParentNode()).getAttribute("name");
            if (skipMap != null && skipMap.containsKey(to)) {
                toList = skipMap.get(to);
            } else {
                toList = new ArrayList<String>();
                toList.add(to);
            }
            for (String string : toList) {
                String inCondKey = String.format("%s/%s", workFlowName, string);
                String outCondKey = String.format("%s/%s", workFlowName, sender);
                if (!this.inCondMap.containsKey(inCondKey)) {
                    this.inCondMap.put(inCondKey, new LinkedHashSet());
                }
                this.inCondMap.get(inCondKey).add(this.valuesToIncond(sender, string, condStatus));
                if (!this.outCondCondMap.containsKey(outCondKey)) {
                    this.outCondCondMap.put(outCondKey, new LinkedHashSet());
                }
                this.outCondCondMap.get(outCondKey).add(this.valuesToOutcond(sender, string, condStatus));
            }
        }
    }

    private Properties valuesToOutcond(String sender, String to, String status) {
        String condName = this.createCondName(sender, to, status);
        Properties toRet = new Properties();
        toRet.setProperty("NAME", condName);
        toRet.setProperty("ODATE", "ODAT");
        toRet.setProperty("SIGN", "ADD");
        if (status.equalsIgnoreCase("ok")) {
            toRet.setProperty("CTM_OUT_TYPE", "COND");
        } else {
            toRet.setProperty("CTM_OUT_TYPE", "ON_STMT");
            toRet.put("STMT", "*");
            toRet.put("CODE", "NOTOK");
            toRet.put("ACTION", "DOCOND");
        }
        return toRet;
    }

    private String createCondName(String sender, String to, String status) {
        String condConv = this.oozieRules.getStringRule("Oozie rules", new String[]{"CONDITION_NAME"});
        String condName = condConv.equals("JOBA_JOBB") ? String.format("%s-TO-%s", sender, to) : String.format("%s-ENDED-%s", sender, status);
        return condName;
    }

    private Properties valuesToIncond(String sender, String to, String status) {
        String condName = this.createCondName(sender, to, status);
        Properties toRet = new Properties();
        toRet.setProperty("NAME", condName);
        toRet.setProperty("AND_OR", "AND");
        toRet.setProperty("ODATE", "ODAT");
        return toRet;
    }

    public AttrHolderList getChildren(String parentEntityId) {
        return null;
    }

    public void finalize_() {
        RbcGenerator.destroy();
    }

    public void init() throws ConvertorCancelClickException {
        this.mapWorkFlowConditions();
    }

    public SchedEntity spawnJob(String table, IAttrHolder attributes) {
        return new OozieJob(attributes.getAttr("TYPE"), attributes.getAttr("NAME"), (SourceDefinitions)this);
    }

    public SchedEntity spawnJob(SchedEntity parent, IAttrHolder attributes) {
        return null;
    }

    public String getIdFieldName() {
        return "TYPE";
    }

    public String getEntNameFieldName() {
        return null;
    }

    public String getParentEntFieldName() {
        return null;
    }

    public boolean hasChildren(String entId) {
        return false;
    }

    public void createDependencies(String root) {
    }

    public void applyFilter(String root) {
    }

    private String getCondMapKey(OozieJob job) {
        if (job.getParent() != null) {
            return String.format("%s/%s", job.getParent().getOriginalJobName(), job.getOriginalJobName());
        }
        return job.getOriginalJobName();
    }

    public List<Properties> getJobInconds(SchedEntity job) {
        LinkedHashSet<Properties> conds;
        ArrayList<Properties> toRet = null;
        if (this.inCondMap != null && (conds = this.inCondMap.get(this.getCondMapKey((OozieJob)job))) != null) {
            toRet = new ArrayList<Properties>(conds);
        }
        return toRet;
    }

    public List<Properties> getJobOutconds(SchedEntity job) {
        LinkedHashSet<Properties> conds;
        ArrayList<Properties> toRet = null;
        if (this.outCondCondMap != null && (conds = this.outCondCondMap.get(this.getCondMapKey((OozieJob)job))) != null) {
            toRet = new ArrayList<Properties>(conds);
        }
        boolean isjobAToJobB = this.oozieRules.getStringRule("Oozie rules", new String[]{"CONDITION_NAME"}).equals("JOBA_JOBB");
        boolean cleanup = this.oozieRules.getBooleanRule("Oozie rules", new String[]{"CLEAN_UP_CONDITIONS"});
        boolean bl = cleanup = cleanup && isjobAToJobB;
        if (cleanup && this.getJobInconds(job) != null) {
            LinkedHashSet<Properties> toAdd = new LinkedHashSet<Properties>();
            for (Properties inCond : this.getJobInconds(job)) {
                Properties tmpProps = new Properties();
                tmpProps.setProperty("NAME", inCond.getProperty("NAME"));
                tmpProps.setProperty("ODATE", "ODAT");
                tmpProps.setProperty("SIGN", "DEL");
                toAdd.add(tmpProps);
            }
            toRet.addAll(toAdd);
        }
        return toRet;
    }

    public List<Properties> getJobOnstmts(SchedEntity job) {
        return null;
    }

    public List<Properties> getJobControlRes(SchedEntity job) {
        return null;
    }

    public Set<Properties> createTags(String root) {
        return null;
    }

    public boolean isStandAloneGrouped() {
        return false;
    }

    public boolean isContainerEntity(IAttrHolder entAttr) {
        return true;
    }

    public ArrayList<String> getGeneralMessages() {
        return this.messages;
    }
}

