/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.oozie;

import com.bmc.ctmconvert.base.AbstractAssessmentReport;
import com.bmc.ctmconvert.common.AssessmentXMLDescriptionReader;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.oozie.OozieGlobals;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Properties;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OozieAssessmentReport
extends AbstractAssessmentReport {
    private static final String BUNDELS_NODE_NAME = "Bundles";
    private static final String COORDINATORS_NODE_NAME = "Coordinators";
    private static final String WORKFLOWS_NODE_NAME = "Workflows";
    private static final String GENERAL = "GENERAL";
    private static final String UNDER_LINE = "-------------------------------";
    private static final String NUMBER_OF_ELEMENTS_XML = "#NUMBER_OF_ELEMENTS#";
    private static final String ACTIONS = "Actions";
    private AssessmentXMLDescriptionReader m_DescriptionXMLReader;
    private ArrayList<String> descriptionTypeLookNodes;
    private LinkedHashMap<String, String> descriptionMap_NodeName_NodeDesc;
    private LinkedHashMap<String, Bundle> descriptionMap_bundleName_bundle;
    private HashMap<String, Coordinator> descriptionMap_Name_Coordinator;
    private HashMap<String, Workflow> descriptionMap_Name_Workflow;

    public OozieAssessmentReport(String pathName, String descriptionXMLFileName, String optionalFile) {
        super(pathName, descriptionXMLFileName, optionalFile);
    }

    public String propertiesToString(Properties properties) {
        StringBuilder builder = new StringBuilder();
        if (properties == null) {
            return "";
        }
        for (String key : properties.stringPropertyNames()) {
            builder.append(this.keyToValueFormat(key, properties.getProperty(key)));
        }
        return builder.toString();
    }

    public String header(String header) {
        return String.format("\n%s\n%s\n", header, UNDER_LINE);
    }

    public String mapToString(LinkedHashMap<String, String> map) {
        StringBuilder builder = new StringBuilder();
        if (map == null) {
            return "";
        }
        for (String key : map.keySet()) {
            builder.append(this.keyToValueFormat(key, map.get(key)));
        }
        return builder.toString();
    }

    public String keyToValueFormat(String key, String value) {
        return String.format("%-40s\t: %s%s", key, value, "\n");
    }

    protected void initSourceData(String pathName, String descriptionXMLFileName, String optionalFile) {
        this.m_DescriptionXMLReader = new AssessmentXMLDescriptionReader(descriptionXMLFileName, Params.instance().getVendorName());
        this.descriptionTypeLookNodes = new ArrayList();
        this.descriptionMap_bundleName_bundle = new LinkedHashMap();
        this.descriptionMap_Name_Coordinator = new LinkedHashMap<String, Coordinator>();
        this.descriptionMap_Name_Workflow = new LinkedHashMap<String, Workflow>();
        this.descriptionMap_NodeName_NodeDesc = this.m_DescriptionXMLReader.getNodeNameNodeDescriptionMap();
        this.getDataFromFiles(pathName);
    }

    private void getDataFromFiles(String pathName) {
        String BundlesDir = pathName + "bundle\\";
        String coordinatorsDir = pathName + "coordinator\\";
        String workflowsDir = pathName + "workflow\\";
        this.getBundels(BundlesDir);
        this.getCoordinators(coordinatorsDir);
        this.getWorkflows(workflowsDir);
    }

    private void getWorkflows(String workflowsDir) {
        if (!GlobalFunctions.isDirExist((String)workflowsDir)) {
            return;
        }
        File[] files = new File(workflowsDir).listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (!file.getName().endsWith(".xml")) continue;
            Workflow wf = new Workflow(file);
            wf.getDataFromFile();
            this.descriptionMap_Name_Workflow.put(wf.getName(), wf);
        }
    }

    private void getCoordinators(String coordinatorsDir) {
        if (!GlobalFunctions.isDirExist((String)coordinatorsDir)) {
            return;
        }
        File[] files = new File(coordinatorsDir).listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (!file.getName().endsWith(".xml")) continue;
            Coordinator coord = new Coordinator(file);
            coord.getDataFromFile();
            this.descriptionMap_Name_Coordinator.put(coord.getName(), coord);
        }
    }

    private void getBundels(String bundlesDir) {
        if (!GlobalFunctions.isDirExist((String)bundlesDir)) {
            return;
        }
        File[] files = new File(bundlesDir).listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (!file.getName().endsWith(".xml")) continue;
            Bundle bundle = new Bundle(file);
            bundle.getDataFromFile();
            this.descriptionMap_bundleName_bundle.put(bundle.getName(), bundle);
        }
    }

    protected DefaultMutableTreeNode getDefaultTreeModel() {
        DefaultMutableTreeNode mainTreeNodes = new DefaultMutableTreeNode(Params.instance().getDatasourceName());
        String bundelsdNodeName = "Bundles(" + this.descriptionMap_bundleName_bundle.size() + ")";
        String coordinatorsNodeName = "Coordinators(" + this.descriptionMap_Name_Coordinator.size() + ")";
        String workflowsNodeName = "Workflows(" + this.descriptionMap_Name_Workflow.size() + ")";
        if (this.descriptionMap_bundleName_bundle.size() > 0) {
            DefaultMutableTreeNode bundelsNode = new DefaultMutableTreeNode(bundelsdNodeName);
            bundelsNode = this.addBundelsToNode(bundelsNode);
            this.descriptionTypeLookNodes.add(bundelsdNodeName);
            mainTreeNodes.add(bundelsNode);
        }
        if (this.descriptionMap_Name_Coordinator.size() > 0) {
            DefaultMutableTreeNode CoordinatorsNode = new DefaultMutableTreeNode(coordinatorsNodeName);
            CoordinatorsNode = this.addCoordinatorsToNode(CoordinatorsNode);
            this.descriptionTypeLookNodes.add(coordinatorsNodeName);
            mainTreeNodes.add(CoordinatorsNode);
        }
        if (this.descriptionMap_Name_Workflow.size() > 0) {
            DefaultMutableTreeNode workflowNode = new DefaultMutableTreeNode(workflowsNodeName);
            workflowNode = this.addworkflowsToNode(workflowNode);
            this.descriptionTypeLookNodes.add(workflowsNodeName);
            mainTreeNodes.add(workflowNode);
        }
        String bundelsNodeDescription = this.descriptionMap_NodeName_NodeDesc.get(BUNDELS_NODE_NAME).replaceAll(NUMBER_OF_ELEMENTS_XML, Integer.toString(this.descriptionMap_bundleName_bundle.size()));
        String CoordinatorsNodeDescription = this.descriptionMap_NodeName_NodeDesc.get(COORDINATORS_NODE_NAME).replaceAll(NUMBER_OF_ELEMENTS_XML, Integer.toString(this.descriptionMap_Name_Coordinator.size()));
        String workflowNodeDescription = this.descriptionMap_NodeName_NodeDesc.get(WORKFLOWS_NODE_NAME).replaceAll(NUMBER_OF_ELEMENTS_XML, Integer.toString(this.descriptionMap_Name_Workflow.size()));
        this.descriptionMap_NodeName_NodeDesc.put(BUNDELS_NODE_NAME, bundelsNodeDescription);
        this.descriptionMap_NodeName_NodeDesc.put(COORDINATORS_NODE_NAME, CoordinatorsNodeDescription);
        this.descriptionMap_NodeName_NodeDesc.put(WORKFLOWS_NODE_NAME, workflowNodeDescription);
        this.descriptionMap_NodeName_NodeDesc.put(Params.instance().getDatasourceName(), "Summary:\n\n" + bundelsNodeDescription + "\n" + CoordinatorsNodeDescription + "\n" + workflowNodeDescription);
        return mainTreeNodes;
    }

    private DefaultMutableTreeNode addworkflowsToNode(DefaultMutableTreeNode workflowsNode) {
        for (String workflowName : this.descriptionMap_Name_Workflow.keySet()) {
            DefaultMutableTreeNode workflowNode = new DefaultMutableTreeNode(workflowName);
            DefaultMutableTreeNode ActionsNode = new DefaultMutableTreeNode(ACTIONS);
            workflowNode.add(ActionsNode);
            workflowsNode.add(workflowNode);
        }
        return workflowsNode;
    }

    private DefaultMutableTreeNode addCoordinatorsToNode(DefaultMutableTreeNode coordinatorsNode) {
        for (String coordinatorName : this.descriptionMap_Name_Coordinator.keySet()) {
            DefaultMutableTreeNode coordinatorNode = new DefaultMutableTreeNode(coordinatorName);
            coordinatorsNode.add(coordinatorNode);
        }
        return coordinatorsNode;
    }

    private DefaultMutableTreeNode addBundelsToNode(DefaultMutableTreeNode bundelsNode) {
        for (String bundleName : this.descriptionMap_bundleName_bundle.keySet()) {
            DefaultMutableTreeNode BundleNode = new DefaultMutableTreeNode(bundleName);
            bundelsNode.add(BundleNode);
        }
        return bundelsNode;
    }

    protected String getJobInfo(String messageID) {
        if (messageID.isEmpty()) {
            return null;
        }
        String[] nodePath = messageID.split(";");
        int NODE_TYPE_INDEX = 1;
        int NODE_NAME_INDEX = 2;
        if (nodePath.length == 1) {
            return this.descriptionMap_NodeName_NodeDesc.get(nodePath[0]);
        }
        if (nodePath[NODE_TYPE_INDEX].startsWith(BUNDELS_NODE_NAME)) {
            return this.getBundleNodeInfo(nodePath[NODE_NAME_INDEX]);
        }
        if (nodePath[NODE_TYPE_INDEX].startsWith(COORDINATORS_NODE_NAME)) {
            return this.getCoordinatorNodeInfo(nodePath[NODE_NAME_INDEX]);
        }
        if (nodePath[NODE_TYPE_INDEX].startsWith(WORKFLOWS_NODE_NAME)) {
            return this.getWorkFlowNodeInfo(nodePath[NODE_NAME_INDEX]);
        }
        return "";
    }

    private String getWorkFlowNodeInfo(String workflow) {
        if (this.descriptionMap_Name_Workflow.containsKey(workflow)) {
            return this.descriptionMap_Name_Workflow.get(workflow).toString();
        }
        return "";
    }

    private String getCoordinatorNodeInfo(String coordinator) {
        if (this.descriptionMap_Name_Coordinator.containsKey(coordinator)) {
            return this.descriptionMap_Name_Coordinator.get(coordinator).toString();
        }
        return "";
    }

    private String getBundleNodeInfo(String bundleName) {
        if (this.descriptionMap_bundleName_bundle.containsKey(bundleName)) {
            return this.descriptionMap_bundleName_bundle.get(bundleName).toString();
        }
        return "";
    }

    protected ArrayList<String> getDescriptionTypeLookNodes() {
        return this.descriptionTypeLookNodes;
    }

    protected ArrayList<String> getDescriptionTypeSplitLookNodes() {
        ArrayList<String> toRet = new ArrayList<String>();
        toRet.add(ACTIONS);
        return toRet;
    }

    protected ArrayList<String> getSelectionList(String parentNodeID) {
        ArrayList<String> ret = new ArrayList<String>();
        if (parentNodeID.isEmpty()) {
            return null;
        }
        String[] nodePath = parentNodeID.split(";");
        int NODE_TYPE_INDEX = 1;
        int NODE_NAME_INDEX = 2;
        if (nodePath[NODE_TYPE_INDEX].startsWith(WORKFLOWS_NODE_NAME)) {
            this.setSelectionListPath(parentNodeID);
            ArrayList<Workflow.Action> actionList = this.getWorkFlowNodeActionList(nodePath[NODE_NAME_INDEX]);
            for (Workflow.Action action : actionList) {
                ret.add(action.getName());
            }
            return ret;
        }
        return null;
    }

    private ArrayList<Workflow.Action> getWorkFlowNodeActionList(String workflow) {
        ArrayList<Workflow.Action> ret = new ArrayList<Workflow.Action>();
        if (!this.descriptionMap_Name_Workflow.containsKey(workflow)) {
            return ret;
        }
        return this.descriptionMap_Name_Workflow.get(workflow).getActionList();
    }

    protected HashMap<String, String> getDescriptionNodes() {
        return this.descriptionMap_NodeName_NodeDesc;
    }

    protected String getJobInfoFromSelectionList(String messageID) {
        String path = this.getSelectionListPath();
        if (path == null || path.isEmpty() || messageID == null || messageID.isEmpty()) {
            return null;
        }
        String[] nodePath = path.split(";");
        int NODE_TYPE_INDEX = 1;
        int NODE_NAME_INDEX = 2;
        if (messageID.equals(GENERAL) && this.descriptionMap_Name_Workflow.containsKey(nodePath[NODE_NAME_INDEX])) {
            return this.descriptionMap_Name_Workflow.get(nodePath[NODE_NAME_INDEX]).toString();
        }
        if (nodePath[NODE_TYPE_INDEX].startsWith(WORKFLOWS_NODE_NAME)) {
            ArrayList<Workflow.Action> actionList = this.getWorkFlowNodeActionList(nodePath[NODE_NAME_INDEX]);
            for (Workflow.Action action : actionList) {
                if (!action.getName().equals(messageID)) continue;
                return action.toString();
            }
        }
        return "";
    }

    public String getTagAtrr(Element element, String Tag, String attribute) {
        if (element.getElementsByTagName(Tag).getLength() > 0 && element.getElementsByTagName(Tag).item(0).getAttributes().getNamedItem(attribute) != null) {
            return element.getElementsByTagName(Tag).item(0).getAttributes().getNamedItem(attribute).getNodeValue();
        }
        return "";
    }

    public String getTagText(Element element, String Tag) {
        if (element.getElementsByTagName(Tag).getLength() > 0 && element.getElementsByTagName(Tag).item(0).getTextContent().trim() != null) {
            return element.getElementsByTagName(Tag).item(0).getTextContent().trim();
        }
        return "";
    }

    public class Workflow {
        private Element workflowElement;
        private String name;
        LinkedHashMap<String, String> MAP_genaralNodes_value;
        private ArrayList<Action> actionList = new ArrayList();
        private Properties properties;

        public Workflow(File file) {
            this.MAP_genaralNodes_value = new LinkedHashMap();
            try {
                File propertiesFile = new File(file.getAbsolutePath().replaceAll("xml$", "properties"));
                if (propertiesFile.exists()) {
                    this.properties = new Properties();
                    this.properties.load(new FileInputStream(propertiesFile));
                }
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder parser = factory.newDocumentBuilder();
                Document doc = parser.parse(file);
                this.workflowElement = doc.getDocumentElement();
                this.name = this.workflowElement.getAttribute("name");
            }
            catch (Exception e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        }

        public void getDataFromFile() {
            try {
                if (OozieAssessmentReport.this.getTagAtrr(this.workflowElement, "start", "to") != "") {
                    this.MAP_genaralNodes_value.put("start", OozieAssessmentReport.this.getTagAtrr(this.workflowElement, "start", "to"));
                }
                if (OozieAssessmentReport.this.getTagAtrr(this.workflowElement, "end", "name") != "") {
                    this.MAP_genaralNodes_value.put("end", OozieAssessmentReport.this.getTagAtrr(this.workflowElement, "end", "name"));
                }
                if (OozieAssessmentReport.this.getTagAtrr(this.workflowElement, "kill", "name") != "") {
                    this.MAP_genaralNodes_value.put("kill", OozieAssessmentReport.this.getTagAtrr(this.workflowElement, "kill", "name"));
                }
                if (OozieAssessmentReport.this.getTagText(this.workflowElement, "message") != "") {
                    this.MAP_genaralNodes_value.put("kill message", OozieAssessmentReport.this.getTagAtrr(this.workflowElement, "kill", "name"));
                }
                NodeList actionList = this.workflowElement.getElementsByTagName("action");
                for (int i = 0; i < actionList.getLength(); ++i) {
                    Element actionElement = (Element)actionList.item(i);
                    Action action = new Action(actionElement);
                    this.actionList.add(action);
                }
            }
            catch (Exception e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        }

        public String getName() {
            return this.name;
        }

        public ArrayList<Action> getActionList() {
            return this.actionList;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(OozieAssessmentReport.this.header("Workflow"));
            if (this.name != null) {
                builder.append(OozieAssessmentReport.this.keyToValueFormat("name", this.name));
            }
            if (this.MAP_genaralNodes_value != null && this.MAP_genaralNodes_value.size() > 0) {
                builder.append(OozieAssessmentReport.this.mapToString(this.MAP_genaralNodes_value));
            }
            if (this.actionList != null && this.actionList.size() > 0) {
                builder.append(OozieAssessmentReport.this.header("ActionList"));
                for (Action action : this.actionList) {
                    builder.append(action.getName()).append("\n");
                }
            }
            if (this.properties != null && this.properties.size() > 0) {
                builder.append(OozieAssessmentReport.this.header("Properties"));
                builder.append(OozieAssessmentReport.this.propertiesToString(this.properties));
            }
            return builder.toString();
        }

        public class Action {
            private String actionName;
            private String ok_to;
            private String error_to;
            private LinkedHashMap<String, String> actionDetailMAP_name_value = new LinkedHashMap();
            private LinkedHashMap<String, String> propertiesMAP_name_value = new LinkedHashMap();

            public Action(Element actionElement) {
                this.actionName = actionElement.getAttribute("name");
                this.ok_to = OozieAssessmentReport.this.getTagAtrr(actionElement, "ok", "to");
                this.error_to = OozieAssessmentReport.this.getTagAtrr(actionElement, "error", "to");
                this.getActionDetails(actionElement.getChildNodes());
                this.getProperties(actionElement.getElementsByTagName("property"));
            }

            private void getProperties(NodeList propertiesNodeList) {
                if (propertiesNodeList == null) {
                    return;
                }
                for (int i = 0; i < propertiesNodeList.getLength(); ++i) {
                    Element propertiesElement = (Element)propertiesNodeList.item(i);
                    String name = OozieAssessmentReport.this.getTagText(propertiesElement, "name");
                    String value = OozieAssessmentReport.this.getTagText(propertiesElement, "value");
                    this.propertiesMAP_name_value.put(name, value);
                }
            }

            private void getActionDetails(NodeList nodeList) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node childNode = nodeList.item(i);
                    childNode.getNodeName();
                    if (childNode.getNodeName().equals("ok") || childNode.getNodeName().equals("error") || childNode.getNodeName().equals(OozieGlobals.XML_TAG_CONFIGURATION)) continue;
                    String name = childNode.getNodeName();
                    Object value = "";
                    NodeList children = childNode.getChildNodes();
                    if (children.getLength() == 1) {
                        value = childNode.getTextContent().trim();
                    } else if (this.isActionTypeTag(name)) {
                        value = name;
                        name = "type";
                    } else if (childNode.getAttributes() != null && childNode.getAttributes().getLength() > 0) {
                        value = childNode.getAttributes().item(0).getNodeValue();
                    }
                    if (this.actionDetailMAP_name_value.containsKey(name)) {
                        value = this.actionDetailMAP_name_value.get(name) + "," + (String)value;
                    }
                    if (!name.equals("#text") && !((String)value).isEmpty()) {
                        this.actionDetailMAP_name_value.put(name, (String)value);
                    }
                    if (children == null) continue;
                    this.getActionDetails(children);
                }
            }

            private boolean isActionTypeTag(String name) {
                for (String type : OozieGlobals.OOZIE_ACTION_TYPES) {
                    if (!name.equalsIgnoreCase(type)) continue;
                    return true;
                }
                return false;
            }

            private String getName() {
                return this.actionName;
            }

            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append(OozieAssessmentReport.this.header("Action"));
                if (this.actionName != null) {
                    builder.append(OozieAssessmentReport.this.keyToValueFormat("actionName", this.actionName));
                }
                if (this.ok_to != null) {
                    builder.append(OozieAssessmentReport.this.keyToValueFormat("ok_to", this.ok_to));
                }
                if (this.error_to != null) {
                    builder.append(OozieAssessmentReport.this.keyToValueFormat("error_to", this.error_to));
                }
                if (this.actionDetailMAP_name_value != null && this.actionDetailMAP_name_value.size() > 0) {
                    builder.append(OozieAssessmentReport.this.header("Action details"));
                    builder.append(OozieAssessmentReport.this.mapToString(this.actionDetailMAP_name_value));
                }
                if (this.propertiesMAP_name_value != null && this.propertiesMAP_name_value.size() > 0) {
                    builder.append(OozieAssessmentReport.this.header("Properties"));
                    builder.append(OozieAssessmentReport.this.mapToString(this.propertiesMAP_name_value));
                }
                builder.append("\n");
                return builder.toString();
            }
        }
    }

    public class Coordinator {
        private String name;
        private ArrayList<DataIn> dataInList;
        private ArrayList<DataSet> dataSetList;
        private LinkedHashMap<String, String> detailsMap = new LinkedHashMap();
        private Element coordinatorElement;
        private Properties properties;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Coordinator(File file) {
            this.dataInList = new ArrayList();
            this.dataSetList = new ArrayList();
            try {
                File propertiesFile = new File(file.getAbsolutePath().replaceAll("xml$", "properties"));
                if (propertiesFile.exists()) {
                    this.properties = new Properties();
                    this.properties.load(new FileInputStream(propertiesFile));
                }
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder parser = factory.newDocumentBuilder();
                Document doc = parser.parse(file);
                this.coordinatorElement = doc.getDocumentElement();
                this.name = this.coordinatorElement.getAttribute("name");
            }
            catch (Exception e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        }

        void getDataFromFile() {
            try {
                this.detailsMap.put("frequency", this.coordinatorElement.getAttributes().getNamedItem("frequency").getNodeValue());
                this.detailsMap.put("frequency", this.coordinatorElement.getAttributes().getNamedItem("frequency").getNodeValue());
                this.detailsMap.put("start", this.coordinatorElement.getAttributes().getNamedItem("start").getNodeValue());
                this.detailsMap.put("end", this.coordinatorElement.getAttributes().getNamedItem("end").getNodeValue());
                this.detailsMap.put("timezone", this.coordinatorElement.getAttributes().getNamedItem("timezone").getNodeValue());
                this.detailsMap.put("app-path", OozieAssessmentReport.this.getTagText(this.coordinatorElement, "app-path"));
                this.detailsMap.put("timeout", OozieAssessmentReport.this.getTagText(this.coordinatorElement, "timeout"));
                this.detailsMap.put("concurrency", OozieAssessmentReport.this.getTagText(this.coordinatorElement, "concurrency"));
                this.detailsMap.put("execution", OozieAssessmentReport.this.getTagText(this.coordinatorElement, "execution"));
                NodeList instancelist = this.coordinatorElement.getElementsByTagName("instance");
                for (int i = 0; i < instancelist.getLength(); ++i) {
                    Element childElement = (Element)instancelist.item(i);
                    Element parent = (Element)childElement.getParentNode();
                    String dataInName = parent.getAttribute("name");
                    String dataSetName = parent.getAttribute("dataset");
                    String instancecontent = childElement.getTextContent().trim();
                    this.dataInList.add(new DataIn(instancecontent, dataInName, dataSetName));
                }
                NodeList list = this.coordinatorElement.getElementsByTagName("uri-template");
                for (int i = 0; i < list.getLength(); ++i) {
                    Element childElement = (Element)list.item(i);
                    Element parent = (Element)childElement.getParentNode();
                    DataSet dataset = new DataSet();
                    dataset.put("name", parent.getAttribute("name"));
                    dataset.put("frequency", parent.getAttribute("frequency"));
                    dataset.put("initial-instance", parent.getAttribute("initial-instance"));
                    dataset.put("timezone", parent.getAttribute("timezone"));
                    dataset.put("uri-template", childElement.getTextContent().trim());
                    this.dataSetList.add(dataset);
                }
            }
            catch (Exception e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(OozieAssessmentReport.this.header("Coordinator"));
            if (this.name != null) {
                builder.append(OozieAssessmentReport.this.keyToValueFormat("name", this.name));
            }
            if (this.detailsMap != null) {
                builder.append(OozieAssessmentReport.this.mapToString(this.detailsMap)).append("\n");
            }
            if (this.dataSetList != null && this.dataSetList.size() > 0) {
                builder.append(OozieAssessmentReport.this.header("Dataset list"));
                for (DataSet dataSet : this.dataSetList) {
                    builder.append(OozieAssessmentReport.this.mapToString(dataSet)).append("\n");
                }
            }
            if (this.dataInList != null && this.dataInList.size() > 0) {
                builder.append(OozieAssessmentReport.this.header("Data-in list"));
                for (DataIn dataIn : this.dataInList) {
                    builder.append(dataIn).append("\n");
                }
            }
            if (this.properties != null && this.properties.size() > 0) {
                builder.append(OozieAssessmentReport.this.header("Properties"));
                builder.append(OozieAssessmentReport.this.propertiesToString(this.properties));
            }
            return builder.toString();
        }

        private class DataIn {
            String name;
            String dataSet;
            String instance;

            public DataIn(String instancecontent, String dataInName, String dataSetName) {
                this.name = dataInName;
                this.dataSet = dataSetName;
                this.instance = instancecontent;
            }

            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append("DataIn \n");
                if (this.name != null) {
                    builder.append(OozieAssessmentReport.this.keyToValueFormat("name", this.name));
                }
                if (this.dataSet != null) {
                    builder.append(OozieAssessmentReport.this.keyToValueFormat("dataSet", this.dataSet));
                }
                if (this.instance != null) {
                    builder.append(OozieAssessmentReport.this.keyToValueFormat("instance", this.instance));
                }
                return builder.toString();
            }
        }

        public class DataSet
        extends LinkedHashMap<String, String> {
            private static final long serialVersionUID = 1L;
        }
    }

    public class Bundle {
        private Element bundleElement;
        private LinkedHashMap<String, String> coordinator_name_appPath = new LinkedHashMap();
        private ArrayList<String> kick_off_times = new ArrayList();
        private String name;
        private Properties properties;

        Bundle(File file) {
            try {
                File propertiesFile = new File(file.getAbsolutePath().replaceAll("xml$", "properties"));
                if (propertiesFile.exists()) {
                    this.properties = new Properties();
                    this.properties.load(new FileInputStream(propertiesFile));
                }
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder parser = factory.newDocumentBuilder();
                Document doc = parser.parse(file);
                this.bundleElement = doc.getDocumentElement();
                this.name = this.bundleElement.getAttributes().getNamedItem("name").getNodeValue();
            }
            catch (Exception e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        private void getDataFromFile() {
            try {
                this.getKickOffTimes();
                this.getCoordinatorApp();
            }
            catch (Exception e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        }

        private void getCoordinatorApp() {
            NodeList list = this.bundleElement.getElementsByTagName("app-path");
            for (int i = 0; i < list.getLength(); ++i) {
                Element childElement = (Element)list.item(i);
                Element parent = (Element)childElement.getParentNode();
                String coorName = parent.getAttribute("name");
                String coorcontent = childElement.getTextContent().trim();
                if (coorcontent == null || coorcontent.isEmpty()) continue;
                this.coordinator_name_appPath.put(coorcontent, coorName);
            }
        }

        private void getKickOffTimes() {
            NodeList list = this.bundleElement.getElementsByTagName("kick-off-time");
            for (int i = 0; i < list.getLength(); ++i) {
                Element childElement = (Element)list.item(i);
                String startTime = childElement.getTextContent().trim().trim();
                if (startTime == null || startTime.isEmpty()) continue;
                this.kick_off_times.add(startTime);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(OozieAssessmentReport.this.header("Bundle"));
            if (this.name != null) {
                builder.append(OozieAssessmentReport.this.keyToValueFormat("name", this.name));
            }
            if (this.kick_off_times != null && this.kick_off_times.size() > 0) {
                builder.append(OozieAssessmentReport.this.header("kick_off_times"));
                for (String kick : this.kick_off_times) {
                    builder.append(kick).append("\n");
                }
            }
            if (this.coordinator_name_appPath != null && this.coordinator_name_appPath.size() > 0) {
                builder.append(OozieAssessmentReport.this.header("coordinator app-Path"));
                builder.append(OozieAssessmentReport.this.mapToString(this.coordinator_name_appPath)).append("\n");
            }
            if (this.properties != null && this.properties.size() > 0) {
                builder.append(OozieAssessmentReport.this.header("Properties"));
                builder.append(OozieAssessmentReport.this.propertiesToString(this.properties));
            }
            return builder.toString();
        }
    }
}

