/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class EnvironmentDetails {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="dbType")
    private String dbType = null;
    @SerializedName(value="host")
    private String host = null;
    @SerializedName(value="port")
    private String port = null;
    @SerializedName(value="userName")
    private String userName = null;
    @SerializedName(value="password")
    private String password = null;
    @SerializedName(value="dbName")
    private String dbName = null;

    public EnvironmentDetails name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the environment [unique, not empty]. REQUIRED.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EnvironmentDetails dbType(String dbType) {
        this.dbType = dbType;
        return this;
    }

    @ApiModelProperty(required=true, value="The DB type ['PostgreSQL' | 'Oracle' | 'MSSQL]. REQUIRED.")
    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public EnvironmentDetails host(String host) {
        this.host = host;
        return this;
    }

    @ApiModelProperty(required=true, value="The host of the DB [not empty, without spaces]. REQUIRED.")
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public EnvironmentDetails port(String port) {
        this.port = port;
        return this;
    }

    @ApiModelProperty(value="Port of the DB.")
    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public EnvironmentDetails userName(String userName) {
        this.userName = userName;
        return this;
    }

    @ApiModelProperty(value="The user name for login.")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public EnvironmentDetails password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(required=true, value="The password for login to the DB [not empty, email address]. REQUIRED.")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public EnvironmentDetails dbName(String dbName) {
        this.dbName = dbName;
        return this;
    }

    @ApiModelProperty(value="Database name.")
    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvironmentDetails environmentDetails = (EnvironmentDetails)o;
        return Objects.equals(this.name, environmentDetails.name) && Objects.equals(this.dbType, environmentDetails.dbType) && Objects.equals(this.host, environmentDetails.host) && Objects.equals(this.port, environmentDetails.port) && Objects.equals(this.userName, environmentDetails.userName) && Objects.equals(this.password, environmentDetails.password) && Objects.equals(this.dbName, environmentDetails.dbName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.dbType, this.host, this.port, this.userName, this.password, this.dbName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EnvironmentDetails {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    dbType: ").append(this.toIndentedString(this.dbType)).append("\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    dbName: ").append(this.toIndentedString(this.dbName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

