/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.client.model.RuleCriteria;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ArchiveRule {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="maxOutputSize")
    private String maxOutputSize = null;
    @SerializedName(value="maxOutputSizeType")
    private String maxOutputSizeType = null;
    @SerializedName(value="trimType")
    private String trimType = null;
    @SerializedName(value="retention")
    private String retention = null;
    @SerializedName(value="retentionType")
    private String retentionType = null;
    @SerializedName(value="isActive")
    private String isActive = null;
    @SerializedName(value="archivedType")
    private String archivedType = null;
    @SerializedName(value="ruleParameters")
    private List<RuleCriteria> ruleParameters = null;

    public ArchiveRule name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The Control-M Workload Archiving rule name. REQUIRED. HIDDEN.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArchiveRule description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of Control-M Workload Archiving rule. HIDDEN.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ArchiveRule maxOutputSize(String maxOutputSize) {
        this.maxOutputSize = maxOutputSize;
        return this;
    }

    @ApiModelProperty(value="The maximum job's output size to collect. HIDDEN.")
    public String getMaxOutputSize() {
        return this.maxOutputSize;
    }

    public void setMaxOutputSize(String maxOutputSize) {
        this.maxOutputSize = maxOutputSize;
    }

    public ArchiveRule maxOutputSizeType(String maxOutputSizeType) {
        this.maxOutputSizeType = maxOutputSizeType;
        return this;
    }

    @ApiModelProperty(value="The maximum job's output size type to collect - KB or MB. The default is MB. HIDDEN.")
    public String getMaxOutputSizeType() {
        return this.maxOutputSizeType;
    }

    public void setMaxOutputSizeType(String maxOutputSizeType) {
        this.maxOutputSizeType = maxOutputSizeType;
    }

    public ArchiveRule trimType(String trimType) {
        this.trimType = trimType;
        return this;
    }

    @ApiModelProperty(value="Trim in case the output exceed the maximum job's output - Omit , Beginning, End. The default is to Omit. HIDDEN.")
    public String getTrimType() {
        return this.trimType;
    }

    public void setTrimType(String trimType) {
        this.trimType = trimType;
    }

    public ArchiveRule retention(String retention) {
        this.retention = retention;
        return this;
    }

    @ApiModelProperty(value="The retention period to keep archive job by rule. The default is 1. HIDDEN.")
    public String getRetention() {
        return this.retention;
    }

    public void setRetention(String retention) {
        this.retention = retention;
    }

    public ArchiveRule retentionType(String retentionType) {
        this.retentionType = retentionType;
        return this;
    }

    @ApiModelProperty(value="The retention period type to keep archive job by rule- Years, Months and Days are available. The default is Years. HIDDEN.")
    public String getRetentionType() {
        return this.retentionType;
    }

    public void setRetentionType(String retentionType) {
        this.retentionType = retentionType;
    }

    public ArchiveRule isActive(String isActive) {
        this.isActive = isActive;
        return this;
    }

    @ApiModelProperty(value="Is Control-M Workload Archiving rule is active. HIDDEN.")
    public String getIsActive() {
        return this.isActive;
    }

    public void setIsActive(String isActive) {
        this.isActive = isActive;
    }

    public ArchiveRule archivedType(String archivedType) {
        this.archivedType = archivedType;
        return this;
    }

    @ApiModelProperty(value="The rule archived data - logs, output or both. The default is both. HIDDEN.")
    public String getArchivedType() {
        return this.archivedType;
    }

    public void setArchivedType(String archivedType) {
        this.archivedType = archivedType;
    }

    public ArchiveRule ruleParameters(List<RuleCriteria> ruleParameters) {
        this.ruleParameters = ruleParameters;
        return this;
    }

    public ArchiveRule addRuleParametersItem(RuleCriteria ruleParametersItem) {
        if (this.ruleParameters == null) {
            this.ruleParameters = new ArrayList<RuleCriteria>();
        }
        this.ruleParameters.add(ruleParametersItem);
        return this;
    }

    @ApiModelProperty(value="Rule parameters - ctm, type, jobName, jobType, application, subApplication, jobStatus, folder and library. HIDDEN.")
    public List<RuleCriteria> getRuleParameters() {
        return this.ruleParameters;
    }

    public void setRuleParameters(List<RuleCriteria> ruleParameters) {
        this.ruleParameters = ruleParameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArchiveRule archiveRule = (ArchiveRule)o;
        return Objects.equals(this.name, archiveRule.name) && Objects.equals(this.description, archiveRule.description) && Objects.equals(this.maxOutputSize, archiveRule.maxOutputSize) && Objects.equals(this.maxOutputSizeType, archiveRule.maxOutputSizeType) && Objects.equals(this.trimType, archiveRule.trimType) && Objects.equals(this.retention, archiveRule.retention) && Objects.equals(this.retentionType, archiveRule.retentionType) && Objects.equals(this.isActive, archiveRule.isActive) && Objects.equals(this.archivedType, archiveRule.archivedType) && Objects.equals(this.ruleParameters, archiveRule.ruleParameters);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.maxOutputSize, this.maxOutputSizeType, this.trimType, this.retention, this.retentionType, this.isActive, this.archivedType, this.ruleParameters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ArchiveRule {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    maxOutputSize: ").append(this.toIndentedString(this.maxOutputSize)).append("\n");
        sb.append("    maxOutputSizeType: ").append(this.toIndentedString(this.maxOutputSizeType)).append("\n");
        sb.append("    trimType: ").append(this.toIndentedString(this.trimType)).append("\n");
        sb.append("    retention: ").append(this.toIndentedString(this.retention)).append("\n");
        sb.append("    retentionType: ").append(this.toIndentedString(this.retentionType)).append("\n");
        sb.append("    isActive: ").append(this.toIndentedString(this.isActive)).append("\n");
        sb.append("    archivedType: ").append(this.toIndentedString(this.archivedType)).append("\n");
        sb.append("    ruleParameters: ").append(this.toIndentedString(this.ruleParameters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

