/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import io.swagger.client.model.ProvisionRepo;
import io.swagger.client.model.ProvisionReposResults;
import io.swagger.client.model.StringListResult;
import io.swagger.client.model.SuccessData;
import io.swagger.client.model.UpgradeAgentInfoList;
import io.swagger.client.model.UpgradeInfo;
import io.swagger.client.model.UpgradeRecord;
import io.swagger.client.model.UpgradeRecordList;
import io.swagger.client.model.UpgradeRequest;
import io.swagger.client.model.UpgradeResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ProvisionApi {
    private ApiClient apiClient;

    public ProvisionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProvisionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call addProvisionRepoCall(String repoName, String location, String description, Boolean helixRepo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/provision/repository";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (repoName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("repoName", repoName));
        }
        if (location != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("location", location));
        }
        if (description != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("description", description));
        }
        if (helixRepo != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("helixRepo", helixRepo));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addProvisionRepoValidateBeforeCall(String repoName, String location, String description, Boolean helixRepo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (repoName == null) {
            throw new ApiException("Missing the required parameter 'repoName' when calling addProvisionRepo(Async)");
        }
        if (location == null) {
            throw new ApiException("Missing the required parameter 'location' when calling addProvisionRepo(Async)");
        }
        Call call = this.addProvisionRepoCall(repoName, location, description, helixRepo, progressListener, progressRequestListener);
        return call;
    }

    public ProvisionRepo addProvisionRepo(String repoName, String location, String description, Boolean helixRepo) throws ApiException {
        ApiResponse<ProvisionRepo> resp = this.addProvisionRepoWithHttpInfo(repoName, location, description, helixRepo);
        return resp.getData();
    }

    public ApiResponse<ProvisionRepo> addProvisionRepoWithHttpInfo(String repoName, String location, String description, Boolean helixRepo) throws ApiException {
        Call call = this.addProvisionRepoValidateBeforeCall(repoName, location, description, helixRepo, null, null);
        Type localVarReturnType = new TypeToken<ProvisionRepo>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addProvisionRepoAsync(String repoName, String location, String description, Boolean helixRepo, final ApiCallback<ProvisionRepo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.addProvisionRepoValidateBeforeCall(repoName, location, description, helixRepo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ProvisionRepo>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call cancelUpgradeActivityCall(String upgradeId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/provision/upgrade/{upgradeId}/cancel".replaceAll("\\{upgradeId\\}", this.apiClient.escapeString(upgradeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call cancelUpgradeActivityValidateBeforeCall(String upgradeId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (upgradeId == null) {
            throw new ApiException("Missing the required parameter 'upgradeId' when calling cancelUpgradeActivity(Async)");
        }
        Call call = this.cancelUpgradeActivityCall(upgradeId, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData cancelUpgradeActivity(String upgradeId) throws ApiException {
        ApiResponse<SuccessData> resp = this.cancelUpgradeActivityWithHttpInfo(upgradeId);
        return resp.getData();
    }

    public ApiResponse<SuccessData> cancelUpgradeActivityWithHttpInfo(String upgradeId) throws ApiException {
        Call call = this.cancelUpgradeActivityValidateBeforeCall(upgradeId, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call cancelUpgradeActivityAsync(String upgradeId, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.cancelUpgradeActivityValidateBeforeCall(upgradeId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteProvisionRepoCall(String repoName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/provision/repository/{repoName}".replaceAll("\\{repoName\\}", this.apiClient.escapeString(repoName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteProvisionRepoValidateBeforeCall(String repoName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (repoName == null) {
            throw new ApiException("Missing the required parameter 'repoName' when calling deleteProvisionRepo(Async)");
        }
        Call call = this.deleteProvisionRepoCall(repoName, progressListener, progressRequestListener);
        return call;
    }

    public ProvisionReposResults deleteProvisionRepo(String repoName) throws ApiException {
        ApiResponse<ProvisionReposResults> resp = this.deleteProvisionRepoWithHttpInfo(repoName);
        return resp.getData();
    }

    public ApiResponse<ProvisionReposResults> deleteProvisionRepoWithHttpInfo(String repoName) throws ApiException {
        Call call = this.deleteProvisionRepoValidateBeforeCall(repoName, null, null);
        Type localVarReturnType = new TypeToken<ProvisionReposResults>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteProvisionRepoAsync(String repoName, final ApiCallback<ProvisionReposResults> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteProvisionRepoValidateBeforeCall(repoName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ProvisionReposResults>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteUpgradeActivityCall(String upgradeId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/provision/upgrade/{upgradeId}".replaceAll("\\{upgradeId\\}", this.apiClient.escapeString(upgradeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteUpgradeActivityValidateBeforeCall(String upgradeId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (upgradeId == null) {
            throw new ApiException("Missing the required parameter 'upgradeId' when calling deleteUpgradeActivity(Async)");
        }
        Call call = this.deleteUpgradeActivityCall(upgradeId, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData deleteUpgradeActivity(String upgradeId) throws ApiException {
        ApiResponse<SuccessData> resp = this.deleteUpgradeActivityWithHttpInfo(upgradeId);
        return resp.getData();
    }

    public ApiResponse<SuccessData> deleteUpgradeActivityWithHttpInfo(String upgradeId) throws ApiException {
        Call call = this.deleteUpgradeActivityValidateBeforeCall(upgradeId, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteUpgradeActivityAsync(String upgradeId, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteUpgradeActivityValidateBeforeCall(upgradeId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAllUpgradeActivitiesStatusCall(String ctm, String server, String agent, String fromVersion, String toVersion, String activity, String status, String activityName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/provision/upgrades";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (ctm != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ctm", ctm));
        }
        if (server != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("server", server));
        }
        if (agent != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("agent", agent));
        }
        if (fromVersion != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fromVersion", fromVersion));
        }
        if (toVersion != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("toVersion", toVersion));
        }
        if (activity != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("activity", activity));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", status));
        }
        if (activityName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("activityName", activityName));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAllUpgradeActivitiesStatusValidateBeforeCall(String ctm, String server, String agent, String fromVersion, String toVersion, String activity, String status, String activityName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getAllUpgradeActivitiesStatusCall(ctm, server, agent, fromVersion, toVersion, activity, status, activityName, progressListener, progressRequestListener);
        return call;
    }

    public UpgradeRecordList getAllUpgradeActivitiesStatus(String ctm, String server, String agent, String fromVersion, String toVersion, String activity, String status, String activityName) throws ApiException {
        ApiResponse<UpgradeRecordList> resp = this.getAllUpgradeActivitiesStatusWithHttpInfo(ctm, server, agent, fromVersion, toVersion, activity, status, activityName);
        return resp.getData();
    }

    public ApiResponse<UpgradeRecordList> getAllUpgradeActivitiesStatusWithHttpInfo(String ctm, String server, String agent, String fromVersion, String toVersion, String activity, String status, String activityName) throws ApiException {
        Call call = this.getAllUpgradeActivitiesStatusValidateBeforeCall(ctm, server, agent, fromVersion, toVersion, activity, status, activityName, null, null);
        Type localVarReturnType = new TypeToken<UpgradeRecordList>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAllUpgradeActivitiesStatusAsync(String ctm, String server, String agent, String fromVersion, String toVersion, String activity, String status, String activityName, final ApiCallback<UpgradeRecordList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAllUpgradeActivitiesStatusValidateBeforeCall(ctm, server, agent, fromVersion, toVersion, activity, status, activityName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UpgradeRecordList>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getDataCall(String requestName, String param1, String param2, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/provision/internal/data/{requestName}".replaceAll("\\{requestName\\}", this.apiClient.escapeString(requestName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (param1 != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("param1", param1));
        }
        if (param2 != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("param2", param2));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDataValidateBeforeCall(String requestName, String param1, String param2, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (requestName == null) {
            throw new ApiException("Missing the required parameter 'requestName' when calling getData(Async)");
        }
        Call call = this.getDataCall(requestName, param1, param2, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData getData(String requestName, String param1, String param2) throws ApiException {
        ApiResponse<SuccessData> resp = this.getDataWithHttpInfo(requestName, param1, param2);
        return resp.getData();
    }

    public ApiResponse<SuccessData> getDataWithHttpInfo(String requestName, String param1, String param2) throws ApiException {
        Call call = this.getDataValidateBeforeCall(requestName, param1, param2, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDataAsync(String requestName, String param1, String param2, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDataValidateBeforeCall(requestName, param1, param2, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getDeployVersionsCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/provision/upgrades/versions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDeployVersionsValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getDeployVersionsCall(progressListener, progressRequestListener);
        return call;
    }

    public List<UpgradeInfo> getDeployVersions() throws ApiException {
        ApiResponse<List<UpgradeInfo>> resp = this.getDeployVersionsWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<List<UpgradeInfo>> getDeployVersionsWithHttpInfo() throws ApiException {
        Call call = this.getDeployVersionsValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<List<UpgradeInfo>>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDeployVersionsAsync(final ApiCallback<List<UpgradeInfo>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDeployVersionsValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<UpgradeInfo>>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getEligibleAgentsForUpgradeCall(String type, String version, Boolean showIneligibleAgents, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/provision/upgrades/agents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (type != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        }
        if (version != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("version", version));
        }
        if (showIneligibleAgents != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("showIneligibleAgents", showIneligibleAgents));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getEligibleAgentsForUpgradeValidateBeforeCall(String type, String version, Boolean showIneligibleAgents, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getEligibleAgentsForUpgradeCall(type, version, showIneligibleAgents, progressListener, progressRequestListener);
        return call;
    }

    public UpgradeAgentInfoList getEligibleAgentsForUpgrade(String type, String version, Boolean showIneligibleAgents) throws ApiException {
        ApiResponse<UpgradeAgentInfoList> resp = this.getEligibleAgentsForUpgradeWithHttpInfo(type, version, showIneligibleAgents);
        return resp.getData();
    }

    public ApiResponse<UpgradeAgentInfoList> getEligibleAgentsForUpgradeWithHttpInfo(String type, String version, Boolean showIneligibleAgents) throws ApiException {
        Call call = this.getEligibleAgentsForUpgradeValidateBeforeCall(type, version, showIneligibleAgents, null, null);
        Type localVarReturnType = new TypeToken<UpgradeAgentInfoList>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getEligibleAgentsForUpgradeAsync(String type, String version, Boolean showIneligibleAgents, final ApiCallback<UpgradeAgentInfoList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getEligibleAgentsForUpgradeValidateBeforeCall(type, version, showIneligibleAgents, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UpgradeAgentInfoList>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getImagesCall(String os, String version, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/provision/images/{os}".replaceAll("\\{os\\}", this.apiClient.escapeString(os.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (version != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("version", version));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getImagesValidateBeforeCall(String os, String version, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (os == null) {
            throw new ApiException("Missing the required parameter 'os' when calling getImages(Async)");
        }
        Call call = this.getImagesCall(os, version, progressListener, progressRequestListener);
        return call;
    }

    public StringListResult getImages(String os, String version) throws ApiException {
        ApiResponse<StringListResult> resp = this.getImagesWithHttpInfo(os, version);
        return resp.getData();
    }

    public ApiResponse<StringListResult> getImagesWithHttpInfo(String os, String version) throws ApiException {
        Call call = this.getImagesValidateBeforeCall(os, version, null, null);
        Type localVarReturnType = new TypeToken<StringListResult>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getImagesAsync(String os, String version, final ApiCallback<StringListResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getImagesValidateBeforeCall(os, version, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<StringListResult>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getProvisionRepoCall(String repoName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/provision/repository/{repoName}".replaceAll("\\{repoName\\}", this.apiClient.escapeString(repoName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getProvisionRepoValidateBeforeCall(String repoName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (repoName == null) {
            throw new ApiException("Missing the required parameter 'repoName' when calling getProvisionRepo(Async)");
        }
        Call call = this.getProvisionRepoCall(repoName, progressListener, progressRequestListener);
        return call;
    }

    public ProvisionRepo getProvisionRepo(String repoName) throws ApiException {
        ApiResponse<ProvisionRepo> resp = this.getProvisionRepoWithHttpInfo(repoName);
        return resp.getData();
    }

    public ApiResponse<ProvisionRepo> getProvisionRepoWithHttpInfo(String repoName) throws ApiException {
        Call call = this.getProvisionRepoValidateBeforeCall(repoName, null, null);
        Type localVarReturnType = new TypeToken<ProvisionRepo>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getProvisionRepoAsync(String repoName, final ApiCallback<ProvisionRepo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getProvisionRepoValidateBeforeCall(repoName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ProvisionRepo>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getUpgradeActivityLogCall(String upgradeId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/provision/upgrade/{upgradeId}/output".replaceAll("\\{upgradeId\\}", this.apiClient.escapeString(upgradeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getUpgradeActivityLogValidateBeforeCall(String upgradeId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (upgradeId == null) {
            throw new ApiException("Missing the required parameter 'upgradeId' when calling getUpgradeActivityLog(Async)");
        }
        Call call = this.getUpgradeActivityLogCall(upgradeId, progressListener, progressRequestListener);
        return call;
    }

    public String getUpgradeActivityLog(String upgradeId) throws ApiException {
        ApiResponse<String> resp = this.getUpgradeActivityLogWithHttpInfo(upgradeId);
        return resp.getData();
    }

    public ApiResponse<String> getUpgradeActivityLogWithHttpInfo(String upgradeId) throws ApiException {
        Call call = this.getUpgradeActivityLogValidateBeforeCall(upgradeId, null, null);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getUpgradeActivityLogAsync(String upgradeId, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getUpgradeActivityLogValidateBeforeCall(upgradeId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getUpgradeActivityStatusPerUpgradeIdCall(String upgradeId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/provision/upgrade/{upgradeId}".replaceAll("\\{upgradeId\\}", this.apiClient.escapeString(upgradeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getUpgradeActivityStatusPerUpgradeIdValidateBeforeCall(String upgradeId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (upgradeId == null) {
            throw new ApiException("Missing the required parameter 'upgradeId' when calling getUpgradeActivityStatusPerUpgradeId(Async)");
        }
        Call call = this.getUpgradeActivityStatusPerUpgradeIdCall(upgradeId, progressListener, progressRequestListener);
        return call;
    }

    public UpgradeRecord getUpgradeActivityStatusPerUpgradeId(String upgradeId) throws ApiException {
        ApiResponse<UpgradeRecord> resp = this.getUpgradeActivityStatusPerUpgradeIdWithHttpInfo(upgradeId);
        return resp.getData();
    }

    public ApiResponse<UpgradeRecord> getUpgradeActivityStatusPerUpgradeIdWithHttpInfo(String upgradeId) throws ApiException {
        Call call = this.getUpgradeActivityStatusPerUpgradeIdValidateBeforeCall(upgradeId, null, null);
        Type localVarReturnType = new TypeToken<UpgradeRecord>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getUpgradeActivityStatusPerUpgradeIdAsync(String upgradeId, final ApiCallback<UpgradeRecord> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getUpgradeActivityStatusPerUpgradeIdValidateBeforeCall(upgradeId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UpgradeRecord>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listProvisionReposCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/provision/repositories";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listProvisionReposValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.listProvisionReposCall(progressListener, progressRequestListener);
        return call;
    }

    public ProvisionReposResults listProvisionRepos() throws ApiException {
        ApiResponse<ProvisionReposResults> resp = this.listProvisionReposWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<ProvisionReposResults> listProvisionReposWithHttpInfo() throws ApiException {
        Call call = this.listProvisionReposValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<ProvisionReposResults>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listProvisionReposAsync(final ApiCallback<ProvisionReposResults> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listProvisionReposValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ProvisionReposResults>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call retryUpgradeActivityCall(String upgradeId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/provision/upgrade/{upgradeId}/retry".replaceAll("\\{upgradeId\\}", this.apiClient.escapeString(upgradeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call retryUpgradeActivityValidateBeforeCall(String upgradeId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (upgradeId == null) {
            throw new ApiException("Missing the required parameter 'upgradeId' when calling retryUpgradeActivity(Async)");
        }
        Call call = this.retryUpgradeActivityCall(upgradeId, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData retryUpgradeActivity(String upgradeId) throws ApiException {
        ApiResponse<SuccessData> resp = this.retryUpgradeActivityWithHttpInfo(upgradeId);
        return resp.getData();
    }

    public ApiResponse<SuccessData> retryUpgradeActivityWithHttpInfo(String upgradeId) throws ApiException {
        Call call = this.retryUpgradeActivityValidateBeforeCall(upgradeId, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call retryUpgradeActivityAsync(String upgradeId, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.retryUpgradeActivityValidateBeforeCall(upgradeId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call transferAndInstallProductCall(UpgradeRequest upgradeRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpgradeRequest localVarPostBody = upgradeRequest;
        String localVarPath = "/provision/upgrade/install";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call transferAndInstallProductValidateBeforeCall(UpgradeRequest upgradeRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (upgradeRequest == null) {
            throw new ApiException("Missing the required parameter 'upgradeRequest' when calling transferAndInstallProduct(Async)");
        }
        Call call = this.transferAndInstallProductCall(upgradeRequest, progressListener, progressRequestListener);
        return call;
    }

    public UpgradeResponse transferAndInstallProduct(UpgradeRequest upgradeRequest) throws ApiException {
        ApiResponse<UpgradeResponse> resp = this.transferAndInstallProductWithHttpInfo(upgradeRequest);
        return resp.getData();
    }

    public ApiResponse<UpgradeResponse> transferAndInstallProductWithHttpInfo(UpgradeRequest upgradeRequest) throws ApiException {
        Call call = this.transferAndInstallProductValidateBeforeCall(upgradeRequest, null, null);
        Type localVarReturnType = new TypeToken<UpgradeResponse>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call transferAndInstallProductAsync(UpgradeRequest upgradeRequest, final ApiCallback<UpgradeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.transferAndInstallProductValidateBeforeCall(upgradeRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UpgradeResponse>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call transferProductCall(UpgradeRequest upgradeRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpgradeRequest localVarPostBody = upgradeRequest;
        String localVarPath = "/provision/upgrade/transfer";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call transferProductValidateBeforeCall(UpgradeRequest upgradeRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (upgradeRequest == null) {
            throw new ApiException("Missing the required parameter 'upgradeRequest' when calling transferProduct(Async)");
        }
        Call call = this.transferProductCall(upgradeRequest, progressListener, progressRequestListener);
        return call;
    }

    public UpgradeResponse transferProduct(UpgradeRequest upgradeRequest) throws ApiException {
        ApiResponse<UpgradeResponse> resp = this.transferProductWithHttpInfo(upgradeRequest);
        return resp.getData();
    }

    public ApiResponse<UpgradeResponse> transferProductWithHttpInfo(UpgradeRequest upgradeRequest) throws ApiException {
        Call call = this.transferProductValidateBeforeCall(upgradeRequest, null, null);
        Type localVarReturnType = new TypeToken<UpgradeResponse>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call transferProductAsync(UpgradeRequest upgradeRequest, final ApiCallback<UpgradeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.transferProductValidateBeforeCall(upgradeRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UpgradeResponse>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call uninstallProductCall(UpgradeRequest rollbackRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpgradeRequest localVarPostBody = rollbackRequest;
        String localVarPath = "/provision/upgrade/uninstall";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call uninstallProductValidateBeforeCall(UpgradeRequest rollbackRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (rollbackRequest == null) {
            throw new ApiException("Missing the required parameter 'rollbackRequest' when calling uninstallProduct(Async)");
        }
        Call call = this.uninstallProductCall(rollbackRequest, progressListener, progressRequestListener);
        return call;
    }

    public UpgradeResponse uninstallProduct(UpgradeRequest rollbackRequest) throws ApiException {
        ApiResponse<UpgradeResponse> resp = this.uninstallProductWithHttpInfo(rollbackRequest);
        return resp.getData();
    }

    public ApiResponse<UpgradeResponse> uninstallProductWithHttpInfo(UpgradeRequest rollbackRequest) throws ApiException {
        Call call = this.uninstallProductValidateBeforeCall(rollbackRequest, null, null);
        Type localVarReturnType = new TypeToken<UpgradeResponse>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call uninstallProductAsync(UpgradeRequest rollbackRequest, final ApiCallback<UpgradeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.uninstallProductValidateBeforeCall(rollbackRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UpgradeResponse>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call validateUpgradePackagesCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/provision/upgrades/validatePackages";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call validateUpgradePackagesValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.validateUpgradePackagesCall(progressListener, progressRequestListener);
        return call;
    }

    public Boolean validateUpgradePackages() throws ApiException {
        ApiResponse<Boolean> resp = this.validateUpgradePackagesWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<Boolean> validateUpgradePackagesWithHttpInfo() throws ApiException {
        Call call = this.validateUpgradePackagesValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<Boolean>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call validateUpgradePackagesAsync(final ApiCallback<Boolean> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.validateUpgradePackagesValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Boolean>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

