/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import io.swagger.client.model.DeploymentFileResults;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BuildApi {
    private ApiClient apiClient;

    public BuildApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BuildApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call buildFileCall(File definitionsFile, File deployDescriptorFile, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/build";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (definitionsFile != null) {
            localVarFormParams.put("definitionsFile", definitionsFile);
        }
        if (deployDescriptorFile != null) {
            localVarFormParams.put("deployDescriptorFile", deployDescriptorFile);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call buildFileValidateBeforeCall(File definitionsFile, File deployDescriptorFile, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (definitionsFile == null) {
            throw new ApiException("Missing the required parameter 'definitionsFile' when calling buildFile(Async)");
        }
        Call call = this.buildFileCall(definitionsFile, deployDescriptorFile, progressListener, progressRequestListener);
        return call;
    }

    public List<DeploymentFileResults> buildFile(File definitionsFile, File deployDescriptorFile) throws ApiException {
        ApiResponse<List<DeploymentFileResults>> resp = this.buildFileWithHttpInfo(definitionsFile, deployDescriptorFile);
        return resp.getData();
    }

    public ApiResponse<List<DeploymentFileResults>> buildFileWithHttpInfo(File definitionsFile, File deployDescriptorFile) throws ApiException {
        Call call = this.buildFileValidateBeforeCall(definitionsFile, deployDescriptorFile, null, null);
        Type localVarReturnType = new TypeToken<List<DeploymentFileResults>>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call buildFileAsync(File definitionsFile, File deployDescriptorFile, final ApiCallback<List<DeploymentFileResults>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.buildFileValidateBeforeCall(definitionsFile, deployDescriptorFile, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<DeploymentFileResults>>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

