/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import io.swagger.client.model.SuccessData;
import io.swagger.client.model.TokenByValueRequest;
import io.swagger.client.model.TokenDataRequest;
import io.swagger.client.model.TokenDataResponse;
import io.swagger.client.model.TokenList;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class AuthenticationApi {
    private ApiClient apiClient;

    public AuthenticationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthenticationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createTokenCall(TokenDataRequest tokenDataFile, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TokenDataRequest localVarPostBody = tokenDataFile;
        String localVarPath = "/authentication/token";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createTokenValidateBeforeCall(TokenDataRequest tokenDataFile, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tokenDataFile == null) {
            throw new ApiException("Missing the required parameter 'tokenDataFile' when calling createToken(Async)");
        }
        Call call = this.createTokenCall(tokenDataFile, progressListener, progressRequestListener);
        return call;
    }

    public TokenDataResponse createToken(TokenDataRequest tokenDataFile) throws ApiException {
        ApiResponse<TokenDataResponse> resp = this.createTokenWithHttpInfo(tokenDataFile);
        return resp.getData();
    }

    public ApiResponse<TokenDataResponse> createTokenWithHttpInfo(TokenDataRequest tokenDataFile) throws ApiException {
        Call call = this.createTokenValidateBeforeCall(tokenDataFile, null, null);
        Type localVarReturnType = new TypeToken<TokenDataResponse>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createTokenAsync(TokenDataRequest tokenDataFile, final ApiCallback<TokenDataResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createTokenValidateBeforeCall(tokenDataFile, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TokenDataResponse>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteTokenCall(String tokenName, Boolean forAgent, String type, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/authentication/token/{tokenName}".replaceAll("\\{tokenName\\}", this.apiClient.escapeString(tokenName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (forAgent != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("forAgent", forAgent));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteTokenValidateBeforeCall(String tokenName, Boolean forAgent, String type, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tokenName == null) {
            throw new ApiException("Missing the required parameter 'tokenName' when calling deleteToken(Async)");
        }
        Call call = this.deleteTokenCall(tokenName, forAgent, type, progressListener, progressRequestListener);
        return call;
    }

    public SuccessData deleteToken(String tokenName, Boolean forAgent, String type) throws ApiException {
        ApiResponse<SuccessData> resp = this.deleteTokenWithHttpInfo(tokenName, forAgent, type);
        return resp.getData();
    }

    public ApiResponse<SuccessData> deleteTokenWithHttpInfo(String tokenName, Boolean forAgent, String type) throws ApiException {
        Call call = this.deleteTokenValidateBeforeCall(tokenName, forAgent, type, null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteTokenAsync(String tokenName, Boolean forAgent, String type, final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteTokenValidateBeforeCall(tokenName, forAgent, type, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTokenDataCall(String tokenName, Boolean forAgent, String type, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/authentication/token/{tokenName}".replaceAll("\\{tokenName\\}", this.apiClient.escapeString(tokenName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (forAgent != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("forAgent", forAgent));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTokenDataValidateBeforeCall(String tokenName, Boolean forAgent, String type, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tokenName == null) {
            throw new ApiException("Missing the required parameter 'tokenName' when calling getTokenData(Async)");
        }
        Call call = this.getTokenDataCall(tokenName, forAgent, type, progressListener, progressRequestListener);
        return call;
    }

    public TokenDataResponse getTokenData(String tokenName, Boolean forAgent, String type) throws ApiException {
        ApiResponse<TokenDataResponse> resp = this.getTokenDataWithHttpInfo(tokenName, forAgent, type);
        return resp.getData();
    }

    public ApiResponse<TokenDataResponse> getTokenDataWithHttpInfo(String tokenName, Boolean forAgent, String type) throws ApiException {
        Call call = this.getTokenDataValidateBeforeCall(tokenName, forAgent, type, null, null);
        Type localVarReturnType = new TypeToken<TokenDataResponse>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTokenDataAsync(String tokenName, Boolean forAgent, String type, final ApiCallback<TokenDataResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTokenDataValidateBeforeCall(tokenName, forAgent, type, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TokenDataResponse>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTokenDataByValueCall(TokenByValueRequest tokenValue, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TokenByValueRequest localVarPostBody = tokenValue;
        String localVarPath = "/authentication/tokenbyvalue";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTokenDataByValueValidateBeforeCall(TokenByValueRequest tokenValue, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tokenValue == null) {
            throw new ApiException("Missing the required parameter 'tokenValue' when calling getTokenDataByValue(Async)");
        }
        Call call = this.getTokenDataByValueCall(tokenValue, progressListener, progressRequestListener);
        return call;
    }

    public TokenDataResponse getTokenDataByValue(TokenByValueRequest tokenValue) throws ApiException {
        ApiResponse<TokenDataResponse> resp = this.getTokenDataByValueWithHttpInfo(tokenValue);
        return resp.getData();
    }

    public ApiResponse<TokenDataResponse> getTokenDataByValueWithHttpInfo(TokenByValueRequest tokenValue) throws ApiException {
        Call call = this.getTokenDataByValueValidateBeforeCall(tokenValue, null, null);
        Type localVarReturnType = new TypeToken<TokenDataResponse>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTokenDataByValueAsync(TokenByValueRequest tokenValue, final ApiCallback<TokenDataResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTokenDataByValueValidateBeforeCall(tokenValue, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TokenDataResponse>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTokenExpirationCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/authentication/token/expiration";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTokenExpirationValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getTokenExpirationCall(progressListener, progressRequestListener);
        return call;
    }

    public SuccessData getTokenExpiration() throws ApiException {
        ApiResponse<SuccessData> resp = this.getTokenExpirationWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<SuccessData> getTokenExpirationWithHttpInfo() throws ApiException {
        Call call = this.getTokenExpirationValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTokenExpirationAsync(final ApiCallback<SuccessData> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTokenExpirationValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuccessData>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTokenListCall(Boolean forAgent, String type, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/authentication/tokens";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (forAgent != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("forAgent", forAgent));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTokenListValidateBeforeCall(Boolean forAgent, String type, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getTokenListCall(forAgent, type, progressListener, progressRequestListener);
        return call;
    }

    public TokenList getTokenList(Boolean forAgent, String type) throws ApiException {
        ApiResponse<TokenList> resp = this.getTokenListWithHttpInfo(forAgent, type);
        return resp.getData();
    }

    public ApiResponse<TokenList> getTokenListWithHttpInfo(Boolean forAgent, String type) throws ApiException {
        Call call = this.getTokenListValidateBeforeCall(forAgent, type, null, null);
        Type localVarReturnType = new TypeToken<TokenList>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTokenListAsync(Boolean forAgent, String type, final ApiCallback<TokenList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTokenListValidateBeforeCall(forAgent, type, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TokenList>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateTokenCall(TokenDataRequest tokenDataFile, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TokenDataRequest localVarPostBody = tokenDataFile;
        String localVarPath = "/authentication/token";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "Bearer"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateTokenValidateBeforeCall(TokenDataRequest tokenDataFile, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tokenDataFile == null) {
            throw new ApiException("Missing the required parameter 'tokenDataFile' when calling updateToken(Async)");
        }
        Call call = this.updateTokenCall(tokenDataFile, progressListener, progressRequestListener);
        return call;
    }

    public TokenDataResponse updateToken(TokenDataRequest tokenDataFile) throws ApiException {
        ApiResponse<TokenDataResponse> resp = this.updateTokenWithHttpInfo(tokenDataFile);
        return resp.getData();
    }

    public ApiResponse<TokenDataResponse> updateTokenWithHttpInfo(TokenDataRequest tokenDataFile) throws ApiException {
        Call call = this.updateTokenValidateBeforeCall(tokenDataFile, null, null);
        Type localVarReturnType = new TypeToken<TokenDataResponse>(this){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateTokenAsync(TokenDataRequest tokenDataFile, final ApiCallback<TokenDataResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateTokenValidateBeforeCall(tokenDataFile, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TokenDataResponse>(this){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

