/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.messages;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.CsvFile;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.draftwriter.JobMessage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;

public class FullReportTable
extends CsvFile {
    private static FullReportTable instance;
    private static String tableName;
    public static final String HASH_KEY_SEPERATOR = "|";
    private TreeMap<String, JobMessage> m_messages;
    private TreeMap<String, JobMessage> m_messages_byJobId;
    private HashMap<String, ArrayList<JobMessage>> m_messages_listByJobId;

    public static FullReportTable instance(String tableName) {
        if (instance == null || !tableName.equals(FullReportTable.tableName)) {
            instance = new FullReportTable(tableName);
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    private FullReportTable(String tableName) {
        FullReportTable.tableName = tableName;
        this.m_messages = new TreeMap();
        this.m_messages_byJobId = new TreeMap();
        this.m_messages_listByJobId = new HashMap();
        this.load(tableName);
    }

    public TreeMap<String, JobMessage> getMessages() {
        return this.m_messages;
    }

    public TreeMap<String, JobMessage> getMessagesByJobId() {
        return this.m_messages_byJobId;
    }

    public ArrayList<JobMessage> getMessagesListByJobId(String jobId) {
        return this.m_messages_listByJobId.get(jobId);
    }

    @Override
    protected void handleRecord(IAttrHolder job_entry, int record_number) {
        Object hashKey = "";
        JobMessage job_message = new JobMessage(job_entry);
        hashKey = job_entry.getAttr("MSGID") + HASH_KEY_SEPERATOR + job_entry.getAttr("JOBID") + HASH_KEY_SEPERATOR + Integer.toString(record_number);
        this.m_messages.put((String)hashKey, job_message);
        hashKey = job_entry.getAttr("JOBID") + HASH_KEY_SEPERATOR + job_entry.getAttr("MSGID") + HASH_KEY_SEPERATOR + Integer.toString(record_number);
        this.m_messages_byJobId.put((String)hashKey, job_message);
        String JobID = job_entry.getAttr("RESID");
        JobID = JobID.substring(JobID.lastIndexOf("-") + 1, JobID.length());
        ArrayList<JobMessage> tmpMsgList = this.m_messages_listByJobId.containsKey(JobID) ? this.m_messages_listByJobId.get(JobID) : new ArrayList<JobMessage>();
        tmpMsgList.add(job_message);
        this.m_messages_listByJobId.put(JobID, tmpMsgList);
    }

    public void saveCsv(TreeMap<String, AttrHolderList> boxes, File csvFile) {
        boolean headerWriten = false;
        try {
            if (csvFile.exists()) {
                csvFile.delete();
            }
            csvFile.createNewFile();
            BufferedWriter fileBW = new BufferedWriter(new FileWriter(csvFile, true));
            for (String key : boxes.keySet()) {
                if (!headerWriten) {
                    IAttrHolder tmpAH = (IAttrHolder)boxes.get(key).get(0);
                    fileBW.write(tmpAH.getCsvHeader());
                    fileBW.write("\n");
                    headerWriten = true;
                }
                AttrHolderList list = boxes.get(key);
                for (IAttrHolder job : list) {
                    String csvRow = job.toString();
                    fileBW.write(csvRow);
                    fileBW.write("\n");
                }
            }
            fileBW.close();
        }
        catch (FileNotFoundException e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
    }
}

