/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.messages;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.JobMessage;
import com.bmc.ctmconvert.common.draftwriter.MessageMappingInterface;
import com.bmc.ctmconvert.io.csv.CsvWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConversionMessagesMappingCsvTable
implements MessageMappingInterface {
    private static final String MAPPING_HEADER_INDEX = "ID";
    private static final String MAPPING_HEADER_MESSAGE_ID = "MESSAGE_ID";
    private static final String MAPPING_HEADER_MESSAGE_DESCRIPTION = "MESSAGE_DESCRIPTION";
    private static final String MAPPING_HEADER_ORIGINAL_JOB_DATA = "ORIGINAL_JOB_DATA";
    private static final int MAPPING_INDEX_INDEX = 0;
    private static final int MAPPING_MESSAGE_ID_INDEX = 1;
    private static final int MAPPING_MESSAGE_DESCRIPTION_INDEX = 2;
    private static final int MAPPING_ORIGINAL_JOB_DATA_INDEX = 3;
    private static final int MAPPING_NUMBER_OF_FIELDS = 4;
    private List<String[]> values;
    private String reportFilename;
    private Map<SchedEntity, String> jobOriginalDataMap;

    public List<String[]> getValues() {
        return this.values;
    }

    public ConversionMessagesMappingCsvTable(String reportFilename) {
        this.reportFilename = reportFilename;
        this.jobOriginalDataMap = new HashMap<SchedEntity, String>();
        this.values = new ArrayList<String[]>();
    }

    @Override
    public void addMessage(JobMessage message, SchedEntity job) {
        String[] value = new String[4];
        value[0] = message.getID();
        value[1] = message.getMessageID();
        value[2] = message.getMessageExtendedText();
        if (value[2].trim().replace(".", "").isEmpty()) {
            value[2] = message.getMessageText();
        }
        String jobOriginalData = "N/A";
        if (job != null) {
            jobOriginalData = this.getOriginalData(job);
        }
        value[3] = jobOriginalData;
        this.values.add(value);
    }

    private String getOriginalData(SchedEntity job) {
        if (!this.jobOriginalDataMap.containsKey(job)) {
            String originalData = job.getOriginalJobData();
            this.jobOriginalDataMap.put(job, originalData);
        }
        return this.jobOriginalDataMap.get(job);
    }

    @Override
    public void writeMappingFile() {
        try (CsvWriter writer = new CsvWriter(this.reportFilename);){
            this.writeMappingFile(writer);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
    }

    public void writeMappingFile(CsvWriter writer) throws IOException {
        String[] headers = new String[]{MAPPING_HEADER_INDEX, MAPPING_HEADER_MESSAGE_ID, MAPPING_HEADER_MESSAGE_DESCRIPTION, MAPPING_HEADER_ORIGINAL_JOB_DATA};
        writer.writeRecord(headers);
        for (String[] value : this.values) {
            writer.writeRecord(value);
        }
    }
}

