/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.GenerateScripts;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;

class QunatitativeResourceScriptGenerator {
    private Map<Object, Object> quantitativeResources;
    private FileSystem fileSystem;
    private Path scriptsPath;

    public QunatitativeResourceScriptGenerator(Map<Object, Object> quantitativeResources) {
        this(FileSystems.getDefault(), quantitativeResources);
    }

    public QunatitativeResourceScriptGenerator(FileSystem fileSystem, Map<Object, Object> quantitativeResources) {
        this.fileSystem = fileSystem;
        this.quantitativeResources = quantitativeResources;
    }

    public boolean generate() {
        if (this.quantitativeResources == null || this.quantitativeResources.isEmpty()) {
            return false;
        }
        this.scriptsPath = this.getPostConversionScriptsPath();
        GenerateScripts.createFolder(this.scriptsPath);
        try {
            if (SettingsBooleanKeys.isOnPremise()) {
                this.generateAllScripts();
            } else {
                this.generateScriptsForSaaS();
            }
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
        return true;
    }

    private void generateAllScripts() throws IOException {
        this.generateScriptsForOnPrem();
        this.generateScriptsForSaaS();
        if (Params.instance().isZOS()) {
            this.generateScriptsZos();
        }
    }

    private void generateScriptsZos() throws IOException {
        Path file = this.scriptsPath.resolve("IOACND");
        try (BufferedWriter output = Files.newBufferedWriter(file, new OpenOption[0]);){
            for (Map.Entry<Object, Object> entry : this.quantitativeResources.entrySet()) {
                String key = (String)entry.getKey();
                Integer value = (Integer)entry.getValue();
                output.write("CHANGE RESOURCE " + key + " " + value + "\n");
            }
        }
    }

    private void generateScriptsForOnPrem() throws IOException {
        Path filePerl = this.scriptsPath.resolve("Quantitative_Resources_Script_Perl.pl");
        Path fileWindows = this.scriptsPath.resolve("Quantitative_Resources_Script_Windows.bat");
        Path fileUnix = this.scriptsPath.resolve("Quantitative_Resources_Script_Unix.sh");
        try (BufferedWriter outputPerl = Files.newBufferedWriter(filePerl, new OpenOption[0]);
             BufferedWriter outputWindows = Files.newBufferedWriter(fileWindows, new OpenOption[0]);
             BufferedWriter outputUnix = Files.newBufferedWriter(fileUnix, new OpenOption[0]);){
            outputPerl.write("#!/bin/perl\n");
            outputPerl.write("use strict;\n");
            outputPerl.write("use warnings;\n\n");
            outputUnix.write("#!/bin/sh\n\n");
            outputWindows.write("@echo off\n\n");
            for (Map.Entry<Object, Object> entry : this.quantitativeResources.entrySet()) {
                String key = (String)entry.getKey();
                Integer value = (Integer)entry.getValue();
                outputPerl.write("system(\"ecaqrtab\", \"ADD\", \"" + key + "\", \"" + value + "\");\n");
                outputWindows.write("ecaqrtab add " + key + " " + value + "\n");
                outputUnix.write("ecaqrtab add " + key + " " + value + "\n");
            }
        }
    }

    private void generateScriptsForSaaS() throws IOException {
        Path semaphoresScriptWindowsPath = this.scriptsPath.resolve("Semaphores_Script_Windows.bat");
        Path semaphoresScriptUnixPath = this.scriptsPath.resolve("Semaphores_Script_Unix.sh");
        try (BufferedWriter semaphoresScriptWindows = Files.newBufferedWriter(semaphoresScriptWindowsPath, new OpenOption[0]);
             BufferedWriter semaphoresScriptUnix = Files.newBufferedWriter(semaphoresScriptUnixPath, new OpenOption[0]);){
            semaphoresScriptWindows.write("@echo off\n\n");
            semaphoresScriptUnix.write("#!/bin/sh\n\n");
            for (Map.Entry<Object, Object> entry : this.quantitativeResources.entrySet()) {
                String key = (String)entry.getKey();
                Integer value = (Integer)entry.getValue();
                String controlmName = GlobalFunctions.getControlMName();
                semaphoresScriptWindows.write("call ctm run resource::add " + controlmName + " " + key + " " + value + "\n");
                semaphoresScriptUnix.write("ctm run resource::add " + controlmName + " " + key + " " + value + "\n");
            }
        }
    }

    public Path getPostConversionScriptsPath() {
        return this.fileSystem.getPath(ConversionEntitiesService.getCurrentConversionPostDirectory(), new String[0]);
    }
}

