/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.GenerateScripts;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;

class NodeGroupsScriptGenerator {
    private final Map<String, Set<String>> nodeGroups;
    private final Path postConversionPath;

    public NodeGroupsScriptGenerator(Map<String, Set<String>> nodeGroups, Path postConversionPath) {
        this.nodeGroups = nodeGroups;
        this.postConversionPath = postConversionPath;
    }

    public boolean generate() {
        if (this.nodeGroups == null || this.nodeGroups.isEmpty()) {
            return false;
        }
        GenerateScripts.createFolder(this.postConversionPath);
        try {
            if (SettingsBooleanKeys.isOnPremise()) {
                this.generateAllScripts();
            } else {
                this.generateSaaSScripts();
            }
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile(e);
            return false;
        }
        return true;
    }

    private void generateAllScripts() throws IOException {
        this.generateOnPremScripts();
        this.generateSaaSScripts();
    }

    private void generateSaaSScripts() throws IOException {
        Path aapiHostGroupScriptWindows = this.postConversionPath.resolve("HostGroup_Script_Windows_AAPI.bat");
        Path aapiHostGroupScriptUnix = this.postConversionPath.resolve("HostGroup_Script_Unix_AAPI.sh");
        try (BufferedWriter outputWindows = Files.newBufferedWriter(aapiHostGroupScriptWindows, new OpenOption[0]);
             BufferedWriter outputUnix = Files.newBufferedWriter(aapiHostGroupScriptUnix, new OpenOption[0]);){
            outputUnix.write("#!/bin/sh\n\n");
            outputWindows.write("@echo off\n\n");
            for (Map.Entry<String, Set<String>> nodeGroup : this.nodeGroups.entrySet()) {
                String ctm = GlobalFunctions.getControlMName();
                String hostGroupName = nodeGroup.getKey();
                Set<String> hostNames = nodeGroup.getValue();
                for (String host : hostNames) {
                    String automationApi = "ctm config server:hostgroup:agent::add " + ctm + " " + hostGroupName + " " + host + "\n";
                    outputWindows.write("CALL " + automationApi);
                    outputUnix.write(automationApi);
                }
            }
        }
    }

    private void generateOnPremScripts() throws IOException {
        Path perlScript = this.postConversionPath.resolve("Node_Group_Script_Perl.pl");
        Path windowsScript = this.postConversionPath.resolve("Node_Group_Script_Windows.bat");
        Path unixScript = this.postConversionPath.resolve("Node_Group_Script_Unix.sh");
        try (BufferedWriter outputPerl = Files.newBufferedWriter(perlScript, new OpenOption[0]);
             BufferedWriter outputWindows = Files.newBufferedWriter(windowsScript, new OpenOption[0]);
             BufferedWriter outputUnix = Files.newBufferedWriter(unixScript, new OpenOption[0]);){
            outputPerl.write("#!/bin/perl\nuse strict;\nuse warnings;\n\n");
            outputUnix.write("#!/bin/sh\n\n");
            outputWindows.write("@echo off\n\n");
            for (Map.Entry<String, Set<String>> nodeGroup : this.nodeGroups.entrySet()) {
                String nodeGroupName = nodeGroup.getKey();
                Set<String> nodes = nodeGroup.getValue();
                for (String node : nodes) {
                    outputPerl.write("system( \"ctmnodegrp\", \"-edit\", \"-nodegrp\", '" + nodeGroupName + "', \"-appltype\", \"OS\", \"-add\", '" + node + "');\n");
                    outputWindows.write("ctmnodegrp -edit -nodegrp \"" + nodeGroupName + "\" -appltype OS -add \"" + node + "\"\n");
                    outputUnix.write("ctmnodegrp -edit -nodegrp \"" + nodeGroupName + "\" -appltype OS -add \"" + node + "\"\n");
                }
            }
        }
    }
}

