/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.AFTAccountsGenerator;
import com.bmc.ctmconvert.DBConnectionProfilesGenerator;
import com.bmc.ctmconvert.GlobalVariableScriptGenerator;
import com.bmc.ctmconvert.NodeGroupsScriptGenerator;
import com.bmc.ctmconvert.QunatitativeResourceScriptGenerator;
import com.bmc.ctmconvert.UserDailyScriptGenerator;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GenerateScripts {
    private GenerateScripts() {
    }

    static void createFolder(String path) {
        GenerateScripts.createFolder(Paths.get(path, new String[0]));
    }

    static void createFolder(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                ConversionLogger.getLogger().info(e.getMessage());
                ExceptionHandler.writeToExceptionFile(e);
            }
        }
    }

    public static boolean generateQRScript(Map<Object, Object> quantitativeResources) {
        return new QunatitativeResourceScriptGenerator(quantitativeResources).generate();
    }

    public static boolean generateGVScript(Map<Object, Object> globalVariables) {
        return new GlobalVariableScriptGenerator(globalVariables).generateScripts();
    }

    public static boolean generateUDScript(Map<Object, Object> userDailyList) {
        return new UserDailyScriptGenerator(userDailyList).generateScripts();
    }

    public static boolean generateNGScript(Map<String, Set<String>> nodeGroups, Path postConversionPath) {
        return new NodeGroupsScriptGenerator(nodeGroups, postConversionPath).generate();
    }

    public static boolean generateCPAFTAccountScript(Map<String, String> aftMap, Map<String, Set<String>> nodeGroupMap) {
        if (aftMap == null || aftMap.isEmpty()) {
            return false;
        }
        AFTAccountsGenerator aFTAccountsGenerator = new AFTAccountsGenerator();
        String path = ConversionEntitiesService.getCurrentConversionPostDirectory();
        GenerateScripts.createFolder(path);
        File fileWindows = new File(path + Globs.DIRSEP + "AFT_ACCOUNTS_Script_Windows.bat");
        File fileUnix = new File(path + Globs.DIRSEP + "AFT_ACCOUNTS_Script_Unix.sh");
        try (BufferedWriter outputWindows = new BufferedWriter(new FileWriter(fileWindows));
             BufferedWriter outputUnix = new BufferedWriter(new FileWriter(fileUnix));){
            String accountDir = path + Globs.POST_CONVERSION_AFT_DIR_NAME;
            GenerateScripts.createFolder(accountDir);
            List<String> filesPath = aFTAccountsGenerator.writeAFTAccountsJSON(Paths.get(accountDir, new String[0]), aftMap, nodeGroupMap);
            outputUnix.write("#!/bin/sh\n\n");
            outputWindows.write("@echo off\n\n");
            for (String fileP : filesPath) {
                outputWindows.write("start /B ctm deploy \"" + fileP + "\"\n");
                outputUnix.write("echo \" Importing: " + fileP + "\"\n");
                outputUnix.write("ctm deploy \"" + fileP + "\"\n");
            }
        }
        catch (IOException | NullPointerException e) {
            ExceptionHandler.writeToExceptionFile(e);
            return false;
        }
        return true;
    }

    public static boolean generateCPDataBaseScript(Map<String, String> databaseMap, Map<String, Set<String>> nodeGroupMap) {
        if (databaseMap == null || databaseMap.isEmpty()) {
            return false;
        }
        DBConnectionProfilesGenerator dbConnectionProfilesGenerator = new DBConnectionProfilesGenerator();
        String path = ConversionEntitiesService.getCurrentConversionPostDirectory();
        GenerateScripts.createFolder(path);
        File fileWindows = new File(path + Globs.DIRSEP + "DATABASE_CONNECTION_PROFILE_Script_Windows.bat");
        File fileUnix = new File(path + Globs.DIRSEP + "DATABASE_CONNECTION_PROFILE_Script_Unix.sh");
        try (BufferedWriter outputWindows = new BufferedWriter(new FileWriter(fileWindows));
             BufferedWriter outputUnix = new BufferedWriter(new FileWriter(fileUnix));){
            String accountDir = path + Globs.POST_CONVERSION_DATABASE_DIR_NAME;
            GenerateScripts.createFolder(accountDir);
            List<String> filesPath = dbConnectionProfilesGenerator.writeDBConnectionProfilesJSON(Paths.get(accountDir, new String[0]), databaseMap, nodeGroupMap);
            outputUnix.write("#!/bin/sh\n\n");
            outputWindows.write("@echo off\n\n");
            for (String fileP : filesPath) {
                outputWindows.write("start /B ctm deploy \"" + fileP + "\"\n");
                outputUnix.write("echo \" Importing: " + fileP + "\"\n");
                outputUnix.write("ctm deploy \"" + fileP + "\"\n");
            }
        }
        catch (IOException | NullPointerException e) {
            ExceptionHandler.writeToExceptionFile(e);
            return false;
        }
        return true;
    }
}

