/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation.report;

import com.bmc.cnvvalidation.CommonJobFH;
import com.bmc.cnvvalidation.report.CsvReport;
import com.bmc.cnvvalidation.report.ExcelReport;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

public class ReportWriter {
    private final CsvReport csvReport;
    private final ExcelReport excelReport;

    public ReportWriter(CsvReport csvReport, ExcelReport excelReport) {
        this.csvReport = csvReport;
        this.excelReport = excelReport;
    }

    public static List<String> createReportHeaders() {
        return List.of("Status", "Job Name", "Job Occurrence", "Control-M", "Folder", "Library", "Run Count", "Start", "End", "Vendor Start", "Run Date", "Update timestamp", "Original Job Name", "Origin", "Vendor Specific", "Order Date");
    }

    public void reportJob(CommonJobFH ctmJob, CommonJobFH legacyJob, String status) throws IOException {
        CommonJobFH job = this.getActiveJob(ctmJob, legacyJob);
        List<String> fields = List.of(status, job.getJobMemName(), job.getJobMemNameOccurrence(), job.getControlm(), job.getFolder(), job.getSchedulingLibraryDsn(), job.getRunCount(), this.getStartRunFrom(ctmJob), job.getEndRun(), this.getStartRunFrom(legacyJob), job.getRunDate(), job.getUpdatedTimeStamp(), job.getOriginalJobname(), job.getOrigin(), job.getVendorSpecific(), job.getOrderDate());
        this.csvReport.writeLine(fields);
        this.excelReport.addRow(fields);
    }

    private CommonJobFH getActiveJob(CommonJobFH ctmJob, CommonJobFH legacyJob) {
        if (ctmJob != null) {
            return ctmJob;
        }
        return legacyJob;
    }

    public void close() throws Exception {
        this.csvReport.close();
    }

    private String getStartRunFrom(CommonJobFH job) {
        return Optional.ofNullable(job).map(CommonJobFH::getStartRun).orElse("");
    }
}

