/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation.report;

import com.bmc.cnvvalidation.ExternalParameters;
import com.bmc.cnvvalidation.report.ReportWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExcelReport {
    private final SXSSFWorkbook excelReport;
    private Sheet excelReportSheet;
    private String newName = null;
    private final String fullReportName;
    private int rowNumberForReport = 0;
    private final int maxRowsForExcelReport;
    private final ExternalParameters externalParameters;

    public ExcelReport(String fullReportName, ExternalParameters externalParameters) {
        this.externalParameters = externalParameters;
        this.fullReportName = fullReportName;
        this.excelReport = new SXSSFWorkbook();
        this.maxRowsForExcelReport = this.externalParameters.getMaxRowsForExcelReport();
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public void startReport(String sheetName) {
        this.excelReportSheet = this.excelReport.createSheet(sheetName);
        this.addRow(ReportWriter.createReportHeaders());
        this.excelReportSheet.createFreezePane(0, 1);
        this.excelReportSheet.setColumnWidth(0, 5000);
        this.excelReportSheet.setColumnWidth(1, 5000);
        this.excelReportSheet.setColumnWidth(2, 5000);
        this.excelReportSheet.setColumnWidth(3, 5000);
    }

    public void addRow(List<String> fields) {
        if (this.rowNumberForReport > this.maxRowsForExcelReport) {
            return;
        }
        Row row = this.excelReportSheet.createRow(this.rowNumberForReport++);
        int columnNumber = 0;
        for (String field : fields) {
            this.createCell(row, columnNumber++, field);
        }
    }

    public void termReport(List<String> messages) throws IOException {
        this.excelReportSheet.setAutoFilter(new CellRangeAddress(0, this.rowNumberForReport - 1, 0, ReportWriter.createReportHeaders().size() - 1));
        this.createParametersSheet();
        this.createSummarySheet(messages);
        if (this.newName == null) {
            this.newName = this.fullReportName;
        }
        this.excelReport.write((OutputStream)new FileOutputStream(this.newName));
        this.excelReport.close();
    }

    public void createParametersSheet() {
        List<String> lvv = this.externalParameters.listAllVariablesAndValues();
        SXSSFSheet excelParametersSheet = this.excelReport.createSheet("ParametersInUse");
        int parmRowNumber = 0;
        for (String s : lvv) {
            String[] lvvPV = s.split("=");
            SXSSFRow row = excelParametersSheet.createRow(parmRowNumber++);
            this.createCell((Row)row, 0, lvvPV[0]);
            if (lvvPV.length <= 1) continue;
            this.createCell((Row)row, 1, lvvPV[1]);
        }
        excelParametersSheet.trackAllColumnsForAutoSizing();
        excelParametersSheet.autoSizeColumn(0);
        excelParametersSheet.autoSizeColumn(1);
    }

    private void createSummarySheet(List<String> ll) {
        if (this.rowNumberForReport > this.maxRowsForExcelReport) {
            ll.add("Too many lines in Excel. Report truncated. See CSV reports the rest of the days");
        }
        SXSSFSheet excelSummarySheet = this.excelReport.createSheet("Summary");
        int summaryRowNumber = 0;
        for (String s : ll) {
            this.createCell((Row)excelSummarySheet.createRow(summaryRowNumber++), 0, s);
        }
        excelSummarySheet.trackAllColumnsForAutoSizing();
        excelSummarySheet.autoSizeColumn(0);
    }

    private void createCell(Row row, int cellNumber, String cellValue) {
        row.createCell(cellNumber).setCellValue(cellValue == null ? "" : cellValue);
    }
}

