/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation;

import com.bmc.cnvvalidation.CommonJobFH;
import com.bmc.cnvvalidation.CommonRepository;
import com.bmc.cnvvalidation.CommonRepositoryReader;
import com.bmc.cnvvalidation.CompareReports;
import com.bmc.cnvvalidation.ExcludeFile;
import com.bmc.cnvvalidation.ExternalParameters;
import com.bmc.cnvvalidation.ExternalSort;
import com.bmc.cnvvalidation.LegacyReportLoader;
import com.bmc.cnvvalidation.LoadExecutionHistoryReport;
import com.bmc.cnvvalidation.LoadForecastReport;
import com.bmc.cnvvalidation.LoadReport;
import com.bmc.cnvvalidation.MessageCollector;
import com.bmc.cnvvalidation.report.CsvReport;
import com.bmc.cnvvalidation.report.ExcelReport;
import com.bmc.cnvvalidation.report.ReportWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.time.StopWatch;

public class RunCompare {
    private boolean verificationCompletedOk = false;

    public void run(ExternalParameters externalParameters, MessageCollector messages) {
        LoadReport legacyReport;
        ExcludeFile excludeFile = new ExcludeFile(externalParameters.getExcludeJobsFile());
        String runDate = "";
        List<String> llt = new ArrayList<String>();
        String legacyRepositoryFileName = null;
        ExcelReport excelReport = null;
        String reportName = null;
        externalParameters.setOutputReportFullName("");
        ArrayList<LoadReport> legacyReports = new ArrayList<LoadReport>();
        StopWatch timer = new StopWatch();
        timer.start();
        String typeOfCompare = externalParameters.getTypeOfCompare();
        LegacyReportLoader legacyReportLoader = new LegacyReportLoader(externalParameters, messages, typeOfCompare);
        Object typeOfLegcy = "";
        String type = externalParameters.getTypeOfLegcy();
        if (this.legacySchedulerTypeSelected(type) && (legacyReport = legacyReportLoader.get(type, externalParameters.getLegacyForecastReport())) != null) {
            legacyReports.add(legacyReport);
            typeOfLegcy = type;
        }
        if (this.legacySchedulerTypeSelected(type = externalParameters.getTypeOfLegcy2()) && (legacyReport = legacyReportLoader.get(type, externalParameters.getLegacyForecastReport2())) != null) {
            legacyReports.add(legacyReport);
            typeOfLegcy = (String)typeOfLegcy + "-" + type;
        }
        if (legacyReports.isEmpty()) {
            return;
        }
        String lastRunDate = null;
        try {
            do {
                CommonRepository cRepository = null;
                for (LoadReport lrLeg : legacyReports) {
                    CommonJobFH job;
                    runDate = lrLeg.getNextReportDate();
                    if (runDate == null) {
                        if (lastRunDate != null) break;
                        messages.add("The report contains no data or the date format is incorrect.");
                        break;
                    }
                    if (cRepository == null) {
                        legacyRepositoryFileName = "workarea\\" + (String)typeOfLegcy + "-" + typeOfCompare + "-" + runDate + ".csv";
                        FileOutputStream outputStream = new FileOutputStream(legacyRepositoryFileName);
                        cRepository = new CommonRepository(outputStream);
                    }
                    while ((job = lrLeg.nextJob()) != null) {
                        cRepository.insert(job);
                    }
                }
                if (cRepository != null) {
                    cRepository.term();
                }
                if (runDate == null || runDate.isEmpty()) continue;
                String controlmRepositoryFileName = this.loadReport(externalParameters, runDate, messages);
                if (controlmRepositoryFileName == null) {
                    messages.add("Unable to produce Control-M information for " + runDate);
                    continue;
                }
                messages.add(" ");
                messages.add(" Running compare for " + runDate);
                lastRunDate = runDate;
                String legacySortedRepositoryFileName = legacyRepositoryFileName + "-sorted";
                String controlmSortedRepositoryFileName = controlmRepositoryFileName + "-sorted";
                int totalLegCounter = new ExternalSort(legacyRepositoryFileName, legacySortedRepositoryFileName, excludeFile).externalSort();
                int totalCtmCounter = new ExternalSort(controlmRepositoryFileName, controlmSortedRepositoryFileName, excludeFile).externalSort();
                if (totalCtmCounter == 0) {
                    messages.add("No " + externalParameters.getForecastCompareLevel() + " in Control-M for date " + runDate + ", no report file will be created");
                }
                if (totalCtmCounter < 0) {
                    messages.add("Failed to sort the " + externalParameters.getForecastCompareLevel() + " from Control-M for date " + runDate);
                }
                if (totalLegCounter == 0) {
                    messages.add("No jobs in input report");
                }
                if (totalLegCounter < 0) {
                    messages.add("Failed to sort the jobs from " + (String)typeOfLegcy + " for date " + runDate);
                }
                messages.add("  Number of total " + externalParameters.getForecastCompareLevel() + " in Control-M: " + totalCtmCounter);
                messages.add("  Number of total " + externalParameters.getForecastCompareLevel() + " in " + (String)typeOfLegcy + ": " + totalLegCounter);
                if (totalCtmCounter <= 0 || totalLegCounter <= 0) continue;
                if (excelReport == null) {
                    reportName = this.createReportName(runDate, typeOfCompare, (String)typeOfLegcy);
                    excelReport = this.createExcelReport(externalParameters, runDate, reportName, legacyReports, typeOfCompare, (String)typeOfLegcy);
                }
                String csvReportName = this.createReportName(runDate, externalParameters.getTypeOfCompare(), externalParameters.getTypeOfLegcy());
                String targetReport = externalParameters.getOutputReportDirectory();
                try (FileInputStream legacySortedRepositoryInputStream = new FileInputStream(legacySortedRepositoryFileName);
                     FileInputStream controlmSortedRepositoryInputStream = new FileInputStream(controlmSortedRepositoryFileName);
                     CsvReport csvReport = new CsvReport(targetReport + csvReportName + ".csv").startReport();){
                    csvReport.writeLine(ReportWriter.createReportHeaders());
                    CommonRepositoryReader legacySortedRepository = new CommonRepositoryReader(legacySortedRepositoryInputStream, excludeFile);
                    CommonRepositoryReader controlmSortedRepository = new CommonRepositoryReader(controlmSortedRepositoryInputStream, excludeFile);
                    ReportWriter reportWriter = new ReportWriter(csvReport, excelReport);
                    CompareReports compareReports = new CompareReports(legacySortedRepository, controlmSortedRepository, externalParameters, reportWriter);
                    llt = compareReports.compareSortedCtmLeg();
                }
                catch (IOException e) {
                    messages.add(e.getMessage());
                    llt.add("Error during Compare process while reading the files or writing the reports");
                }
                catch (Exception e) {
                    messages.add(e.getMessage());
                    messages.add(e.getStackTrace().toString());
                    llt.add("Error during Compare");
                }
                messages.addAll(llt);
            } while (runDate != null);
            if (excelReport != null) {
                if (!legacyReports.isEmpty() && ((LoadReport)legacyReports.get(0)).getNumOfDates() > 1) {
                    String fullReportName = externalParameters.getOutputReportDirectory() + reportName + "-" + lastRunDate + ".xlsx";
                    excelReport.setNewName(fullReportName);
                    externalParameters.setOutputReportFullName(fullReportName);
                }
                excelReport.termReport(messages.getAll());
                timer.stop();
                messages.add("Compared in " + timer.toSplitString());
                messages.add("Detailed report can be found in " + externalParameters.getOutputReportFullName());
                this.setVerificationCompletedOk();
            }
        }
        catch (IOException e1) {
            messages.add(e1.getMessage());
            messages.add("Error extracting date from the input report - probably wrong file 4");
        }
        catch (ParseException e1) {
            messages.add(e1.getMessage());
            messages.add("Error extracting date from the input report - probably wrong date format");
        }
        catch (Exception e1) {
            messages.add(e1.getMessage());
            messages.add("General error");
        }
    }

    private ExcelReport createExcelReport(ExternalParameters externalParameters, String runDate, String reportName, List<LoadReport> legacyReports, String typeOfCompare, String typeOfLegcy) throws IOException {
        String fullReportName = externalParameters.getOutputReportDirectory() + reportName + ".xlsx";
        externalParameters.setOutputReportFullName(fullReportName);
        ExcelReport excelReport = new ExcelReport(fullReportName, externalParameters);
        String reportSheetName = this.createReportSheetName(runDate, legacyReports, typeOfCompare, typeOfLegcy);
        excelReport.startReport(reportSheetName);
        return excelReport;
    }

    private String createReportName(String runDate, String typeOfCompare, String typeOfLegcy) {
        return File.separator + "report-" + typeOfLegcy + "-" + typeOfCompare + "-" + runDate;
    }

    private boolean legacySchedulerTypeSelected(String typeOfLegcy1) {
        return !typeOfLegcy1.isEmpty() && !typeOfLegcy1.equals("Select");
    }

    private String loadReport(ExternalParameters externalParameters, String runDate, MessageCollector messages) {
        try {
            String type = externalParameters.getTypeOfCompare();
            if ("Forecast".equals(type) || "Execution-to-Forecast".equals(type)) {
                return this.loadControlMReport(type, runDate, messages, new LoadForecastReport(runDate, externalParameters));
            }
            if ("Execution".equals(type)) {
                return this.loadControlMReport(type, runDate, messages, new LoadExecutionHistoryReport(runDate, externalParameters));
            }
        }
        catch (IOException | IllegalArgumentException | InterruptedException e) {
            messages.add(e.getMessage());
        }
        return null;
    }

    private String createReportSheetName(String runDate, List<LoadReport> legacyReports, String typeOfCompare, String typeOfLegcy) {
        Object reportTitle;
        if (!legacyReports.isEmpty() && legacyReports.get(0).getNumOfDates() > 1) {
            reportTitle = typeOfLegcy + "-" + typeOfCompare;
            if (((String)reportTitle).length() > 31 && typeOfCompare.equals("Execution-to-Forecast")) {
                reportTitle = typeOfLegcy + "-Exec2Fore";
            }
        } else {
            reportTitle = typeOfLegcy + "-" + typeOfCompare + "-" + runDate;
            if (((String)reportTitle).length() > 31 && typeOfCompare.equals("Execution-to-Forecast")) {
                reportTitle = typeOfLegcy + "-Exec2Fore-" + runDate;
            }
        }
        if (((String)reportTitle).length() > 31) {
            reportTitle = ((String)reportTitle).substring(0, 30);
        }
        return reportTitle;
    }

    private String loadControlMReport(String typeOfCompare, String runDate, MessageCollector ll, LoadReport loadReportCtm) {
        if (runDate != null && !runDate.isEmpty() && loadReportCtm != null) {
            String repositoryFileName = "workarea\\Control-M-" + typeOfCompare + "-" + runDate + ".csv";
            try {
                CommonJobFH job;
                CommonRepository cRepository = new CommonRepository(new FileOutputStream(repositoryFileName));
                while ((job = loadReportCtm.nextJob()) != null) {
                    cRepository.insert(job);
                }
                cRepository.term();
                return repositoryFileName;
            }
            catch (FileNotFoundException | ParseException e) {
                ll.add(e.getMessage());
            }
        }
        return null;
    }

    public boolean isVerificationCompletedOk() {
        return this.verificationCompletedOk;
    }

    private void setVerificationCompletedOk() {
        this.verificationCompletedOk = true;
    }
}

