/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation;

import arrow.core.Either;
import com.bmc.cnvvalidation.ExternalParameters;
import com.bmc.ctmconvert.AAPIClient;
import com.bmc.ctmconvert.AAPIClientBuilder;
import com.bmc.ctmconvert.AAPIClientPrinterDecorator;
import com.bmc.ctmconvert.ApiFailure;
import com.bmc.ctmconvert.CommonLogger;
import com.bmc.ctmconvert.ConsolePrinter;
import com.bmc.ctmconvert.NullLogger;
import com.bmc.ctmconvert.Printer;
import io.swagger.client.ApiClient;
import io.swagger.client.model.InputStreamResource;
import io.swagger.client.model.LoginResult;
import io.swagger.client.model.ReportResult;
import io.swagger.client.model.RunReport;
import io.swagger.client.model.RunReportInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleDescriptor;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class ReportingClient {
    public static final int TIMEOUT = 3;
    public static final int NUMBER_OF_RETRIES = 10;
    private final ExternalParameters parameters;
    private final long timeout;
    private final int numberOfRetries;

    public ReportingClient(ExternalParameters parameters) {
        this(parameters, 3L, 10);
    }

    public ReportingClient(ExternalParameters parameters, long timeout, int numberOfRetries) {
        this.parameters = parameters;
        this.timeout = timeout;
        this.numberOfRetries = numberOfRetries;
    }

    public void downloadReportTo(String downloadPath) {
        AAPIClient client = new AAPIClientBuilder((CommonLogger)NullLogger.INSTANCE, (Printer)ConsolePrinter.INSTANCE, (aapi, it) -> new AAPIClientPrinterDecorator(aapi, it, (CommonLogger)NullLogger.INSTANCE)).forServer(this.parameters.getAAPIEndpoint(), null, new ApiClient());
        LoginResult login = (LoginResult)this.getOrThrow(client.login(this.parameters.getEmUser(), this.parameters.getEmPass()), "Unable to login to Control-M");
        if (this.isVersionLessThen921(login)) {
            ReportResult reportResult = (ReportResult)this.getOrThrow(client.getReport(this.parameters.getAutomationAPIVerificationReportName(), "CSV"), "Verify that the %s report template has been loaded and saved in Control-M Reports".formatted(this.parameters.getAutomationAPIVerificationReportName()));
            this.saveReport(reportResult, downloadPath);
        } else {
            this.downloadReportVersion921(downloadPath, client);
        }
    }

    private void downloadReportVersion921(String downloadPath, AAPIClient client) {
        RunReport runReport = new RunReport();
        runReport.setName(this.parameters.getAutomationAPIVerificationReportName());
        runReport.setFormat("CSV");
        RunReportInfo runReportResult = (RunReportInfo)this.getOrThrow(client.runReport(runReport), "Verify that the %s report template has been loaded and saved in Control-M Reports".formatted(this.parameters.getAutomationAPIVerificationReportName()));
        boolean isReady = this.retry(() -> client.getReportStatus(runReportResult.getReportId()), this::isReady, this.numberOfRetries);
        if (isReady) {
            InputStreamResource result = (InputStreamResource)this.getOrThrow(client.downloadReportById(runReportResult.getReportId()), "Unable to download report");
            try {
                Files.copy((InputStream)InputStream.class.cast(result.getInputStream()), new File(downloadPath).toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            throw new IllegalArgumentException("Unable to download report");
        }
    }

    private boolean isReady(Either<ApiFailure, RunReportInfo> reportStatusResult) {
        return reportStatusResult.orNone().filter(x -> x.getStatus().equals("SUCCEEDED")).isNotEmpty();
    }

    private <T> boolean retry(Supplier<T> action, Predicate<T> isReady, int numberOfRetries) {
        T result = action.get();
        if (isReady.test(result)) {
            return true;
        }
        if (numberOfRetries > 0) {
            this.sleep();
            return this.retry(action, isReady, numberOfRetries - 1);
        }
        return false;
    }

    private void sleep() {
        try {
            TimeUnit.SECONDS.sleep(this.timeout);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private boolean isVersionLessThen921(LoginResult login) {
        return ModuleDescriptor.Version.parse(login.getVersion()).compareTo(ModuleDescriptor.Version.parse("9.21.0")) < 0;
    }

    private void saveReport(ReportResult reportResult, String downloadPath) {
        try (FileOutputStream targetStream = new FileOutputStream(downloadPath);
             ReadableByteChannel source = this.getReportFrom(reportResult);){
            targetStream.getChannel().transferFrom(source, 0L, Long.MAX_VALUE);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to download report from Control-M:\n " + e.getMessage());
        }
    }

    private ReadableByteChannel getReportFrom(ReportResult reportResult) throws GeneralSecurityException, IOException {
        HttpsURLConnection.setDefaultSSLSocketFactory(this.createTrustAllCertificatesSSLContext().getSocketFactory());
        return Channels.newChannel(new URL(reportResult.getReportURL()).openStream());
    }

    private <T> T getOrThrow(Either<ApiFailure, T> apiResult, String message) {
        if (apiResult.isLeft()) {
            throw new IllegalArgumentException(Optional.ofNullable((String)apiResult.swap().orNone().map(apiFailure -> this.appendMessageToFailureMessage(apiFailure.getMessage(), message)).orNull()).orElse("Unknown Error"));
        }
        return (T)apiResult.orNull();
    }

    private String appendMessageToFailureMessage(String apiFailureMessage, String message) {
        if (message.isEmpty()) {
            return apiFailureMessage;
        }
        return apiFailureMessage + "\n" + message;
    }

    private SSLContext createTrustAllCertificatesSSLContext() throws GeneralSecurityException {
        X509TrustManager trustAllCertificates = new X509TrustManager(this){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, new TrustManager[]{trustAllCertificates}, new SecureRandom());
        return sslContext;
    }
}

