/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.TreeMap;

public class MappingFileHandler {
    private TreeMap<String, String> jobNames;
    private TreeMap<String, String> jobCtmToLegacyNames;
    private final String mapFile;

    public MappingFileHandler(String mapFile) throws IOException {
        this.mapFile = mapFile;
        this.loadMapJobNames();
        this.loadMapCtmToLegacyJobNames();
    }

    private void loadMapJobNames() throws IOException {
        this.jobNames = new TreeMap();
        if (this.mappingFileIsNotEmpty()) {
            try (FileReader frm = new FileReader(this.mapFile);
                 BufferedReader brm = new BufferedReader(frm);){
                String mapRecord;
                while ((mapRecord = brm.readLine()) != null) {
                    if (!this.isNotHeaderLine(mapRecord)) continue;
                    String[] fields = mapRecord.split(",");
                    this.jobNames.put(fields[1], fields[2]);
                }
            }
        }
    }

    private void loadMapCtmToLegacyJobNames() throws IOException {
        this.jobCtmToLegacyNames = new TreeMap();
        if (this.mappingFileIsNotEmpty()) {
            try (FileReader frm = new FileReader(this.mapFile);
                 BufferedReader brm = new BufferedReader(frm);){
                String mapRecord;
                while ((mapRecord = brm.readLine()) != null) {
                    if (!this.isNotHeaderLine(mapRecord)) continue;
                    String[] fields = mapRecord.split(",");
                    this.jobCtmToLegacyNames.put(fields[2], fields[1]);
                }
            }
        }
    }

    private boolean isNotHeaderLine(String sMapRec) {
        return !sMapRec.contains("Mapping Index") || !sMapRec.contains("Original jobname") || !sMapRec.contains("Control-M Jobname") || !sMapRec.contains("Application");
    }

    public String getMapValue(String job) {
        if (this.mappingFileIsNotEmpty()) {
            return this.jobNames.getOrDefault(job, job);
        }
        return job;
    }

    public String getCtmToLegacyMapValue(String ctmJob) {
        if (this.mappingFileIsNotEmpty()) {
            return this.jobCtmToLegacyNames.getOrDefault(ctmJob, ctmJob);
        }
        return ctmJob;
    }

    private boolean mappingFileIsNotEmpty() {
        return this.mapFile != null && !this.mapFile.isBlank() && !this.mapFile.isEmpty();
    }
}

