/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation;

import com.bmc.cnvvalidation.CommonJobFH;
import com.bmc.cnvvalidation.ExternalParameters;
import com.bmc.cnvvalidation.LegacyReportInputStreamSuplier;
import com.bmc.cnvvalidation.LoadReport;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LoadZenaForecastReport
extends LoadReport {
    public static final String REGEX_WHITESPACE_TO_DOT = "\\s([^\\.]+)\\.";
    public static final String REGEX_ALL = ".*";
    public static final int START_RUN_DATE_INDEX = 12;
    public static final int JOB_NAME_INDEX = 5;
    public static final int END_RUN_DATE_INDEX = 13;
    public static final int REGEX_GROUP_WITHOUT_DOT = 1;
    public static final int REGEX_GROUP_FIRST = 0;
    public static final int ALLOWED_LINE_LENGTH = 25;
    private String nextLine;

    public LoadZenaForecastReport(LegacyReportInputStreamSuplier legacyForecastReport, ExternalParameters externalParameters) {
        super(legacyForecastReport, externalParameters);
    }

    @Override
    protected CommonJobFH nextJobInternal() throws IOException, ParseException {
        String jobName = "";
        String internalRunDate = "";
        while ((this.nextLine = this.getNextLineFromStream()) != null) {
            if (this.lineLengthTooLong()) continue;
            jobName = this.getJobNameFromLine();
            internalRunDate = this.getRunDate();
            if (!this.willJobRunInDateWithNewDay(this.getDate(internalRunDate), this.getTime(internalRunDate))) continue;
            String startRun = this.getStartRunFromLine();
            return new CommonJobFH(FieldValidation.instance().validateAndReturnFixedValue("JOBNAME", jobName.replaceAll(" ", "_")), "", "", "", "", "", startRun, this.getEndRunFromLine(), internalRunDate, "", jobName, "ASG-Zena", "", "");
        }
        return null;
    }

    private String getTime(String internalRunDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy");
        SimpleDateFormat targetFormat = new SimpleDateFormat("HHmm");
        try {
            Date date = formatter.parse(internalRunDate);
            return targetFormat.format(date);
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private String getDate(String internalRunDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy");
        SimpleDateFormat targetFormat = new SimpleDateFormat("yyyyMMdd");
        try {
            Date date = formatter.parse(internalRunDate);
            return targetFormat.format(date);
        }
        catch (ParseException e) {
            System.out.println(internalRunDate);
            throw new RuntimeException(e.getMessage());
        }
    }

    private boolean lineLengthTooLong() {
        return this.nextLine.split(",").length != 25;
    }

    private String getRunDate() {
        return this.getDateFromFullDateString(this.getSubStringFromLine(12));
    }

    private String getDateFromFullDateString(String subStringFromLine) {
        String fullDate = this.getSubString(subStringFromLine, REGEX_ALL, 0);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        try {
            return formatter.parse(fullDate).toString();
        }
        catch (ParseException e) {
            return "Date_parsing_error";
        }
    }

    private String getSubString(String string, String pattern, int i) {
        Matcher matcher = Pattern.compile(pattern).matcher(string);
        if (matcher.find()) {
            return matcher.group(i);
        }
        return "";
    }

    private String getJobNameFromLine() {
        return this.getSubStringFromLine(5);
    }

    private String getSubStringFromLine(int columnIndex) {
        try {
            return this.nextLine.split(",")[columnIndex];
        }
        catch (IndexOutOfBoundsException e) {
            return "MISSING_COLUMN_NUMBER_" + columnIndex;
        }
    }

    private String getStartRunFromLine() {
        return this.getTimeFromFullDateString(this.getSubStringFromLine(12));
    }

    private String getTimeFromFullDateString(String subStringFromLine) {
        return this.getSubString(subStringFromLine, REGEX_WHITESPACE_TO_DOT, 1);
    }

    private String getEndRunFromLine() {
        return this.getTimeFromFullDateString(this.getSubStringFromLine(13));
    }

    private String getNextLineFromStream() throws IOException {
        return this.br.readLine();
    }
}

