/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation;

import com.bmc.cnvvalidation.CommonJobFH;
import com.bmc.cnvvalidation.ExternalParameters;
import com.bmc.cnvvalidation.LegacyReportInputStreamSuplier;
import com.bmc.cnvvalidation.LoadReport;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;

public class LoadZekeForecastReport
extends LoadReport {
    private String folder = null;
    private String sZekeReportRec;
    private String[][] rep = new String[][]{{"0", "@"}, {"1", "A"}, {"2", "B"}, {"3", "C"}, {"4", "D"}, {"5", "E"}, {"6", "F"}, {"7", "G"}, {"8", "H"}, {"9", "I"}};
    private CommonJobFH job = null;
    private CommonJobFH firstInCycleJob = null;
    private int indexOfOccurs = 96;
    private LinkedList<CommonJobFH> arrl = new LinkedList();
    private Iterator<CommonJobFH> itr = this.arrl.iterator();

    public LoadZekeForecastReport(LegacyReportInputStreamSuplier legacyForecastReport1, ExternalParameters externalParameters) {
        super(legacyForecastReport1, externalParameters);
        String mGroupBy = externalParameters.getZekeGroupBy();
        if (!(mGroupBy.equals("APP") || mGroupBy.equals("APPGRP") || mGroupBy.equals("EVT") || mGroupBy.equals("JOB") || mGroupBy.equals("USERID"))) {
            throw new IllegalArgumentException("Invalid GROUPBY.");
        }
    }

    @Override
    protected CommonJobFH nextJobInternal() throws FileNotFoundException, IOException, ParseException {
        if (this.itr.hasNext()) {
            this.job = this.arrl.remove();
            return this.job;
        }
        String mGroupBy = this.externalParameters.getZekeGroupBy();
        while ((this.sZekeReportRec = this.br.readLine()) != null) {
            if (this.sZekeReportRec.contains("JOBS ADDED TO SCHEDULE BY SCHEDULE FUNCTION")) {
                this.reportStarted = true;
            }
            if (this.reportStarted & this.sZekeReportRec.contains("NUMBER OF EVENTS REPORTED")) {
                return null;
            }
            if (this.sZekeReportRec.contains("EVENT  VERSN EARLY")) {
                this.indexOfOccurs = this.sZekeReportRec.indexOf("OCCURS");
            }
            if (this.sZekeReportRec.startsWith("1ZEKE") | this.sZekeReportRec.contains("JOBS ADDED TO SCHEDULE BY SCHEDULE FUNCTION") | this.sZekeReportRec.contains("EVENT  VERSN EARLY") | this.sZekeReportRec.contains("NUMBER       TIME  TIME") || !this.reportStarted) continue;
            Object startTime = this.sZekeReportRec.substring(21, 26);
            if (((String)startTime).startsWith("24")) {
                startTime = "00" + this.sZekeReportRec.substring(23, 26);
            }
            Date dateStart = this.dateFormatter.timeFormatNoSec.parse((String)startTime);
            Date timeInterval = !this.sZekeReportRec.substring(this.indexOfOccurs + 10, this.indexOfOccurs + 18).equals("        ") ? this.dateFormatter.timeFormatWithSec.parse(this.sZekeReportRec.substring(this.indexOfOccurs + 10, this.indexOfOccurs + 18)) : this.dateFormatter.timeFormatWithSec.parse("00:00:00");
            Date timeCycle = !this.sZekeReportRec.substring(84, 89).trim().equals("-") ? this.dateFormatter.timeFormatNoSec.parse(this.sZekeReportRec.substring(84, 89)) : this.dateFormatter.timeFormatNoSec.parse("00:00");
            long ednRun = dateStart.getTime() + timeInterval.getTime();
            long nextRun = dateStart.getTime();
            String startRun = this.dateFormatter.timeFormatWithSec.format(new Date(nextRun));
            String startDateC = this.dateFormatter.dateFormatyyyyMMdd.format(new Date(nextRun));
            if (!this.willJobRunInDateWithNewDay(this.dateFormatter.dateFormatyyyyMMdd.format(this.dateFormatter.dateFormatMMddyyyy.parse(this.sZekeReportRec.substring(this.indexOfOccurs - 2, this.indexOfOccurs + 10))), startRun.substring(0, 2) + startRun.substring(3, 5))) continue;
            switch (mGroupBy) {
                case "APP": {
                    this.folder = this.sZekeReportRec.substring(39, 47).trim();
                    break;
                }
                case "APPGRP": {
                    this.folder = this.sZekeReportRec.substring(39, 44);
                    this.folder = this.folder.replaceAll(" ", "@") + this.sZekeReportRec.substring(48, 51).trim();
                    break;
                }
                case "EVT": {
                    this.folder = this.sZekeReportRec.substring(62, 74).trim();
                    break;
                }
                case "JOB": {
                    this.folder = !this.sZekeReportRec.substring(75, 83).equals("        ") ? this.sZekeReportRec.substring(75, 83).trim() : this.sZekeReportRec.substring(62, 74).trim();
                    break;
                }
                case "USERID": {
                    this.folder = this.sZekeReportRec.substring(53, 61).trim();
                }
            }
            if (mGroupBy != "APPGRP" & this.folder.length() == 0) {
                this.folder = "@";
            }
            for (int i = 0; i <= 9; ++i) {
                if (!this.folder.startsWith(this.rep[i][0])) continue;
                this.folder = this.rep[i][1] + this.folder.substring(1);
                break;
            }
            Integer j = Integer.valueOf(this.sZekeReportRec.substring(90, this.indexOfOccurs - 2).trim());
            for (int i = 1; i <= j; ++i) {
                this.job = new CommonJobFH(!this.sZekeReportRec.substring(75, 83).equals("        ") ? this.sZekeReportRec.substring(75, 83).trim() : this.sZekeReportRec.substring(62, 74).trim(), "", "", this.folder.length() > this.externalParameters.getZekeJobLen() ? this.folder.substring(0, this.externalParameters.getZekeJobLen()) : this.folder, "", "", startRun, this.dateFormatter.timeFormatWithSec.format(new Date(ednRun)), this.runDate, this.date.toString(), "", "ASG-Zeke", "", "");
                if (i == 1) {
                    this.firstInCycleJob = this.job;
                } else {
                    this.arrl.add(this.job);
                }
                if (j <= 1) continue;
                startRun = this.dateFormatter.timeFormatWithSec.format(new Date(nextRun += timeCycle.getTime()));
                ednRun = nextRun + timeInterval.getTime();
                if (!this.dateFormatter.dateFormatyyyyMMdd.format(new Date(nextRun)).equals(startDateC)) break;
            }
            return this.firstInCycleJob;
        }
        return null;
    }
}

