/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation;

import com.bmc.cnvvalidation.CommonJobFH;
import com.bmc.cnvvalidation.ExternalParameters;
import com.bmc.cnvvalidation.LegacyReportInputStreamSuplier;
import com.bmc.cnvvalidation.LoadReport;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.TreeMap;

public class LoadTWSMFForecastReport
extends LoadReport {
    static final String inputPattern6 = "|";
    static final String inputPattern7 = " ---------";
    static final String inputPattern8 = "          ";
    static final String inputPattern1 = " APPL ID/OP ID";
    static final String inputPattern3 = " INPUT ARRIVAL";
    static final String inputPattern2 = " END OF LONG TERM PLAN PRINTOUT";
    private String folder = "";
    private TreeMap<String, String> tmMapApplNames = null;

    public LoadTWSMFForecastReport(LegacyReportInputStreamSuplier legacyForecastReport, ExternalParameters externalParameters) throws IOException {
        super(legacyForecastReport, externalParameters);
        this.loadMap();
    }

    @Override
    protected CommonJobFH nextJobInternal() throws IOException, ParseException {
        String sTWSMFReportRec;
        while ((sTWSMFReportRec = this.br.readLine()) != null) {
            if (sTWSMFReportRec.contains(inputPattern1)) {
                this.reportStarted = true;
            }
            if (this.reportStarted & sTWSMFReportRec.contains(inputPattern2)) {
                return null;
            }
            if (!sTWSMFReportRec.contains(inputPattern6) | sTWSMFReportRec.startsWith(inputPattern7) | sTWSMFReportRec.startsWith(inputPattern8) | sTWSMFReportRec.startsWith(inputPattern3) | sTWSMFReportRec.startsWith(inputPattern1) | sTWSMFReportRec.length() < 16 || !this.reportStarted) continue;
            if (!sTWSMFReportRec.substring(1, 9).matches("^\\d{2}/\\d{2}/\\d{2}$")) {
                this.folder = sTWSMFReportRec.substring(1, 17);
                continue;
            }
            String runTWSMFTime = sTWSMFReportRec.substring(10, 15);
            String runTWSMFDeadlineTime = sTWSMFReportRec.substring(33, 38);
            if (!this.willJobRunInDate(this.dateFormatter.dateFormatyyyyMMdd.format(this.dateFormatter.dateFormatMMddyy.parse(sTWSMFReportRec.substring(1, 9))), sTWSMFReportRec.substring(1, 9))) continue;
            String oldAppl = this.folder;
            if (this.tmMapApplNames.containsKey(this.folder)) {
                this.folder = this.tmMapApplNames.get(this.folder);
            }
            return new CommonJobFH(this.folder, "", "", this.folder, "", "", runTWSMFTime.substring(0, 2) + ":" + runTWSMFTime.substring(3, 5) + ":00", runTWSMFDeadlineTime.substring(0, 2) + ":" + runTWSMFDeadlineTime.substring(3, 5) + ":00", this.runDate, this.date.toString(), oldAppl, "IBM-TWS-MF", "", "");
        }
        return null;
    }

    private void loadMap() throws IOException {
        this.tmMapApplNames = new TreeMap();
        String mapFile = this.externalParameters.getJobnameMappingFile();
        if (!mapFile.equals("")) {
            FileReader frm = new FileReader(mapFile);
            try (BufferedReader brm = new BufferedReader(frm);){
                String sMapRec;
                while ((sMapRec = brm.readLine()) != null) {
                    String oldAppl = sMapRec.substring(0, 16);
                    String newAppl = sMapRec.substring(17, 26);
                    this.tmMapApplNames.put(oldAppl, newAppl);
                }
            }
        }
    }
}

