/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation;

import com.bmc.cnvvalidation.CommonJobFH;
import com.bmc.cnvvalidation.ExternalParameters;
import com.bmc.cnvvalidation.LegacyReportInputStreamSuplier;
import com.bmc.cnvvalidation.LoadReport;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class LoadTWSExecutionReport
extends LoadReport {
    private String sTWSReportRec;
    private String startRun = null;
    String[] listOfFields = null;
    private String currentJob;
    private Boolean correctReport = false;

    public LoadTWSExecutionReport(LegacyReportInputStreamSuplier legacyForecastReport, ExternalParameters externalParameters) {
        super(legacyForecastReport, externalParameters);
    }

    @Override
    protected CommonJobFH nextJobInternal() throws FileNotFoundException, IOException, ParseException {
        while ((this.sTWSReportRec = this.br.readLine()) != null) {
            if (this.sTWSReportRec.length() < 10) continue;
            if (this.sTWSReportRec.contains("Report 07")) {
                this.correctReport = true;
            }
            if (this.sTWSReportRec.contains("Licensed Materials - Property of IBM(R)") | this.sTWSReportRec.contains("5698-WSH") | this.sTWSReportRec.contains("(C) Copyright IBM Corp") | this.sTWSReportRec.contains("US Government User Restricted") | this.sTWSReportRec.contains("Use, duplication or disclosure") | this.sTWSReportRec.contains("IBM is a registered trademark") | this.sTWSReportRec.contains("Corporation in the United") | this.sTWSReportRec.contains("Tivoli Workload Scheduler") | this.sTWSReportRec.contains("Report 07") | this.sTWSReportRec.contains("Date        Time      Job Stream Name") | this.sTWSReportRec.contains("* * * *   E n d  o f  R e p o r t  * * * *")) continue;
            if (!this.correctReport.booleanValue()) break;
            this.listOfFields = this.sTWSReportRec.split("\\s+");
            if (this.isValidDateyyyymmdd(this.listOfFields[0]) || this.isValidDateyymmdd(this.listOfFields[0])) {
                this.startRun = this.dateFormatter.timeFormatWithSec.format(this.dateFormatter.timeFormatNoSec.parse(this.listOfFields[1]));
                if (!this.willJobRunInDateWithNewDay(this.isValidDateyyyymmdd(this.listOfFields[0]) ? this.listOfFields[0] : this.dateFormatter.dateFormatyyyyMMdd.format(this.dateFormatter.dateFormatyyMMdd.parse(this.listOfFields[0])), this.startRun.substring(0, 2) + this.startRun.substring(3, 5))) continue;
            }
            if (this.listOfFields[0].startsWith("Job:")) {
                this.currentJob = this.sTWSReportRec.substring(4, 24).trim();
                continue;
            }
            CommonJobFH job = new CommonJobFH(this.currentJob, "", "", this.sTWSReportRec.substring(22, 45).trim(), "", "", this.startRun, "", this.runDate, this.date.toString(), "", "IBM-TWS-DS", "", "");
            return job;
        }
        return null;
    }

    public boolean isValidDateyyyymmdd(String dateString) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        try {
            df.parse(dateString);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public boolean isValidDateyymmdd(String dateString) {
        SimpleDateFormat df = new SimpleDateFormat("yy/MM/dd");
        try {
            df.parse(dateString);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }
}

