/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation;

import com.bmc.cnvvalidation.CommonJobFH;
import com.bmc.cnvvalidation.DateFormatter;
import com.bmc.cnvvalidation.ExternalParameters;
import com.bmc.cnvvalidation.LegacyReportInputStreamSuplier;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class LoadReport {
    protected String runDate = null;
    protected CommonJobFH job = null;
    private Map<String, String> dateList = new TreeMap<String, String>();
    protected BufferedReader br = null;
    protected Date date = null;
    protected boolean reportStarted = false;
    protected boolean dateHandled = false;
    protected LegacyReportInputStreamSuplier report;
    protected Set<String> dates = null;
    protected Iterator<String> iDate = null;
    protected String runDateReport = null;
    protected int numOfDates = 0;
    protected ExternalParameters externalParameters;
    protected final DateFormatter dateFormatter;

    protected LoadReport(LegacyReportInputStreamSuplier legacyForecastReport, ExternalParameters externalParameters) {
        this.externalParameters = externalParameters;
        this.dateFormatter = new DateFormatter();
        this.report = legacyForecastReport;
        this.initReport(legacyForecastReport);
    }

    protected void init(LegacyReportInputStreamSuplier legacyForecastReport) {
        this.initReport(legacyForecastReport);
    }

    private void initReport(LegacyReportInputStreamSuplier legacyForecastReport) {
        if (legacyForecastReport != null) {
            this.br = new BufferedReader(new InputStreamReader(legacyForecastReport.get()));
            this.newDate();
        }
    }

    protected LoadReport(ExternalParameters externalParameters) {
        this(null, externalParameters);
    }

    protected void newDate() {
        this.date = new Date();
    }

    protected void term() {
        try {
            if (this.br != null) {
                this.br.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getNextReportDate() throws ParseException {
        if (this.runDate == null) {
            this.dateList = new TreeMap<String, String>();
            try {
                while (this.nextJobInternal() != null) {
                }
            }
            catch (IOException e) {
                this.term();
            }
            this.dates = this.dateList.keySet();
            this.numOfDates = this.dateList.size();
            this.iDate = this.dates.iterator();
            if (!this.iDate.hasNext()) {
                return null;
            }
            this.runDate = this.iDate.next();
            this.runDateReport = this.dateList.get(this.runDate);
            this.dateHandled = true;
        } else if (this.iDate.hasNext()) {
            this.runDate = this.iDate.next();
            this.runDateReport = this.dateList.get(this.runDate);
        } else {
            return null;
        }
        this.term();
        this.init(this.report);
        this.reportStarted = false;
        return this.runDate;
    }

    public int getNumOfDates() {
        return this.numOfDates;
    }

    public boolean willJobRunInDate(String aRunDate, String aRunReportDate) {
        if (!this.dateHandled) {
            this.dateList.put(aRunDate, aRunReportDate);
            return false;
        }
        return this.runDateReport.equals(aRunReportDate);
    }

    public boolean willJobRunInDateWithNewDay(String aRunDate, String aRunTime) throws ParseException {
        String adjustedRunDate = this.adjustByNewdayTime(aRunDate, aRunTime);
        if (!this.dateHandled) {
            this.dateList.put(adjustedRunDate, adjustedRunDate);
            return false;
        }
        return this.runDate.equals(adjustedRunDate);
    }

    public String adjustByNewdayTime(String reportRunDate, String reportRunTime) throws ParseException {
        String newDayTime = this.externalParameters.getNewdayTime();
        Date formattedReportRunDate = this.dateFormatter.dateFormatyyyyMMdd.parse(reportRunDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(formattedReportRunDate);
        if (newDayTime.charAt(0) == '+' && Integer.parseInt(reportRunTime) < Integer.parseInt(newDayTime.substring(1, 5))) {
            cal.add(5, -1);
        } else if (newDayTime.charAt(0) == '-' && Integer.parseInt(reportRunTime) > 2400 - Integer.parseInt(newDayTime.substring(1, 5))) {
            cal.add(5, 1);
        }
        return this.dateFormatter.dateFormatyyyyMMdd.format(cal.getTime());
    }

    public CommonJobFH nextJob() throws ParseException {
        CommonJobFH retJob = this.job;
        if (retJob == null) {
            try {
                retJob = this.nextJobInternal();
            }
            catch (IOException e) {
                this.term();
            }
        }
        this.job = null;
        if (retJob == null) {
            this.term();
            return null;
        }
        return retJob;
    }

    protected abstract CommonJobFH nextJobInternal() throws IOException, ParseException;
}

