/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation;

import com.bmc.cnvvalidation.CommonJobFH;
import com.bmc.cnvvalidation.ExternalParameters;
import com.bmc.cnvvalidation.LegacyReportInputStreamSuplier;
import com.bmc.cnvvalidation.LoadReport;
import com.bmc.ctmconvert.common.GlobalFunctions;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;

public class LoadESPExecutionReport
extends LoadReport {
    private String folder = null;
    private String jobname = null;
    private String sESPXReportRec;
    private static final String INPUT_PATTERN_5 = "1ESP VER";
    private static final String INPUT_PATTERN_6 = "0                           ";
    private static final String INPUT_PATTERN_1 = "APPL    ";
    private static final String INPUT_PATTERN_3 = "CODE DATE";
    private static final String INPUT_PATTERN_2 = "SUBTOTAL (";
    private static final String INPUT_PATTERN_7 = "APPL     FULLNAME";
    private TreeMap<String, String> tmMapJobnms = null;
    private int reportJobnameOffset = 9;
    private int reportJobnameLength = 8;
    private int reportQualifierOffset = 18;
    private int reportStartRunOffset = 40;
    private int reportDateOffset = 30;

    public LoadESPExecutionReport(LegacyReportInputStreamSuplier legacyForecastReport, ExternalParameters externalParameters) throws IOException {
        super(legacyForecastReport, externalParameters);
        this.loadMap();
    }

    @Override
    protected CommonJobFH nextJobInternal() throws IOException, ParseException {
        while ((this.sESPXReportRec = this.br.readLine()) != null) {
            String reportDate;
            String reportDateRaw;
            this.sESPXReportRec = this.sESPXReportRec.replaceAll("^\\s", "");
            if (this.sESPXReportRec.startsWith(INPUT_PATTERN_1)) {
                this.reportStarted = true;
                if (this.sESPXReportRec.startsWith(INPUT_PATTERN_7)) {
                    this.reportJobnameOffset = 9;
                    this.reportJobnameLength = 44;
                    this.reportQualifierOffset = 55;
                    this.reportStartRunOffset = 109;
                    this.reportDateOffset = 67;
                }
            }
            if (this.reportStarted & this.sESPXReportRec.contains(INPUT_PATTERN_2)) {
                return null;
            }
            if (this.sESPXReportRec.startsWith(INPUT_PATTERN_5) | this.sESPXReportRec.startsWith(INPUT_PATTERN_6) | this.sESPXReportRec.startsWith(INPUT_PATTERN_1) | this.sESPXReportRec.contains(INPUT_PATTERN_3) | this.sESPXReportRec.length() < 22 || !this.reportStarted || (reportDateRaw = this.sESPXReportRec.substring(this.reportDateOffset, this.reportDateOffset + 8)).startsWith("   ")) continue;
            String monthString = reportDateRaw.substring(2, 5);
            if (monthString.chars().allMatch(Character::isDigit)) {
                reportDate = this.sESPXReportRec.substring(this.reportDateOffset, this.reportDateOffset + 8);
            } else {
                List<String> months = Arrays.asList("JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC");
                int monInNumIndex = months.indexOf(monthString);
                if (monInNumIndex < 0) {
                    return null;
                }
                reportDate = this.createDateInNewFormat(reportDateRaw, monInNumIndex + 1);
            }
            String startRun = this.sESPXReportRec.substring(this.reportStartRunOffset, this.reportStartRunOffset + 2) + ":" + this.sESPXReportRec.substring(this.reportStartRunOffset + 3, this.reportStartRunOffset + 5) + ":" + this.sESPXReportRec.substring(this.reportStartRunOffset + 6, this.reportStartRunOffset + 8);
            String reportTime = this.sESPXReportRec.substring(this.reportStartRunOffset, this.reportStartRunOffset + 2) + this.sESPXReportRec.substring(this.reportStartRunOffset + 3, this.reportStartRunOffset + 5);
            if (!this.willJobRunInDateWithNewDay(reportDate, reportTime)) continue;
            int reportFolderOffset = 0;
            String reportFolder = this.sESPXReportRec.substring(reportFolderOffset, reportFolderOffset + 8).trim();
            String reportJobName = this.sESPXReportRec.substring(this.reportJobnameOffset, this.reportJobnameOffset + this.reportJobnameLength).trim();
            String reportQualifier = this.sESPXReportRec.substring(this.reportQualifierOffset, this.reportQualifierOffset + 8).trim();
            if (this.tmMapJobnms.containsKey(reportJobName + "+" + reportFolder)) {
                String jobNameAndFolder = this.tmMapJobnms.get(reportJobName + "+" + reportFolder);
                String[] jaf = jobNameAndFolder.split("!");
                if (jaf.length > 0) {
                    this.jobname = jaf[0];
                }
                if (jaf.length > 1) {
                    this.folder = jaf[1];
                }
            } else {
                this.jobname = reportJobName;
                this.folder = reportFolder;
            }
            this.jobname = this.addQualifierToJobNameByWorkLoadObjectType(this.jobname, reportQualifier);
            return new CommonJobFH(this.jobname, "", "", this.folder, "", "", startRun, "", this.runDate, this.date.toString(), reportJobName, "CA-ESP", this.geVendorSpecific(), "");
        }
        return null;
    }

    private String addQualifierToJobNameByWorkLoadObjectType(String jobName, String qualifier) {
        Optional<String> wobType = this.getWobTypeFrom(this.sESPXReportRec);
        return wobType.filter(wt -> !wt.isBlank()).map(wt -> {
            String qualifierAndPrefix = Optional.ofNullable(qualifier).filter(q -> !q.isBlank()).map(q -> "." + q).orElse("");
            return jobName + qualifierAndPrefix;
        }).orElse(jobName);
    }

    private Optional<String> getWobTypeFrom(String sESPXReportRec) {
        int wobTypeBeginIndex = 90;
        int wobTypeEndIndex = 92;
        return GlobalFunctions.subStringOrEmpty((String)sESPXReportRec, (int)wobTypeBeginIndex, (int)wobTypeEndIndex);
    }

    private String geVendorSpecific() {
        if (this.sESPXReportRec.length() > 90) {
            return this.sESPXReportRec.substring(90).replaceAll(" +", "/");
        }
        return "";
    }

    private String createDateInNewFormat(String reportDateRaw, int monInNum) {
        String year = "20" + reportDateRaw.substring(5, 7);
        String month = String.format("%02d", monInNum);
        String day = reportDateRaw.substring(0, 2);
        return year + month + day;
    }

    private void loadMap() throws IOException {
        this.tmMapJobnms = new TreeMap();
        String mapFile = this.externalParameters.getJobnameMappingFile();
        if (!mapFile.equals("")) {
            FileReader frm = new FileReader(mapFile);
            try (BufferedReader brm = new BufferedReader(frm);){
                String sMapRec;
                while ((sMapRec = brm.readLine()) != null) {
                    String[] aMapRec = sMapRec.split(",");
                    if (aMapRec.length < 5) {
                        System.out.println("map rec: " + sMapRec);
                    }
                    this.tmMapJobnms.put(aMapRec[1] + "+" + aMapRec[2], aMapRec[3] + "!" + aMapRec[4]);
                }
            }
        }
    }
}

