/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation;

import com.bmc.cnvvalidation.CommonJobFH;
import com.bmc.cnvvalidation.ExternalParameters;
import com.bmc.cnvvalidation.LegacyReportInputStreamSuplier;
import com.bmc.cnvvalidation.LoadReport;
import com.bmc.cnvvalidation.MappingFileHandler;
import java.io.IOException;
import java.text.ParseException;

public class LoadDollarUniverseForecastReport
extends LoadReport {
    private Boolean correctReport = false;
    MappingFileHandler mappingFileHandler = null;

    public LoadDollarUniverseForecastReport(LegacyReportInputStreamSuplier legacyForecastReport, ExternalParameters externalParameters) {
        super(legacyForecastReport, externalParameters);
        try {
            String mappingFile = "";
            if (!externalParameters.getMapCtmToLegacy().equals("YES")) {
                mappingFile = externalParameters.getJobnameMappingFile();
            }
            this.mappingFileHandler = new MappingFileHandler(mappingFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected CommonJobFH nextJobInternal() throws IOException, ParseException {
        String sDollarUniverseReportRec;
        while ((sDollarUniverseReportRec = this.br.readLine()) != null) {
            if (sDollarUniverseReportRec.length() < 10) continue;
            if (sDollarUniverseReportRec.contains("TASK                                                             SESSION")) {
                this.correctReport = true;
            }
            if (sDollarUniverseReportRec.contains("Command :") | sDollarUniverseReportRec.contains("TASK                                                             SESSION") | sDollarUniverseReportRec.contains("-------------------")) continue;
            if (!this.correctReport.booleanValue()) break;
            if (sDollarUniverseReportRec.length() < 278) continue;
            String duTask = sDollarUniverseReportRec.substring(0, 64).trim();
            String startDate = this.parseStartDate(sDollarUniverseReportRec);
            if (!this.willJobRunInDateWithNewDay(startDate, this.parseStarTimeShort(sDollarUniverseReportRec))) continue;
            return new CommonJobFH(this.mappingFileHandler.getMapValue(duTask), "", "", this.mappingFileHandler.getMapValue(duTask), "", "", this.parseStarTime(sDollarUniverseReportRec), "", startDate, this.date.toString(), "", "Automic-Dollar-Universe", "", "");
        }
        return null;
    }

    private String parseStartDate(String reportRow) {
        String date = reportRow.substring(268, 278).trim();
        if (date.length() == 10) {
            char[] chars = new char[]{date.charAt(6), date.charAt(7), date.charAt(8), date.charAt(9), date.charAt(0), date.charAt(1), date.charAt(3), date.charAt(4)};
            return String.valueOf(chars);
        }
        return "0000000000";
    }

    private String parseStarTime(String reportRow) {
        String time = reportRow.substring(290, 296).trim();
        if (time.length() == 6) {
            char[] chars = new char[]{time.charAt(0), time.charAt(1), ':', time.charAt(2), time.charAt(3), ':', time.charAt(4), time.charAt(5)};
            return String.valueOf(chars);
        }
        return "00:00:00";
    }

    private String parseStarTimeShort(String reportRow) {
        String time = reportRow.substring(290, 296).trim();
        if (time.length() == 6) {
            char[] chars = new char[]{time.charAt(0), time.charAt(1), time.charAt(2), time.charAt(3)};
            return String.valueOf(chars);
        }
        return "0000";
    }
}

