/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation;

import com.bmc.cnvvalidation.CommonJobFH;
import com.bmc.cnvvalidation.ExternalParameters;
import com.bmc.cnvvalidation.LegacyReportInputStreamSuplier;
import com.bmc.cnvvalidation.LoadReport;
import com.bmc.cnvvalidation.MappingFileHandler;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LoadAutosysForecastReportFormat2
extends LoadReport {
    private MappingFileHandler mappingFileHandler;

    public LoadAutosysForecastReportFormat2(LegacyReportInputStreamSuplier legacyForecastReport, ExternalParameters externalParameters) {
        super(legacyForecastReport, externalParameters);
        try {
            this.mappingFileHandler = new MappingFileHandler(externalParameters.getJobnameMappingFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected CommonJobFH nextJobInternal() throws IOException, ParseException {
        String sAutosysReportRec;
        CommonJobFH job = null;
        while ((sAutosysReportRec = this.br.readLine()) != null) {
            if (sAutosysReportRec.contains("Server,Box,Job,Machine,Start Time,End Time, Duration") || (job = this.processFormat2Job(sAutosysReportRec)) == null) continue;
            return job;
        }
        return null;
    }

    private CommonJobFH processFormat2Job(String sAutosysReportRec) throws ParseException {
        String[] listOfFields = sAutosysReportRec.split(",");
        CommonJobFH job = null;
        if (listOfFields.length < 3) {
            return null;
        }
        String jobDateTime = listOfFields[4] + listOfFields[5];
        SimpleDateFormat df = new SimpleDateFormat("MMM dd yyyy hh:mm:ss a");
        String dateToParse = jobDateTime.substring(1, jobDateTime.length() - 1);
        Date reportDate = df.parse(dateToParse);
        SimpleDateFormat dateFormatCommon = new SimpleDateFormat("yyyyMMdd");
        String reportDateString = dateFormatCommon.format(reportDate);
        SimpleDateFormat timeFormatCommon = new SimpleDateFormat("HHmm");
        String reportTimeCommonString = timeFormatCommon.format(reportDate);
        SimpleDateFormat timeFormatCommonDisp = new SimpleDateFormat("HH:mm");
        String reportTimeStringDisp = timeFormatCommonDisp.format(reportDate);
        if (this.willJobRunInDateWithNewDay(reportDateString, reportTimeCommonString)) {
            job = new CommonJobFH(this.mappingFileHandler.getMapValue(listOfFields[2]), "", "", listOfFields[1], "", "", reportTimeStringDisp, "", reportDate.toString(), this.date.toString(), "", "CA-Autosys", "", "");
        }
        return job;
    }
}

