/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation;

import com.bmc.cnvvalidation.AutosysForecastReportFactory;
import com.bmc.cnvvalidation.ExternalParameters;
import com.bmc.cnvvalidation.LegacyReportInputStreamSuplier;
import com.bmc.cnvvalidation.LoadAutosysExecutionReport;
import com.bmc.cnvvalidation.LoadCA7ForecastReport;
import com.bmc.cnvvalidation.LoadCAUnicenterForecastReport;
import com.bmc.cnvvalidation.LoadDollarUniverseForecastReport;
import com.bmc.cnvvalidation.LoadESPExecutionReport;
import com.bmc.cnvvalidation.LoadESPForecastReport;
import com.bmc.cnvvalidation.LoadReport;
import com.bmc.cnvvalidation.LoadTWSExecutionReport;
import com.bmc.cnvvalidation.LoadTWSMFForecastReport;
import com.bmc.cnvvalidation.LoadZekeForecastReport;
import com.bmc.cnvvalidation.LoadZenaExecutionCSV;
import com.bmc.cnvvalidation.LoadZenaForecastReport;
import com.bmc.cnvvalidation.MessageCollector;
import java.io.IOException;

public class LegacyReportLoader {
    private final ExternalParameters externalParameters;
    private final MessageCollector messages;
    private final String typeOfCompare;

    public LegacyReportLoader(ExternalParameters externalParameters, MessageCollector messages, String typeOfCompare) {
        this.externalParameters = externalParameters;
        this.messages = messages;
        this.typeOfCompare = typeOfCompare;
    }

    public LoadReport get(String legacySchedulerName, LegacyReportInputStreamSuplier legacyForecastReport1) {
        LoadReport loadReport = null;
        block9 : switch (this.typeOfCompare) {
            case "Forecast": {
                switch (legacySchedulerName) {
                    case "Select": {
                        break block9;
                    }
                    case "CA-7": {
                        loadReport = new LoadCA7ForecastReport(legacyForecastReport1, this.externalParameters);
                        break block9;
                    }
                    case "ASG-Zeke": {
                        loadReport = new LoadZekeForecastReport(legacyForecastReport1, this.externalParameters);
                        break block9;
                    }
                    case "CA-Autosys": {
                        AutosysForecastReportFactory autosysForecastReportFactory = new AutosysForecastReportFactory(legacyForecastReport1, this.externalParameters);
                        loadReport = autosysForecastReportFactory.getLoader();
                        break block9;
                    }
                    case "CA-ESP": {
                        loadReport = new LoadESPForecastReport(legacyForecastReport1, this.externalParameters);
                        break block9;
                    }
                    case "IBM-TWS-MF": {
                        this.externalParameters.setForecastCompareLevel("folders");
                        try {
                            loadReport = new LoadTWSMFForecastReport(legacyForecastReport1, this.externalParameters);
                        }
                        catch (IOException e2) {
                            this.messages.add(e2.getMessage());
                            this.messages.add("Error loading mapping file - probably wrong file 1");
                        }
                        break block9;
                    }
                    case "Automic-Dollar-Universe": {
                        this.externalParameters.setForecastCompareLevel("folders");
                        loadReport = new LoadDollarUniverseForecastReport(legacyForecastReport1, this.externalParameters);
                        break block9;
                    }
                    case "IBM-TWS-DS": {
                        loadReport = new LoadTWSExecutionReport(legacyForecastReport1, this.externalParameters);
                        break block9;
                    }
                    case "CA-Unicenter-WLM-TNG": {
                        loadReport = new LoadCAUnicenterForecastReport(legacyForecastReport1, this.externalParameters);
                        break block9;
                    }
                    case "ASG-Zena": {
                        loadReport = new LoadZenaForecastReport(legacyForecastReport1, this.externalParameters);
                        break block9;
                    }
                }
                this.messages.add(this.typeOfCompare + " report is not supported for " + legacySchedulerName + ".");
                this.messages.add("If such a report will be sent to the lab, support for it would be added in a matter of days");
                break;
            }
            case "Execution": 
            case "Execution-to-Forecast": {
                switch (legacySchedulerName) {
                    case "ASG-Zena": {
                        try {
                            loadReport = new LoadZenaExecutionCSV(legacyForecastReport1, this.externalParameters);
                        }
                        catch (IOException e1) {
                            this.messages.add(e1.getMessage());
                            this.messages.add("Error loading Zena execution report");
                        }
                        break block9;
                    }
                    case "CA-ESP": {
                        try {
                            loadReport = new LoadESPExecutionReport(legacyForecastReport1, this.externalParameters);
                        }
                        catch (IOException e) {
                            this.messages.add(e.getMessage());
                            this.messages.add("Error loading ESP execution report");
                        }
                        break block9;
                    }
                    case "CA_AUTOSYS": {
                        try {
                            loadReport = new LoadAutosysExecutionReport(legacyForecastReport1, this.externalParameters);
                        }
                        catch (IOException e) {
                            this.messages.add(e.getMessage());
                            this.messages.add("Error loading Autosys execution report");
                        }
                        break block9;
                    }
                }
                this.messages.add(this.typeOfCompare + " report is not supported for " + legacySchedulerName + ".");
                this.messages.add("If such a report will be sent to the lab, support for it would be added in a matter of days");
                break;
            }
            default: {
                this.messages.add(this.typeOfCompare + " - Unknown compare type");
            }
        }
        return loadReport;
    }
}

