/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation;

import com.bmc.cnvvalidation.ExternalParameters;
import com.bmc.cnvvalidation.MessageCollector;
import com.bmc.cnvvalidation.RunCompare;
import com.bmc.cnvvalidation.TextFieldDigitsFilter;
import com.bmc.ctmconvert.base.DialogFactory;
import com.bmc.ctmconvert.common.CompareVersionToS3;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;

public class GetParmsGUI
extends JFrame {
    private static final long serialVersionUID = 1L;
    boolean bShowGrid;
    JPanel panel = new JPanel(new GridBagLayout());
    private final ExternalParameters externalParameters;
    private final Color colorGood = Color.GRAY;
    private final Color colorBad = Color.RED;
    boolean bFilterByVisible;
    private final JTextArea msgArea;
    private final List<JComponent> mComponents = new ArrayList<JComponent>();
    private final String mConfFileName = "workarea\\cnvvld.conf";
    private final HashMap<JComponent, Boolean> mFieldsValid = new HashMap();
    private int mRunCount = 0;
    private static final Date mBuildDate = GetParmsGUI.getBuildDate();
    public static final Map<String, String> CommandOf = GetParmsGUI.createCommandOf();
    private final HashMap<String, JComponent> jComps = new HashMap();
    private final Color pcol = Color.WHITE;

    private static StringBuilder TOOL_CMD_LINE() {
        return new StringBuilder("\"").append(System.getProperty("java.home")).append("\\bin\\java.exe\"").append(" -cp \"").append(Paths.get("lib", new String[0]).toAbsolutePath()).append("\\*;").append(Paths.get("", new String[0]).toAbsolutePath().getParent().resolve("lib\\Infrastructure").toAbsolutePath()).append("\\*\" com.bmc.cnvvalidation.App");
    }

    private static HashMap<String, String> createCommandOf() {
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("EMUser", "emuser");
        temp.put("EMPass", "empass");
        temp.put("GUIServer", "emserver");
        temp.put("ExlTgtLoc", "outputreport");
        temp.put("LegacySched", "legacy");
        temp.put("LegacySched2", "legacy2");
        temp.put("ReportType", "compare");
        temp.put("LegacyTZ", "legacyTZ");
        temp.put("InputReport", "report");
        temp.put("InputReport2", "report2");
        temp.put("ForecastRpt", "forecastreport");
        temp.put("HistoryRpt", "histexecreport");
        temp.put("FilterByControlm", "filterbycontrolm");
        temp.put("FilterByFolder", "filterbyfolder");
        temp.put("FilterByJobname", "filterbyjobname");
        temp.put("ZekeGroupBy", "zekegroupby");
        temp.put("ZekeJobLen", "zekejoblen");
        temp.put("zenaMappingFile", "zenajobnamemappingfile");
        temp.put("ExcludeFile", "excludeFile");
        temp.put("IncMatches", "includeokjobs");
        temp.put("MapCtm", "mapctmtolegacy");
        temp.put("ExcelReportLimit", "excelreportlimit");
        temp.put("NewDay", "newday");
        return temp;
    }

    public GetParmsGUI(ExternalParameters externalParameters) {
        super("BMC Control-M Conversion Verification Tool - " + GetParmsGUI.getVersion());
        this.externalParameters = externalParameters;
        String[] jTextFieldsNames = this.getTextFieldsNames(externalParameters);
        this.externalParameters.setJarDateTime(mBuildDate.toString());
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        for (int j = 0; j < jTextFieldsNames.length; j += 5) {
            JComponent jtf;
            String jcomp = jTextFieldsNames[j];
            String type = jTextFieldsNames[j + 1];
            if (!type.equals("panel")) {
                this.jComps.put(jcomp + "Lbl", new JLabel(jTextFieldsNames[j + 2]));
            }
            if (type.startsWith("text") || type.equals("pass") || type.equals("hint")) {
                int jlen = Integer.parseInt(jTextFieldsNames[j + 3]);
                jtf = type.startsWith("text") ? new JTextField(jlen) : new JPasswordField(jlen);
                jtf.setName(CommandOf.get(jcomp));
                Dimension d = jtf.getSize();
                d.setSize(d.width, 0);
                jtf.setMinimumSize(d);
                if (!type.equals("text_nover")) {
                    final JComponent jtf2 = jtf;
                    ((JTextComponent)jtf).getDocument().addDocumentListener(new DocumentListener(){

                        @Override
                        public void changedUpdate(DocumentEvent e) {
                            GetParmsGUI.this.doverify(jtf2);
                        }

                        @Override
                        public void removeUpdate(DocumentEvent e) {
                            GetParmsGUI.this.doverify(jtf2);
                        }

                        @Override
                        public void insertUpdate(DocumentEvent e) {
                            GetParmsGUI.this.doverify(jtf2);
                        }
                    });
                    this.mComponents.add(jtf);
                }
                this.jComps.put(jcomp + "Fld", jtf);
            }
            if (type.equals("checkbox")) {
                jtf = new JCheckBox(jTextFieldsNames[j + 3]);
                jtf.setBackground(Color.WHITE);
                jtf.setName(CommandOf.get(jcomp));
                boolean selected = true;
                if (jcomp.equals("IncMatches")) {
                    selected = externalParameters.getIncludeOKJobs().equals("YES");
                }
                if (jcomp.equals("MapCtm")) {
                    selected = externalParameters.getMapCtmToLegacy().equals("YES");
                }
                ((JCheckBox)jtf).setSelected(selected);
                this.jComps.put(jcomp + "Chkbox", jtf);
                this.mComponents.add(jtf);
            }
            if (type.equals("combo") || type.equals("comboWide")) {
                int width = type.equals("combo") ? 148 : 250;
                String[] list = jTextFieldsNames[j + 3].substring(1, jTextFieldsNames[j + 3].length() - 1).split(",");
                for (int l = 0; l < list.length; ++l) {
                    list[l] = list[l].trim();
                }
                jtf = new JComboBox<String>(list);
                this.jComps.put(jcomp + "Combo", jtf);
                jtf.setName(CommandOf.get(jcomp));
                jtf.setPreferredSize(new Dimension(width, 20));
                this.mComponents.add(this.jComps.get(jcomp + "Combo"));
            }
            if (type.equals("help")) {
                jtf = new JLabel(new ImageIcon(this.getClass().getResource("/images/help.png")));
                final String helpparm = jTextFieldsNames[j + 2];
                jtf.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent me) {
                        GetParmsGUI.this.viewHelp(helpparm, null);
                    }
                });
                this.jComps.put(jcomp + "Btn", jtf);
            }
            if (type.equals("panel")) {
                jtf = new JPanel(new GridBagLayout());
                jtf.setBackground(this.pcol);
                this.jComps.put(jcomp + "Panel", jtf);
            }
            if (jTextFieldsNames[j + 4].isEmpty()) continue;
            this.jComps.put(jcomp + "Btn", new JButton(jTextFieldsNames[j + 4]));
        }
        Color bmcOrange = new Color(248, 110, 0);
        this.jComps.get("Header1Lbl").setFont(new Font(this.jComps.get("Header1Lbl").getFont().getFontName(), 1, this.jComps.get("Header1Lbl").getFont().getSize()));
        this.jComps.get("Header1Lbl").setForeground(bmcOrange);
        ((AbstractButton)this.jComps.get("ExlTgtLocBtn")).addActionListener(evt -> this.fileBrowseButton((JTextField)this.jComps.get("ExlTgtLocFld"), true));
        ((JComboBox)this.jComps.get("LegacySchedCombo")).addActionListener(evt -> this.LegacySchedAction());
        ((JComboBox)this.jComps.get("LegacySched2Combo")).addActionListener(evt -> this.LegacySchedAction2());
        ((JComboBox)this.jComps.get("ReportTypeCombo")).addActionListener(this::reportTypeAction);
        ((JComboBox)this.jComps.get("LegacyTZCombo")).addActionListener(this::legacyTzAction);
        ((AbstractButton)this.jComps.get("InputReportBtn")).addActionListener(evt -> this.fileBrowseButton((JTextField)this.jComps.get("InputReportFld")));
        ((AbstractButton)this.jComps.get("InputReport2Btn")).addActionListener(evt -> this.fileBrowseButton((JTextField)this.jComps.get("InputReport2Fld")));
        JSpinner zjl = new JSpinner(new SpinnerNumberModel(8, 1, 8, 1));
        zjl.addChangeListener(this::jobLengthChanged);
        zjl.setName(CommandOf.get("ZekeJobLen"));
        this.mComponents.add(zjl);
        this.jComps.put("ZekeJobLenFld", zjl);
        String[] plusminus = new String[]{"+", "-"};
        JComboBox<String> newDayPlusMinusCombo = new JComboBox<String>(plusminus);
        newDayPlusMinusCombo.addActionListener(evt -> this.newDayChanged());
        newDayPlusMinusCombo.getFont().deriveFont(1);
        this.jComps.put("NewDayPlusMinusCombo", newDayPlusMinusCombo);
        Object[] hours = new String[24];
        for (int h = 0; h < 24; ++h) {
            String hh = "0" + h;
            hours[h] = hh.substring(hh.length() - 2);
        }
        JSpinner newDayHours = new JSpinner(new SpinnerListModel(hours));
        newDayHours.addChangeListener(e -> this.newDayChanged());
        this.jComps.put("NewDayHoursFld", newDayHours);
        Object[] mins = new String[60];
        for (int m = 0; m < 60; ++m) {
            String mm = "0" + m;
            mins[m] = mm.substring(mm.length() - 2);
        }
        JSpinner newDayMins = new JSpinner(new SpinnerListModel(mins));
        newDayMins.addChangeListener(e -> this.newDayChanged());
        this.jComps.put("NewDayMinsFld", newDayMins);
        this.jComps.get("newDayPanel").setName(CommandOf.get("NewDay"));
        this.mComponents.add(this.jComps.get("newDayPanel"));
        this.configureFont("ForecastRptBtn", "ForecastRptFld", "Leave empty to run Control-M Forecast");
        this.configureFont("HistoryRptBtn", "HistoryRptFld", "leave empty to run Control-M Execution History report");
        this.configureFont("ExcludeFileBtn", "ExcludeFileFld", "Exclude file");
        this.jComps.get("zekePanel").setBackground(this.pcol);
        ((JComboBox)this.jComps.get("ZekeGroupByCombo")).addActionListener(evt -> this.zekeGroupByComboAction());
        this.jComps.get("zenaPanel").setBackground(this.pcol);
        ((AbstractButton)this.jComps.get("zenaMappingFileBtn")).addActionListener(evt -> this.fileBrowseButton((JTextField)this.jComps.get("zenaMappingFileFld")));
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/bmc_icon.png")));
        this.jComps.put("FilterPlusMinusLbl", new JLabel(new ImageIcon(this.getClass().getResource("/images/expand.png"))));
        this.jComps.get("FilterPlusMinusLbl").addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                GetParmsGUI.this.toggleFilters(!GetParmsGUI.this.bFilterByVisible);
                GetParmsGUI.this.pack();
                GetParmsGUI.this.setCommandLine();
            }
        });
        Color ne = new Color(224, 224, 224);
        this.msgArea = new JTextArea("", 5, 72);
        this.msgArea.setName("msgarea");
        this.msgArea.setEditable(false);
        this.msgArea.setBackground(ne);
        this.msgArea.setLineWrap(true);
        JScrollPane scroll = new JScrollPane(this.msgArea);
        scroll.setVerticalScrollBarPolicy(22);
        JButton copyButton = new JButton("Copy");
        copyButton.addActionListener(e -> {
            StringSelection stringSelection = new StringSelection(((JTextComponent)this.jComps.get("CommandFld")).getText());
            Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
            clpbrd.setContents(stringSelection, null);
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> {
            this.setVisible(false);
            this.dispose();
        });
        JButton runButton = new JButton("Run");
        runButton.addActionListener(e -> {
            if (this.mComponents.stream().filter(jc -> jc instanceof JTextField).anyMatch(jc -> jc.isVisible() && this.mFieldsValid.get(jc) == false)) {
                JOptionPane.showMessageDialog(null, "Please correct invalid fields and 'Run' again");
                return;
            }
            this.saveConfig();
            new RunCompareWorker(externalParameters, this.msgArea, ++this.mRunCount).execute();
        });
        JButton openReportButton = new JButton("Open report...");
        openReportButton.addActionListener(e -> GetParmsGUI.openVerifyReport(externalParameters.getOutputReportFullName()));
        ((JCheckBox)this.jComps.get("IncMatchesChkbox")).addItemListener(evt -> this.incrementMatchAction());
        ((JCheckBox)this.jComps.get("MapCtmChkbox")).addItemListener(evt -> this.mapCtmToLegacyAction());
        JTextComponent jtx = (JTextComponent)this.jComps.get("CommandFld");
        jtx.setEditable(false);
        jtx.setBackground(ne);
        jtx.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
        this.jComps.get("buttonPanel").setBackground(this.pcol);
        GridBagConstraints gridComponent = new GridBagConstraints();
        Insets is1 = new Insets(10, 15, 5, 0);
        Insets is2 = new Insets(0, 5, 0, 5);
        Insets isZ = new Insets(0, 40, 0, 5);
        int rowNumber = 0;
        this.bShowGrid = false;
        this.panel.setBackground(this.pcol);
        this.jComps.get("headPanel").setBackground(this.pcol);
        gridComponent.insets = new Insets(0, 0, 0, 0);
        gridComponent.gridx += gridComponent.gridwidth;
        this.AddTo(this.jComps.get("headPanel"), this.jComps.get("Header1Lbl"), gridComponent);
        gridComponent.gridy = 0;
        gridComponent.insets = new Insets(0, 210, 0, 0);
        gridComponent.anchor = 12;
        gridComponent.gridx += gridComponent.gridwidth;
        this.AddTo(this.jComps.get("headPanel"), this.jComps.get("GeneralHelpBtn"), gridComponent);
        gridComponent.anchor = 17;
        gridComponent.insets = new Insets(15, 0, 15, 0);
        gridComponent.gridx = 1;
        gridComponent.gridwidth = 6;
        this.AddTo(this.panel, this.jComps.get("headPanel"), gridComponent);
        ++rowNumber;
        rowNumber = this.addComponent(gridComponent, rowNumber, GetParmsGUI.componentConfigurationBuilder().componentName("EMUser").show(true).padding(is1, is2).label("EMUserLbl").gridWidth(1, 2, 3).field("EMUserFld").build());
        rowNumber = this.addComponent(gridComponent, rowNumber, GetParmsGUI.componentConfigurationBuilder().componentName("EMPass").show(true).padding(is1, is2).label("EMPassLbl").gridWidth(1, 2, 1).field("EMPassFld").build());
        rowNumber = this.addGuiServerComponenet(gridComponent, is1, is2, rowNumber);
        this.addLegacySchedReportComponent(gridComponent, is1, is2, rowNumber);
        GridBagConstraints layoutContainer = new GridBagConstraints();
        layoutContainer.insets = new Insets(5, 0, 5, 0);
        layoutContainer.anchor = 17;
        layoutContainer.gridy = 0;
        layoutContainer.gridx = 0;
        layoutContainer.gridwidth = 2;
        this.AddTo(this.jComps.get("LegacySchedPanel"), this.jComps.get("LegacySchedCombo"), layoutContainer);
        layoutContainer.insets = new Insets(5, 43, 5, 0);
        layoutContainer.gridx += layoutContainer.gridwidth;
        layoutContainer.gridwidth = 1;
        this.AddTo(this.jComps.get("LegacySchedPanel"), this.jComps.get("LegacySched2Lbl"), layoutContainer);
        layoutContainer.insets = new Insets(5, 43, 5, 0);
        layoutContainer.gridx += layoutContainer.gridwidth;
        layoutContainer.gridwidth = 1;
        this.AddTo(this.jComps.get("LegacySchedPanel"), this.jComps.get("LegacySched2Combo"), layoutContainer);
        gridComponent.gridy = rowNumber++;
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 1;
        this.AddTo(this.panel, this.jComps.get("LegacySchedPanel"), gridComponent);
        rowNumber = this.addComponent(gridComponent, rowNumber, GetParmsGUI.componentConfigurationBuilder().componentName("ReportType").gridWidth(1, 2, 1).label("ReportTypeLbl").show(false).padding(is1, is2).field("ReportTypeCombo").build());
        rowNumber = this.addComponent(gridComponent, rowNumber, GetParmsGUI.componentConfigurationBuilder().componentName("LegacyTZ").gridWidth(1, 2, 1).label("LegacyTZLbl").show(true).padding(is1, is2).field("LegacyTZCombo").build());
        gridComponent.insets = is1;
        gridComponent.gridy = rowNumber++;
        gridComponent.gridx = 0;
        gridComponent.gridwidth = 1;
        this.AddTo(this.panel, this.mandatoryLabel(false, "NewDay"), gridComponent);
        gridComponent.insets = is2;
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 2;
        this.AddTo(this.panel, this.jComps.get("NewDayOffsetLbl"), gridComponent);
        gridComponent.insets = is2;
        GridBagConstraints n = new GridBagConstraints();
        n.insets = new Insets(5, 0, 5, 0);
        n.anchor = 17;
        n.gridx = 0;
        n.gridwidth = 1;
        this.AddTo(this.jComps.get("newDayPanel"), this.jComps.get("NewDayPlusMinusCombo"), n);
        n.gridx += n.gridwidth;
        this.AddTo(this.jComps.get("newDayPanel"), this.jComps.get("NewDayHoursFld"), n);
        n.gridx += n.gridwidth;
        this.AddTo(this.jComps.get("newDayPanel"), this.jComps.get("NewDayMinsFld"), n);
        n.insets = new Insets(5, 10, 5, 0);
        n.gridx += n.gridwidth;
        this.AddTo(this.jComps.get("newDayPanel"), this.jComps.get("NewDayHelpBtn"), n);
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 1;
        this.AddTo(this.panel, this.jComps.get("newDayPanel"), gridComponent);
        rowNumber = this.addComponent(gridComponent, rowNumber, GetParmsGUI.componentConfigurationBuilder().componentName("InputReport").show(true).padding(is1, is2).label("InputReportLbl").gridWidth(1, 2, 1).field("InputReportFld").build());
        gridComponent.gridx += gridComponent.gridwidth;
        this.AddTo(this.panel, this.jComps.get("InputReportBtn"), gridComponent);
        gridComponent.anchor = 17;
        gridComponent.gridx = 5;
        this.AddTo(this.panel, this.jComps.get("InputReportHelpBtn"), gridComponent);
        rowNumber = this.addComponent(gridComponent, rowNumber, GetParmsGUI.componentConfigurationBuilder().componentName("InputReport2").field("InputReport2Fld").label("InputReport2Lbl").gridWidth(1, 2, 1).show(true).padding(is1, is2).build());
        gridComponent.gridx += gridComponent.gridwidth;
        this.AddTo(this.panel, this.jComps.get("InputReport2Btn"), gridComponent);
        gridComponent.anchor = 17;
        gridComponent.gridx = 5;
        this.AddTo(this.panel, this.jComps.get("InputReport2HelpBtn"), gridComponent);
        rowNumber = this.addComponent(gridComponent, rowNumber, GetParmsGUI.componentConfigurationBuilder().componentName("ForecastRpt1").label("ForecastRptLbl").field("ForecastRptFld").show(false).padding(is1, is2).gridWidth(1, 2, 1).build());
        gridComponent.gridx += gridComponent.gridwidth;
        this.AddTo(this.panel, this.jComps.get("ForecastRptBtn"), gridComponent);
        rowNumber = this.addComponent(gridComponent, rowNumber, GetParmsGUI.componentConfigurationBuilder().componentName("HistoryRpt").label("HistoryRptLbl").field("HistoryRptFld").show(false).padding(is1, is2).gridWidth(1, 2, 1).build());
        gridComponent.gridx += gridComponent.gridwidth;
        this.AddTo(this.panel, this.jComps.get("HistoryRptBtn"), gridComponent);
        rowNumber = this.addMappingFileComponent(gridComponent, is1, is2, rowNumber);
        gridComponent.insets = is1;
        gridComponent.gridy = rowNumber++;
        gridComponent.gridx = 0;
        this.AddTo(this.panel, this.mandatoryLabel(false, "MapCtm"), gridComponent);
        gridComponent.insets = is2;
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 2;
        this.AddTo(this.panel, this.jComps.get("MapCtmLbl"), gridComponent);
        gridComponent.insets = new Insets(0, 0, 0, 5);
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 1;
        this.AddTo(this.panel, this.jComps.get("MapCtmChkbox"), gridComponent);
        rowNumber = this.addExcludeFile(gridComponent, is1, is2, rowNumber);
        gridComponent.gridx += gridComponent.gridwidth;
        this.AddTo(this.panel, this.jComps.get("ExcludeFileBtn"), gridComponent);
        GridBagConstraints z = new GridBagConstraints();
        z.anchor = 17;
        JPanel zekePanel = (JPanel)this.jComps.get("zekePanel");
        z.insets = new Insets(2, 2, 2, 2);
        z.gridy = 0;
        z.gridx = 0;
        this.AddTo(zekePanel, this.jComps.get("ZekeFieldsLbl"), z);
        ++z.gridx;
        z.anchor = 17;
        this.AddTo(zekePanel, this.jComps.get("zekeWhatBtn"), z);
        z.anchor = 13;
        gridComponent.insets = is1;
        gridComponent.gridy = rowNumber++;
        gridComponent.gridx = 0;
        gridComponent.gridwidth = 1;
        this.AddTo(this.panel, this.mandatoryLabel(false, "ZekeFields"), gridComponent);
        gridComponent.insets = is2;
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 4;
        this.AddTo(this.panel, zekePanel, gridComponent);
        gridComponent.insets = is1;
        gridComponent.gridy = rowNumber++;
        gridComponent.gridx = 0;
        gridComponent.gridwidth = 1;
        this.AddTo(this.panel, this.mandatoryLabel(false, "ZekeGroupBy"), gridComponent);
        gridComponent.insets = isZ;
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 2;
        this.AddTo(this.panel, this.jComps.get("ZekeGroupByLbl"), gridComponent);
        gridComponent.insets = is2;
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 1;
        this.AddTo(this.panel, this.jComps.get("ZekeGroupByCombo"), gridComponent);
        gridComponent.insets = is1;
        gridComponent.gridy = rowNumber++;
        gridComponent.gridx = 0;
        gridComponent.gridwidth = 1;
        this.AddTo(this.panel, this.mandatoryLabel(false, "ZekeJobLen"), gridComponent);
        gridComponent.insets = isZ;
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 2;
        this.AddTo(this.panel, this.jComps.get("ZekeJobLenLbl"), gridComponent);
        gridComponent.insets = is2;
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 1;
        this.AddTo(this.panel, this.jComps.get("ZekeJobLenFld"), gridComponent);
        gridComponent.gridwidth = 1;
        gridComponent.insets = new Insets(2, 10, 2, 0);
        gridComponent.gridy = rowNumber++;
        gridComponent.anchor = 12;
        gridComponent.gridx = 0;
        this.AddTo(this.panel, this.jComps.get("FilterPlusMinusLbl"), gridComponent);
        gridComponent.anchor = 17;
        gridComponent.insets = is2;
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 2;
        this.AddTo(this.panel, this.jComps.get("FilterLbl"), gridComponent);
        gridComponent.insets = is1;
        gridComponent.gridy = rowNumber++;
        gridComponent.gridx = 0;
        this.AddTo(this.panel, this.mandatoryLabel(false, "FilterByControlm"), gridComponent);
        gridComponent.insets = isZ;
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 2;
        this.AddTo(this.panel, this.jComps.get("FilterByControlmLbl"), gridComponent);
        gridComponent.insets = is2;
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 1;
        this.AddTo(this.panel, this.jComps.get("FilterByControlmFld"), gridComponent);
        gridComponent.insets = is1;
        gridComponent.gridy = rowNumber++;
        gridComponent.gridx = 0;
        this.AddTo(this.panel, this.mandatoryLabel(false, "FilterByFolder"), gridComponent);
        gridComponent.insets = isZ;
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 2;
        this.AddTo(this.panel, this.jComps.get("FilterByFolderLbl"), gridComponent);
        gridComponent.insets = is2;
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 1;
        this.AddTo(this.panel, this.jComps.get("FilterByFolderFld"), gridComponent);
        gridComponent.insets = is1;
        gridComponent.gridy = rowNumber++;
        gridComponent.gridx = 0;
        this.AddTo(this.panel, this.mandatoryLabel(false, "FilterByJobname"), gridComponent);
        gridComponent.insets = isZ;
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 2;
        this.AddTo(this.panel, this.jComps.get("FilterByJobnameLbl"), gridComponent);
        gridComponent.insets = is2;
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 1;
        this.AddTo(this.panel, this.jComps.get("FilterByJobnameFld"), gridComponent);
        gridComponent.insets = is1;
        gridComponent.gridy = rowNumber++;
        gridComponent.gridx = 0;
        this.AddTo(this.panel, this.mandatoryLabel(true, "ExlTgtLoc"), gridComponent);
        gridComponent.insets = is2;
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 2;
        this.AddTo(this.panel, this.jComps.get("ExlTgtLocLbl"), gridComponent);
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 1;
        this.AddTo(this.panel, this.jComps.get("ExlTgtLocFld"), gridComponent);
        gridComponent.gridx += gridComponent.gridwidth;
        this.AddTo(this.panel, this.jComps.get("ExlTgtLocBtn"), gridComponent);
        gridComponent.insets = is1;
        gridComponent.gridy = rowNumber++;
        gridComponent.gridx = 0;
        this.AddTo(this.panel, this.mandatoryLabel(false, "IncMatches"), gridComponent);
        gridComponent.insets = is2;
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 2;
        this.AddTo(this.panel, this.jComps.get("IncMatchesLbl"), gridComponent);
        gridComponent.insets = new Insets(0, 0, 0, 5);
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 1;
        this.AddTo(this.panel, this.jComps.get("IncMatchesChkbox"), gridComponent);
        rowNumber = this.addComponent(gridComponent, rowNumber, GetParmsGUI.componentConfigurationBuilder().componentName("ExcelReportLimit").show(true).padding(is1, is2).label("ExcelReportLimitLbl").gridWidth(1, 2, 1).field("ExcelReportLimitFld").build());
        ((PlainDocument)((JTextField)this.jComps.get("ExcelReportLimitFld")).getDocument()).setDocumentFilter(new TextFieldDigitsFilter());
        GridBagConstraints d = new GridBagConstraints();
        d.insets = new Insets(5, 0, 5, 5);
        d.gridx = 0;
        this.AddTo(this.jComps.get("cmdPanel"), this.jComps.get("CommandFld"), d);
        d.insets = new Insets(5, 0, 5, 15);
        d.gridx = 1;
        this.AddTo(this.jComps.get("cmdPanel"), copyButton, d);
        gridComponent.insets = is1;
        gridComponent.gridy = rowNumber++;
        gridComponent.gridx = 0;
        this.AddTo(this.panel, this.mandatoryLabel(false, "Command"), gridComponent);
        gridComponent.insets = is2;
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 2;
        this.AddTo(this.panel, this.jComps.get("CommandLbl"), gridComponent);
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 4;
        this.AddTo(this.panel, this.jComps.get("cmdPanel"), gridComponent);
        gridComponent.insets = is1;
        gridComponent.gridy = rowNumber++;
        gridComponent.gridx = 0;
        gridComponent.gridwidth = 1;
        this.AddTo(this.panel, this.mandatoryLabel(false), gridComponent);
        gridComponent.insets = is2;
        gridComponent.anchor = 18;
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 1;
        this.AddTo(this.panel, this.jComps.get("MsgAreaLbl"), gridComponent);
        gridComponent.insets = new Insets(0, 5, 15, 5);
        gridComponent.gridx = 3;
        gridComponent.gridwidth = 3;
        this.AddTo(this.panel, scroll, gridComponent);
        GridBagConstraints b = new GridBagConstraints();
        b.insets = new Insets(5, 15, 5, 350);
        b.anchor = 17;
        b.gridx = 0;
        this.AddTo(this.jComps.get("buttonPanel"), openReportButton, b);
        b.insets = new Insets(5, 5, 5, 5);
        b.anchor = 13;
        ++b.gridx;
        this.AddTo(this.jComps.get("buttonPanel"), runButton, b);
        ++b.gridx;
        this.AddTo(this.jComps.get("buttonPanel"), cancelButton, b);
        gridComponent.gridy = rowNumber++;
        gridComponent.gridwidth = 1;
        gridComponent.gridx = 0;
        this.AddTo(this.panel, this.mandatoryLabel(false, "button"), gridComponent);
        gridComponent.insets = new Insets(5, 6, 5, 0);
        gridComponent.anchor = 13;
        gridComponent.gridx = 2;
        gridComponent.gridwidth = 4;
        this.AddTo(this.panel, this.jComps.get("buttonPanel"), gridComponent);
        this.add((Component)this.panel, "First");
        this.toggleFilters(false);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.LoadConfig();
    }

    private int addExcludeFile(GridBagConstraints gridComponent, Insets is1, Insets is2, int rowNumber) {
        gridComponent.insets = is1;
        gridComponent.gridy = rowNumber++;
        gridComponent.gridx = 0;
        gridComponent.gridwidth = 1;
        this.AddTo(this.panel, new JLabel(""), gridComponent);
        gridComponent.insets = is2;
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 2;
        this.AddTo(this.panel, this.jComps.get("ExcludeFileLbl"), gridComponent);
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 1;
        this.AddTo(this.panel, this.jComps.get("ExcludeFileFld"), gridComponent);
        return rowNumber;
    }

    private void configureFont(String buttonName, String field, String text) {
        ((AbstractButton)this.jComps.get(buttonName)).addActionListener(evt -> this.fileBrowseButton((JTextField)this.jComps.get(field)));
        textPrompt tpF = new textPrompt(text, (JTextField)this.jComps.get(field));
        tpF.setForeground(Color.LIGHT_GRAY);
        tpF.changeStyle(2);
    }

    private int addMappingFileComponent(GridBagConstraints gridComponent, Insets is1, Insets is2, int rowNumber) {
        gridComponent.insets = is1;
        gridComponent.gridy = rowNumber++;
        gridComponent.gridx = 0;
        this.AddTo(this.panel, this.mandatoryLabel(false, "zenaMappingFile"), gridComponent);
        gridComponent.insets = is2;
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 2;
        this.AddTo(this.panel, this.jComps.get("zenaMappingFileLbl"), gridComponent);
        gridComponent.insets = is2;
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 1;
        this.AddTo(this.panel, this.jComps.get("zenaMappingFileFld"), gridComponent);
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 1;
        this.AddTo(this.panel, this.jComps.get("zenaMappingFileBtn"), gridComponent);
        return rowNumber;
    }

    private void addLegacySchedReportComponent(@NotNull GridBagConstraints gridComponent, Insets is1, Insets is2, int rowNumber) {
        gridComponent.insets = is1;
        gridComponent.gridy = rowNumber;
        gridComponent.gridx = 0;
        gridComponent.gridwidth = 1;
        this.AddTo(this.panel, this.mandatoryLabel(false, "LegacySched"), gridComponent);
        gridComponent.insets = is2;
        gridComponent.gridx = 1;
        gridComponent.gridwidth = 2;
        this.AddTo(this.panel, this.jComps.get("LegacySchedLbl"), gridComponent);
    }

    private int addGuiServerComponenet(GridBagConstraints gridComponent, Insets is1, Insets is2, int rowNumber) {
        gridComponent.insets = is1;
        gridComponent.gridy = rowNumber++;
        gridComponent.gridx = 0;
        this.AddTo(this.panel, this.mandatoryLabel(true, "GUIServer"), gridComponent);
        gridComponent.insets = is2;
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 2;
        this.AddTo(this.panel, this.jComps.get("GUIServerLbl"), gridComponent);
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = 1;
        this.AddTo(this.panel, this.jComps.get("GUIServerFld"), gridComponent);
        return rowNumber;
    }

    private int addComponent(GridBagConstraints gridComponent, int rowNumber, ComponentConfiguration configuration) {
        return this.addComponent(gridComponent, configuration.leftPadding, rowNumber, configuration.show, configuration.componentName, configuration.rightPadding, configuration.label, configuration.gridWidth, configuration.field);
    }

    private int addComponent(GridBagConstraints gridComponent, Insets is1, int rowNumber, boolean show, String componentName, Insets is2, String label, Triple<Integer, Integer, Integer> gridWidth, String field) {
        gridComponent.insets = is1;
        gridComponent.gridy = rowNumber++;
        gridComponent.gridx = 0;
        gridComponent.gridwidth = (Integer)gridWidth.getLeft();
        this.AddTo(this.panel, this.mandatoryLabel(show, componentName), gridComponent);
        gridComponent.insets = is2;
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = (Integer)gridWidth.getMiddle();
        this.AddTo(this.panel, this.jComps.get(label), gridComponent);
        gridComponent.gridx += gridComponent.gridwidth;
        gridComponent.gridwidth = (Integer)gridWidth.getRight();
        this.AddTo(this.panel, this.jComps.get(field), gridComponent);
        return rowNumber;
    }

    private static String tzList() {
        return GetParmsGUI.getAllZoneIds().stream().collect(Collectors.joining(", ", "[", "]"));
    }

    private static List<String> getAllZoneIds() {
        ArrayList<String> result = new ArrayList<String>();
        Instant dt = Instant.now();
        for (String zoneId : ZoneId.getAvailableZoneIds()) {
            ZoneId zone = ZoneId.of(zoneId);
            ZoneOffset zos = dt.atZone(zone).getOffset();
            String offset = zos.getId().replaceAll("Z", "+00:00");
            result.add(String.format("%5s (UTC%s) %n", zone, offset));
        }
        return result;
    }

    private String[] getTextFieldsNames(ExternalParameters externalParameters) {
        return new String[]{"Header1", "label", "Compare legacy tool reports to Control-M reports in order to Validate Conversion scheduling results", "", "", "head", "panel", "", "", "", "EMUser", "text", "EM user", "18", "", "EMPass", "pass", "EM password", "18", "", "GUIServer", "text", "GUI server", "18", "", "ExlTgtLoc", "text", "Output report location", "50", "Browse...", "LegacySched", "combo", "Legacy scheduler", externalParameters.listTypeOfLegcy().toString(), "", "LegacySched2", "combo", "and", externalParameters.listTypeOfLegcy().toString(), "", "LegacySched", "panel", "", "", "", "ReportType", "combo", "Report type", this.formatStringGroup("Forecast", "Execution", "Execution-to-Forecast"), "", "LegacyTZ", "comboWide", "Legacy Time Zone", GetParmsGUI.tzList(), "", "newDay", "panel", "", "", "", "NewDayOffset", "label", "New Day Offset", "", "", "InputReport", "text", "Legacy schedular input report", "50", "Browse...", "InputReport2", "text", "2nd Legacy schedular input report", "50", "Browse...", "ForecastRpt", "text", "Control-M Forecast report", "50", "Browse...", "HistoryRpt", "text", "Control-M Execution report", "50", "Browse...", "ExcludeFile", "text", "Exclude file", "50", "Browse...", "Filter", "panel", "", "", "", "FilterByControlm", "text", "Control-M", "10", "", "FilterByFolder", "text", "Folder", "10", "", "FilterByJobname", "text", "JobName", "10", "", "cmd", "panel", "", "", "", "Command", "text_nover", "Command", "67", "", "zeke", "panel", "", "", "", "ZekeFields", "label", "ASG-Zeke Fields", "", "", "ZekeJobLen", "label", "Job length", "", "", "ZekeGroupBy", "combo", "Group by", this.formatStringGroup("APPGRP", "APP", "EVT", "JOB", "USERID"), "", "zena", "panel", "", "", "", "ZenaFields", "label", "ASG-Zena Fields", "", "", "zenaMappingFile", "text", "Mapping file", "50", "Browse...", "button", "panel", "", "", "", "GeneralHelp", "help", "General", "", "", "InputReportHelp", "help", "InputReport", "", "", "InputReport2Help", "help", "InputReport2", "", "", "NewDayHelp", "help", "NewDay", "", "", "zekeWhat", "help", "About", "", "", "zenaWhat", "help", "About", "", "", "Filter", "label", "Comparison Filters", "", "", "MsgArea", "msgbox", "Log", "72", "", "IncMatches", "checkbox", "Matching Folders\\Jobs", "Include matching Folders\\Jobs in the output report", "", "MapCtm", "checkbox", "Map Direction", "Map Control-M job names to legacy", "", "ExcelReportLimit", "text", "Excel Report Limit", "8", ""};
    }

    public JLabel mandatoryLabel(boolean bShow, String sName) {
        String text = " ";
        if (bShow) {
            text = "*";
        }
        JLabel label = new JLabel(text);
        label.setForeground(Color.RED);
        if (!sName.isEmpty()) {
            label.setName(sName);
            this.jComps.put(sName, label);
        }
        return label;
    }

    public JLabel mandatoryLabel(boolean bShow) {
        return this.mandatoryLabel(bShow, "");
    }

    public void fileBrowseButton(JTextField textField) {
        this.fileBrowseButton(textField, false);
    }

    public void fileBrowseButton(JTextField textField, boolean bDirOnly) {
        int returnVal;
        String dir = textField.getText();
        File f = new File(dir);
        try {
            f = new File(f.getParent());
            dir = f.exists() ? f.toString() : System.getProperty("user.dir");
        }
        catch (Exception e1) {
            dir = System.getProperty("user.dir");
        }
        JFileChooser fc = new JFileChooser(dir);
        if (bDirOnly) {
            fc.setFileSelectionMode(1);
        }
        if ((returnVal = fc.showOpenDialog(textField)) == 0) {
            textField.setText(fc.getSelectedFile().toString());
            this.setFieldValue(textField);
            this.setCommandLine();
        }
    }

    private static void openVerifyReport(String filePath) {
        Desktop dt = Desktop.getDesktop();
        try {
            File reportFile = new File((String)filePath);
            dt.open(reportFile);
        }
        catch (Exception e1) {
            File fi;
            if (((String)filePath).lastIndexOf(".") != -1) {
                filePath = ((String)filePath).substring(0, ((String)filePath).lastIndexOf(".")) + ".csv";
            }
            if ((fi = new File((String)filePath)).isFile()) {
                try {
                    dt.open(fi);
                }
                catch (Exception e2) {
                    JOptionPane.showMessageDialog(null, "Unable to open \"" + (String)filePath + "\".\n\n Please (re-)Run report and try again.\n");
                }
            }
            JOptionPane.showMessageDialog(null, "File \"" + (String)filePath + "\" does not exist.\n\n Please (re-)Run report and try again.\n");
        }
    }

    private void viewHelp(String helpType, JComponent component) {
        JDialog helpwindow = DialogFactory.instance().getLinkedDialog();
        helpwindow.setLayout(new FlowLayout(3, 5, 5));
        helpwindow.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/bmc_icon.png")));
        JTextArea content = helpType.equals("General") ? new JTextArea(30, 110) : new JTextArea();
        Object title = "";
        InputStream is = null;
        if (component == null) {
            helpwindow.setLocation(100, 100);
        } else {
            helpwindow.setLocationRelativeTo(component);
        }
        String legacySched = ((JComboBox)this.jComps.get("LegacySchedCombo")).getSelectedItem().toString();
        String legacySched2 = ((JComboBox)this.jComps.get("LegacySched2Combo")).getSelectedItem().toString();
        StringBuffer sb = new StringBuffer();
        switch (helpType) {
            case "InputReport": {
                title = "Guidelines for producing Input report for " + legacySched;
                is = this.getClass().getClassLoader().getResourceAsStream("helps/" + helpType + "_" + legacySched + ".txt");
                break;
            }
            case "InputReport2": {
                title = "Guidelines for producing Input report for " + legacySched2;
                is = this.getClass().getClassLoader().getResourceAsStream("helps/InputReport_" + legacySched2 + ".txt");
                break;
            }
            case "NewDay": {
                title = "Understanding the New Day Offset";
                is = this.getClass().getClassLoader().getResourceAsStream("helps/NewDay.txt");
                break;
            }
            case "About": {
                title = "Understanding the " + legacySched + " specific fields";
                break;
            }
            case "General": {
                title = "How to run Verification";
                is = this.getClass().getClassLoader().getResourceAsStream("helps/HowToRun.txt");
                break;
            }
            default: {
                title = legacySched + " Help";
            }
        }
        try {
            String line;
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            br.close();
            isr.close();
            is.close();
            content.setText((String)title + "\n" + GetParmsGUI.Copies('=', ((String)title).length()) + "\n\n" + sb.toString().substring(0, sb.length() - 1));
        }
        catch (Exception e1) {
            sb.append("No help is currently available for this category.\n");
        }
        sb.append("\n\n");
        content.setText((String)title + "\n" + GetParmsGUI.Copies('=', ((String)title).length()) + "\n\n" + sb.toString().substring(0, sb.length() - 1));
        content.setEditable(false);
        JScrollPane hscroll = new JScrollPane(content);
        hscroll.setVerticalScrollBarPolicy(20);
        SwingUtilities.invokeLater(() -> hscroll.getVerticalScrollBar().setValue(0));
        helpwindow.add(hscroll);
        helpwindow.setTitle((String)title);
        helpwindow.setModal(!helpType.equals("General"));
        helpwindow.setResizable(!helpType.equals("General"));
        helpwindow.pack();
        helpwindow.setVisible(true);
    }

    private void setCommandLine() {
        StringBuilder cmdline = GetParmsGUI.TOOL_CMD_LINE();
        for (JComponent jc : this.mComponents) {
            if (!jc.isVisible()) continue;
            String text = null;
            if (jc instanceof JTextField) {
                JTextField jc2 = (JTextField)jc;
                if (!jc2.getText().isEmpty()) {
                    text = jc2.getName().equals("empass") ? "*****" : jc2.getText();
                }
            } else if (jc instanceof JComboBox) {
                text = ((JComboBox)jc).getSelectedItem().toString();
            } else if (jc instanceof JSpinner) {
                text = ((JSpinner)jc).getValue().toString();
            } else if (jc instanceof JCheckBox) {
                String string = text = ((JCheckBox)jc).isSelected() ? "YES" : "NO";
            }
            if (text == null) continue;
            cmdline.append(" -").append(jc.getName()).append(" \"").append(text).append("\"");
        }
        ((JTextComponent)this.jComps.get("CommandFld")).setText(cmdline.toString());
    }

    private void setFieldValue(JTextField tf) {
        boolean bFieldOk = switch (tf.getName()) {
            case "emuser" -> this.externalParameters.setEmUser(tf.getText());
            case "empass" -> this.externalParameters.setEmPass(tf.getText());
            case "Grace", "emserver" -> this.externalParameters.setGuiServer(tf.getText());
            case "outputreport" -> this.externalParameters.setOutputReportDirectory(tf.getText());
            case "report" -> this.externalParameters.setLegacyForecastReport(tf.getText());
            case "report2" -> this.externalParameters.setLegacyForecastReport2(tf.getText());
            case "forecastreport" -> this.externalParameters.setCtmForecastReport(tf.getText());
            case "histexecreport" -> this.externalParameters.setCtmHistExecReport(tf.getText());
            case "filterbycontrolm" -> this.externalParameters.setFilterByControlM(tf.getText());
            case "filterbyfolder" -> this.externalParameters.setFilterByFolder(tf.getText());
            case "filterbyjobname" -> this.externalParameters.setFilterByJobname(tf.getText());
            case "zekejoblen" -> this.externalParameters.setZekeJobLen(tf.getText());
            case "zenajobnamemappingfile" -> this.externalParameters.setZenaJobnameMappingFile(tf.getText());
            case "excludeFile" -> this.externalParameters.setExcludeJobsFile(tf.getText());
            case "includeokjobs" -> this.externalParameters.setIncludeOKJobs(tf.getText());
            case "mapctmtolegacy" -> this.externalParameters.setMapCtmToLegacy(tf.getText());
            case "excelreportlimit" -> this.externalParameters.setMaxRowsForExcelReport(tf.getText());
            default -> true;
        };
        Border line = BorderFactory.createLineBorder(bFieldOk ? this.colorGood : this.colorBad, 1);
        EmptyBorder empty = new EmptyBorder(0, 2, 0, 0);
        tf.setBorder(new CompoundBorder(line, empty));
        this.mFieldsValid.put(tf, bFieldOk);
    }

    private synchronized void LoadConfig() {
        Properties properties = new Properties();
        Path configFilePath = Paths.get("workarea\\cnvvld.conf", new String[0]);
        if (Files.exists(configFilePath, new LinkOption[0]) && Files.isRegularFile(configFilePath, new LinkOption[0])) {
            try (InputStream inputStream = Files.newInputStream(configFilePath, new OpenOption[0]);){
                properties.load(inputStream);
                this.setParametersFromProperties(properties);
                return;
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                System.out.println(e.getStackTrace());
                throw new RuntimeException(e);
            }
        }
        this.setParametersWithDefaultValues();
    }

    private void setParametersWithDefaultValues() {
        for (JComponent jc : this.mComponents) {
            JPanel jc2;
            if (jc instanceof JTextField) {
                this.setFieldValue((JTextField)jc);
                continue;
            }
            if (jc instanceof JComboBox) {
                ((JComboBox)jc).setSelectedIndex(0);
                continue;
            }
            if (!(jc instanceof JPanel) || !(jc2 = (JPanel)jc).getName().equals("newday")) continue;
            ((JComboBox)this.jComps.get("NewDayPlusMinusCombo")).setSelectedItem("+");
            ((JSpinner)this.jComps.get("NewDayHoursFld")).setValue("00");
            ((JSpinner)this.jComps.get("NewDayMinsFld")).setValue("00");
        }
    }

    private void setParametersFromProperties(Properties properties) {
        for (JComponent jc : this.mComponents) {
            JComponent jc2;
            String sName = jc.getName();
            if (sName == null) continue;
            if (jc instanceof JTextField) {
                jc2 = (JTextField)jc;
                if (properties.getProperty(sName) != null) {
                    ((JTextComponent)jc2).setText(properties.getProperty(sName));
                }
                this.setFieldValue((JTextField)jc2);
                continue;
            }
            if (jc instanceof JComboBox) {
                jc2 = (JComboBox)jc;
                if (properties.getProperty(sName) != null) {
                    ((JComboBox)jc2).setSelectedItem(properties.getProperty(sName));
                    continue;
                }
                ((JComboBox)jc2).setSelectedIndex(0);
                continue;
            }
            if (jc instanceof JSpinner) {
                jc2 = (JSpinner)jc;
                if (properties.getProperty(sName) == null) continue;
                ((JSpinner)jc2).setValue(Integer.parseInt(properties.getProperty(sName)));
                continue;
            }
            if (jc instanceof JCheckBox) {
                jc2 = (JCheckBox)jc;
                if (properties.getProperty(sName) == null) continue;
                ((AbstractButton)jc2).setSelected(properties.getProperty(sName).equals("YES"));
                continue;
            }
            if (!(jc instanceof JPanel)) continue;
            jc2 = (JPanel)jc;
            if (properties.getProperty(sName) == null || !jc2.getName().equals("newday")) continue;
            ((JComboBox)this.jComps.get("NewDayPlusMinusCombo")).setSelectedItem(properties.getProperty(sName).substring(0, 1));
            ((JSpinner)this.jComps.get("NewDayHoursFld")).setValue(properties.getProperty(sName).substring(1, 3));
            ((JSpinner)this.jComps.get("NewDayMinsFld")).setValue(properties.getProperty(sName).substring(3, 5));
        }
    }

    private void saveConfig() {
        try {
            Properties properties = new Properties();
            try (FileOutputStream out = new FileOutputStream("workarea\\cnvvld.conf");){
                for (JComponent jc : this.mComponents) {
                    JComponent jc2;
                    if (jc instanceof JTextField) {
                        jc2 = (JTextField)jc;
                        if (jc2.getName().equals("empass")) continue;
                        properties.setProperty(jc2.getName(), ((JTextComponent)jc2).getText());
                        continue;
                    }
                    if (jc instanceof JComboBox) {
                        jc2 = (JComboBox)jc;
                        properties.setProperty(jc2.getName(), ((JComboBox)jc2).getSelectedItem().toString());
                        continue;
                    }
                    if (jc instanceof JSpinner) {
                        jc2 = (JSpinner)jc;
                        properties.setProperty(jc2.getName(), ((JSpinner)jc2).getValue().toString());
                        continue;
                    }
                    if (jc instanceof JCheckBox) {
                        jc2 = (JCheckBox)jc;
                        properties.setProperty(jc2.getName(), ((AbstractButton)jc2).isSelected() ? "YES" : "NO");
                        continue;
                    }
                    if (!(jc instanceof JPanel) || !(jc2 = (JPanel)jc).getName().equals("newday")) continue;
                    properties.setProperty(jc2.getName(), this.externalParameters.getNewdayTime());
                }
                properties.store(out, "BMC Control-M Conversion Verification Tool Settings");
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private void AddTo(JComponent AddToComponent, JComponent ComponentToAdd, GridBagConstraints c) {
        if (this.bShowGrid) {
            AddToComponent.setBackground(Color.BLACK);
            ComponentToAdd.setBorder(BorderFactory.createLineBorder(Color.WHITE));
            c.fill = 1;
            ComponentToAdd.setOpaque(true);
        }
        AddToComponent.add((Component)ComponentToAdd, c);
    }

    private static String Copies(char c, int length) {
        char[] data = new char[length];
        Arrays.fill(data, c);
        return new String(data);
    }

    public void LegacySchedAction() {
        String legacySched = ((JComboBox)this.jComps.get("LegacySchedCombo")).getSelectedItem().toString();
        this.externalParameters.setTypeOfLegcy(legacySched);
        this.setZekeFieldsVisibility();
        this.pack();
        this.setCommandLine();
    }

    public void LegacySchedAction2() {
        String legacySched = ((JComboBox)this.jComps.get("LegacySched2Combo")).getSelectedItem().toString();
        this.externalParameters.setTypeOfLegcy2(legacySched);
        boolean bLegacySchedVisible = true;
        if (legacySched.trim().isEmpty() || legacySched.trim().equals("Select")) {
            bLegacySchedVisible = false;
        }
        for (String jc : this.jComps.keySet()) {
            if (!jc.toLowerCase().startsWith("inputreport2")) continue;
            this.jComps.get(jc).setVisible(bLegacySchedVisible);
            if (bLegacySchedVisible || !jc.toLowerCase().startsWith("inputreport2fld")) continue;
            ((JTextField)this.jComps.get(jc)).setText("");
        }
        this.setZekeFieldsVisibility();
        this.pack();
        this.setCommandLine();
    }

    private void setZekeFieldsVisibility() {
        boolean bZekeVisible = this.externalParameters.getTypeOfLegcy().equals("ASG-Zeke") || this.externalParameters.getTypeOfLegcy2().equals("ASG-Zeke");
        for (Map.Entry<String, JComponent> component : this.jComps.entrySet()) {
            if (!component.getKey().toLowerCase().startsWith("zeke")) continue;
            component.getValue().setVisible(bZekeVisible);
        }
    }

    public void zekeGroupByComboAction() {
        this.externalParameters.setZekeGroupBy(((JComboBox)this.jComps.get("ZekeGroupByCombo")).getSelectedItem().toString());
        boolean bZekeVisible1 = ((JComboBox)this.jComps.get("LegacySchedCombo")).getSelectedItem().toString().equals("ASG-Zeke");
        boolean bZekeVisible2 = ((JComboBox)this.jComps.get("LegacySched2Combo")).getSelectedItem().toString().equals("ASG-Zeke");
        boolean bZekeVisible = bZekeVisible1 || bZekeVisible2;
        this.jComps.get("ZekeGroupByLbl").setVisible(bZekeVisible);
        this.jComps.get("ZekeGroupByCombo").setVisible(bZekeVisible);
        this.setCommandLine();
    }

    public void reportTypeAction(ActionEvent e) {
        this.externalParameters.setTypeOfCompare(((JComboBox)this.jComps.get("ReportTypeCombo")).getSelectedItem().toString());
        boolean bForecastVisible = ((JComboBox)this.jComps.get("ReportTypeCombo")).getSelectedItem().toString().equals("Forecast") || ((JComboBox)this.jComps.get("ReportTypeCombo")).getSelectedItem().toString().equals("Execution-to-Forecast");
        boolean bExecutionVisible = ((JComboBox)this.jComps.get("ReportTypeCombo")).getSelectedItem().toString().equals("Execution");
        for (Map.Entry<String, JComponent> component : this.jComps.entrySet()) {
            if (component.getKey().startsWith("Forecast")) {
                component.getValue().setVisible(bForecastVisible);
                continue;
            }
            if (!component.getKey().startsWith("History")) continue;
            component.getValue().setVisible(bExecutionVisible);
        }
        this.pack();
        this.setCommandLine();
    }

    private void legacyTzAction(ActionEvent e) {
        Object selected = ((JComboBox)this.jComps.get("LegacyTZCombo")).getSelectedItem();
        if (selected != null) {
            this.externalParameters.setLegacyTZ(selected.toString());
        }
        this.setCommandLine();
    }

    public void incrementMatchAction() {
        this.externalParameters.setIncludeOKJobs(((JCheckBox)this.jComps.get("IncMatchesChkbox")).isSelected() ? "YES" : "NO");
        this.setCommandLine();
    }

    public void mapCtmToLegacyAction() {
        this.externalParameters.setMapCtmToLegacy(((JCheckBox)this.jComps.get("MapCtmChkbox")).isSelected() ? "YES" : "NO");
        this.setCommandLine();
    }

    private static Date getBuildDate() {
        Date manifDate = null;
        Class<?> currentClass = new Object(){}.getClass().getEnclosingClass();
        URL url = currentClass.getResource(currentClass.getSimpleName() + ".class");
        if (url != null) {
            if (url.getProtocol().equals("file")) {
                try {
                    manifDate = new Date(url.openConnection().getLastModified());
                }
                catch (IOException iOException) {}
            } else if (url.getProtocol().equals("jar")) {
                String path = url.getPath();
                String jfname = path.substring(5, path.indexOf("!"));
                jfname = URLDecoder.decode(jfname, StandardCharsets.UTF_8);
                try (JarFile jf = new JarFile(jfname);){
                    ZipEntry manifest = jf.getEntry("META-INF/MANIFEST.MF");
                    manifDate = new Date(manifest.getTime());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return manifDate;
    }

    private String formatStringGroup(String ... sValues) {
        return Stream.of(sValues).collect(Collectors.joining(", ", "[", "]"));
    }

    public boolean doverify(JComponent input) {
        JTextField tf = (JTextField)input;
        this.setFieldValue(tf);
        this.setCommandLine();
        return true;
    }

    public void jobLengthChanged(ChangeEvent e) {
        JSpinner js = (JSpinner)e.getSource();
        this.externalParameters.setZekeJobLen(js.getValue().toString());
        this.setCommandLine();
    }

    public void newDayChanged() {
        String sign = ((JComboBox)this.jComps.get("NewDayPlusMinusCombo")).getSelectedItem().toString();
        String hours = ((JSpinner)this.jComps.get("NewDayHoursFld")).getValue().toString();
        String mins = ((JSpinner)this.jComps.get("NewDayMinsFld")).getValue().toString();
        this.externalParameters.setNewdayTime(sign + hours + mins);
        this.setCommandLine();
    }

    private void toggleFilters(boolean bFilterByVisible) {
        this.bFilterByVisible = bFilterByVisible;
        for (Map.Entry<String, JComponent> component : this.jComps.entrySet()) {
            if (!component.getKey().startsWith("FilterBy")) continue;
            component.getValue().setVisible(bFilterByVisible);
        }
        String filterImageName = bFilterByVisible ? "/images/expand.png" : "/images/collapsed.png";
        URL resource = this.getClass().getResource(filterImageName);
        ((JLabel)this.jComps.get("FilterPlusMinusLbl")).setIcon(new ImageIcon(resource));
    }

    private static String getVersion() {
        String ret = CompareVersionToS3.getVersionNumber();
        if (ret == null) {
            ret = mBuildDate.toString();
        }
        return ret;
    }

    public static ComponentConfigurationBuilder componentConfigurationBuilder() {
        return new ComponentConfigurationBuilder();
    }

    private static class ComponentConfigurationBuilder {
        private final ComponentConfiguration configuration = new ComponentConfiguration();

        public ComponentConfiguration build() {
            return this.configuration;
        }

        public ComponentConfigurationBuilder componentName(String componentName) {
            this.configuration.componentName = componentName;
            return this;
        }

        public ComponentConfigurationBuilder padding(Insets leftPadding, Insets rightPadding) {
            this.configuration.leftPadding = leftPadding;
            this.configuration.rightPadding = rightPadding;
            return this;
        }

        public ComponentConfigurationBuilder show(boolean show) {
            this.configuration.show = show;
            return this;
        }

        public ComponentConfigurationBuilder gridWidth(Integer a, Integer b, Integer c) {
            this.configuration.gridWidth = new ImmutableTriple((Object)a, (Object)b, (Object)c);
            return this;
        }

        public ComponentConfigurationBuilder field(String field) {
            this.configuration.field = field;
            return this;
        }

        public ComponentConfigurationBuilder label(String label) {
            this.configuration.label = label;
            return this;
        }
    }

    private static class ComponentConfiguration {
        private String componentName;
        private Insets leftPadding;
        private Insets rightPadding;
        private boolean show;
        private Triple<Integer, Integer, Integer> gridWidth;
        private String field;
        private String label;

        private ComponentConfiguration() {
        }
    }

    public static class textPrompt
    extends JLabel
    implements FocusListener,
    DocumentListener {
        private static final long serialVersionUID = 1L;
        private final JTextComponent component;
        private final Document document;
        private Show show;
        private boolean showPromptOnce;
        private int focusLost;

        public textPrompt(String text, JTextComponent component) {
            this(text, component, Show.FOCUS_LOST);
        }

        public textPrompt(String text, JTextComponent component, Show show) {
            this.component = component;
            this.setShow(show);
            this.document = component.getDocument();
            this.setText(text);
            this.setFont(component.getFont());
            this.setForeground(component.getForeground());
            this.setBorder(new EmptyBorder(component.getInsets()));
            this.setHorizontalAlignment(10);
            component.addFocusListener(this);
            this.document.addDocumentListener(this);
            component.setLayout(new BorderLayout());
            component.add(this);
            this.checkForPrompt();
        }

        public void changeStyle(int style) {
            this.setFont(this.getFont().deriveFont(style));
        }

        public void setShow(Show show) {
            this.show = show;
        }

        private void checkForPrompt() {
            if (this.document.getLength() > 0) {
                this.setVisible(false);
                return;
            }
            if (this.showPromptOnce && this.focusLost > 0) {
                this.setVisible(false);
                return;
            }
            if (this.component.hasFocus()) {
                this.setVisible(this.show == Show.ALWAYS || this.show == Show.FOCUS_GAINED);
            } else {
                this.setVisible(this.show == Show.ALWAYS || this.show == Show.FOCUS_LOST);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.checkForPrompt();
        }

        @Override
        public void focusLost(FocusEvent e) {
            ++this.focusLost;
            this.checkForPrompt();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.checkForPrompt();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.checkForPrompt();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }

    static class RunCompareWorker
    extends SwingWorker<Boolean, Boolean> {
        private final ExternalParameters externalParameters;
        private final JTextArea messageArea;
        private final int runCount;
        private final MessageCollector messageCollector;

        public RunCompareWorker(ExternalParameters externalParameters, JTextArea msgArea, int runCount) {
            this.externalParameters = externalParameters;
            this.messageArea = msgArea;
            this.runCount = runCount;
            this.messageCollector = new MessageCollector(){

                @Override
                public void add(String string) {
                    super.add(string);
                    messageArea.append("\n" + string);
                    messageArea.setCaretPosition(messageArea.getDocument().getLength());
                }
            };
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            this.messageArea.setText("Starting Verification! - run #" + this.runCount);
            RunCompare compare = new RunCompare();
            compare.run(this.externalParameters, this.messageCollector);
            this.messageArea.append("\nEnd of Verification! - run #" + this.runCount);
            this.messageArea.setCaretPosition(this.messageArea.getDocument().getLength());
            return compare.isVerificationCompletedOk();
        }

        @Override
        protected void done() {
            try {
                if (((Boolean)this.get()).booleanValue()) {
                    GetParmsGUI.openVerifyReport(this.externalParameters.getOutputReportFullName());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static enum Show {
        ALWAYS,
        FOCUS_GAINED,
        FOCUS_LOST;

    }
}

