/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation;

import com.bmc.cnvvalidation.CommonJobFH;
import com.bmc.cnvvalidation.CommonRepository;
import com.bmc.cnvvalidation.CommonRepositoryReader;
import com.bmc.cnvvalidation.ExcludeFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class ExternalSort {
    static int iBufferSize = 5000000;
    private final String sWorkPath = "workarea\\";
    private String mFileToSort;
    private String mSortedFile;
    private final ExcludeFile excludeFile;

    public ExternalSort(String fileToSort, String sortedFile, ExcludeFile excludeFile) {
        this.mFileToSort = fileToSort;
        this.mSortedFile = sortedFile;
        this.excludeFile = excludeFile;
    }

    public int externalSort() {
        File inFile = new File(this.mFileToSort);
        String inFileName = inFile.getName();
        String tfile = "workarea\\" + inFileName + "part";
        String tsuffix = ".csv";
        int totJobs = 0;
        try {
            FileInputStream toSortOutputStream = new FileInputStream(this.mFileToSort);
            CommonRepositoryReader crIN = new CommonRepositoryReader(toSortOutputStream, this.excludeFile);
            int slices = 0;
            int j = 0;
            int i = 0;
            boolean eof = false;
            crIN.fetch();
            while (!eof) {
                CommonJobFH job;
                ArrayList<CommonJobFH> crBuffer = new ArrayList<CommonJobFH>();
                for (j = 0; j < iBufferSize; j += job.toString().length()) {
                    job = crIN.fetch();
                    if (job != null) {
                        crBuffer.add(job);
                        ++totJobs;
                        continue;
                    }
                    eof = true;
                    break;
                }
                Collections.sort(crBuffer, new JobComparator(this));
                String fileName = tfile + Integer.toString(slices++) + ".csv";
                FileOutputStream outputStream = new FileOutputStream(fileName);
                CommonRepository crTEMP = new CommonRepository(outputStream);
                for (int k = 0; k < crBuffer.size(); ++k) {
                    crTEMP.insert((CommonJobFH)crBuffer.get(k));
                }
                crTEMP.term();
            }
            crIN.term();
            CommonJobFH[] jCurrentJob = new CommonJobFH[slices];
            CommonRepositoryReader[] crs = new CommonRepositoryReader[slices];
            for (i = 0; i < slices; ++i) {
                String sliceFile = tfile + Integer.toString(i) + ".csv";
                FileInputStream inputStream = new FileInputStream(sliceFile);
                crs[i] = new CommonRepositoryReader(inputStream, this.excludeFile);
                crs[i].fetch();
                jCurrentJob[i] = crs[i].fetch();
            }
            FileOutputStream outputStream = new FileOutputStream(this.mSortedFile);
            CommonRepository crSORTED = new CommonRepository(outputStream);
            String LastJobName = null;
            int JobCount = 1;
            for (i = 0; i < totJobs; ++i) {
                CommonJobFH jNextJob = jCurrentJob[0];
                int sNextLineFile = 0;
                for (j = 0; j < slices; ++j) {
                    if (ExternalSort.CompareJobs(jNextJob, jCurrentJob[j]) <= 0) continue;
                    jNextJob = jCurrentJob[j];
                    sNextLineFile = j;
                }
                if (jNextJob.getJobMemName().equals(LastJobName)) {
                    ++JobCount;
                } else {
                    LastJobName = jNextJob.getJobMemName();
                    JobCount = 1;
                }
                jNextJob.setJobMemNameOccurrence(Integer.toString(JobCount));
                crSORTED.insert(jNextJob);
                jCurrentJob[sNextLineFile] = crs[sNextLineFile].fetch();
            }
            for (i = 0; i < slices; ++i) {
                crs[i].term();
                File tf = new File(tfile + Integer.toString(i) + ".csv");
                tf.delete();
            }
            crSORTED.term();
        }
        catch (Exception e) {
            totJobs = -1;
        }
        return totJobs;
    }

    private static int CompareJobs(CommonJobFH a, CommonJobFH b) {
        if (a == null) {
            return 1;
        }
        if (b == null) {
            return -1;
        }
        if (a.getJobMemName().equals(b.getJobMemName())) {
            return a.getStartRun().compareTo(b.getStartRun());
        }
        return a.getJobMemName().compareTo(b.getJobMemName());
    }

    class JobComparator
    implements Comparator<CommonJobFH> {
        JobComparator(ExternalSort this$0) {
        }

        @Override
        public int compare(CommonJobFH a, CommonJobFH b) {
            return ExternalSort.CompareJobs(a, b);
        }
    }
}

