/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation;

import com.bmc.cnvvalidation.LegacyReportInputStreamSuplier;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.LinkedList;
import java.util.List;

public class ExternalParameters {
    private LegacyReportInputStreamSuplier ctmForecastReportSupplier = null;
    private String ctmHistExecReport = "";
    private String legacyForecastReport = "";
    private String legacyForecastReport2 = "";
    private String outputReport = "";
    private String outputReportFullName = "";
    private String guiServer = "vw-tlv-ctm-dv63";
    private String emUser = "emuser";
    private String emPass = "empass";
    private String typeOfLegcy = "CA-Autosys";
    private String typeOfLegcy2 = "Select";
    private String typeOfCompare = "Forecast";
    private ZoneOffset legacyTZ = ZoneOffset.UTC;
    private String filterByControlM = "";
    private String filterByFolder = "";
    private String filterByJobname = "";
    private String forecastCompareLevel = "jobs";
    private String zekeGroupBy = "APP";
    private Integer zekeJobLen = 8;
    private String zenaJobnameMappingFile = "";
    private String includeOKJobs = "YES";
    private String mapCtmToLegacy = "NO";
    private String newdayTime = "+0000";
    private static final String automationAPIVerificationReportName = "Verification_Jobs_Executions_History_Report";
    private String jarDateTime;
    private String excludeFilename;
    private String maxRowsForExcelReport = "1000000";

    public List<String> listAllVariablesAndValues() {
        Field[] fields;
        LinkedList<String> ll = new LinkedList<String>();
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            try {
                if (field.getName().equals("ctmForecastReportSupplier")) continue;
                if (field.getType() == String.class) {
                    if (field.getName().equals("emPass")) {
                        ll.add(field.getName() + "=*****");
                        continue;
                    }
                    ll.add(field.getName() + "=" + String.valueOf(field.get(this)));
                    continue;
                }
                if (field.getType() == Integer.class) {
                    ll.add(field.getName() + "=" + ((Integer)field.get(this)).toString());
                    continue;
                }
                if (field.get(this) == null) continue;
                ll.add(field.getName() + "=" + field.get(this).toString());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return ll;
    }

    private boolean fileExists(String fn) {
        File f = new File(fn);
        return f.exists() && !f.isDirectory();
    }

    private boolean dirExists(String fn) {
        File f = new File(fn);
        return f.exists() && f.isDirectory();
    }

    public LegacyReportInputStreamSuplier getCtmForecastReport() {
        return this.ctmForecastReportSupplier;
    }

    public boolean setCtmForecastReport(String ctmForecastReport) {
        if (ctmForecastReport == null) {
            this.ctmForecastReportSupplier = null;
            return true;
        }
        if (!ctmForecastReport.isEmpty() && !this.fileExists(ctmForecastReport)) {
            return false;
        }
        this.ctmForecastReportSupplier = this.getInputStreamSupplier(ctmForecastReport);
        return true;
    }

    public boolean setCtmForecastReport(LegacyReportInputStreamSuplier ctmForecastReportSupplier) {
        this.ctmForecastReportSupplier = ctmForecastReportSupplier;
        return true;
    }

    public LegacyReportInputStreamSuplier getCtmHistExecReport() {
        return this.getInputStreamSupplier(this.ctmHistExecReport);
    }

    public boolean setCtmHistExecReport(String ctmHistExecReport) {
        if (!ctmHistExecReport.isEmpty() && !this.fileExists(ctmHistExecReport)) {
            return false;
        }
        this.ctmHistExecReport = ctmHistExecReport;
        return true;
    }

    public LegacyReportInputStreamSuplier getLegacyForecastReport() {
        return this.getInputStreamSupplier(this.legacyForecastReport);
    }

    private LegacyReportInputStreamSuplier getInputStreamSupplier(String legacyReport) {
        if (legacyReport.isEmpty()) {
            return null;
        }
        try {
            return new LegacyReportInputStreamSuplier(Files.newInputStream(Paths.get(legacyReport, new String[0]), new OpenOption[0]));
        }
        catch (IOException e) {
            ConversionLogger.getLogger().info("Failed to load file: " + legacyReport + "\n" + e.getMessage());
            return new LegacyReportInputStreamSuplier(new ByteArrayInputStream("".getBytes()));
        }
    }

    public LegacyReportInputStreamSuplier getLegacyForecastReport2() {
        return this.getInputStreamSupplier(this.legacyForecastReport2);
    }

    public boolean setLegacyForecastReport(String legacyForecastReport) {
        if (!this.fileExists(legacyForecastReport)) {
            return false;
        }
        this.legacyForecastReport = legacyForecastReport;
        return true;
    }

    public boolean setLegacyForecastReport2(String legacyForecastReport) {
        if (!this.fileExists(legacyForecastReport)) {
            return false;
        }
        this.legacyForecastReport2 = legacyForecastReport;
        return true;
    }

    public String getOutputReportDirectory() {
        return this.outputReport;
    }

    public boolean setOutputReportDirectory(String outputReport) {
        if (!this.dirExists(outputReport)) {
            return false;
        }
        this.outputReport = outputReport;
        return true;
    }

    public String getOutputReportFullName() {
        return this.outputReportFullName;
    }

    public void setOutputReportFullName(String outputReportFullName) {
        this.outputReportFullName = outputReportFullName;
    }

    public String getGuiServer() {
        return this.guiServer;
    }

    public boolean setGuiServer(String guiServer) {
        if (guiServer.isEmpty()) {
            return false;
        }
        this.guiServer = guiServer;
        return true;
    }

    public String getEmUser() {
        return this.emUser;
    }

    public boolean setEmUser(String emUser) {
        if (emUser.length() < 2) {
            return false;
        }
        this.emUser = emUser;
        return true;
    }

    public String getEmPass() {
        return this.emPass;
    }

    public boolean setEmPass(String emPass) {
        if (emPass.length() < 2) {
            return false;
        }
        this.emPass = emPass;
        return true;
    }

    public String getTypeOfLegcy() {
        return this.typeOfLegcy;
    }

    public String getTypeOfLegcy2() {
        return this.typeOfLegcy2;
    }

    public List<String> listTypeOfLegcy() {
        return List.of("Select", "ASG-Zeke", "ASG-Zena", "Automic-Dollar-Universe", "CA-Autosys", "CA-ESP", "CA-Unicenter-WLM-TNG", "CA-7", "IBM-TWS-DS", "IBM-TWS-MF");
    }

    public boolean setTypeOfLegcy(String typeOfLegcy) {
        this.typeOfLegcy = typeOfLegcy;
        return true;
    }

    public boolean setTypeOfLegcy2(String typeOfLegcy) {
        this.typeOfLegcy2 = typeOfLegcy;
        return true;
    }

    public String getTypeOfCompare() {
        return this.typeOfCompare;
    }

    public boolean setTypeOfCompare(String typeOfCompare) {
        this.typeOfCompare = typeOfCompare;
        return true;
    }

    public ZoneOffset getLegacyTZ() {
        return this.legacyTZ;
    }

    public void setLegacyTZ(ZoneOffset zoneOffset) {
        this.legacyTZ = zoneOffset;
    }

    public boolean setLegacyTZ(String legacyTZ) {
        if (legacyTZ.indexOf(" (") < 1) {
            return false;
        }
        Instant dt = Instant.now();
        try {
            ZoneId zone = ZoneId.of(legacyTZ.substring(0, legacyTZ.indexOf(" (")));
            this.legacyTZ = dt.atZone(zone).getOffset();
            return true;
        }
        catch (DateTimeException ex) {
            return false;
        }
    }

    public String getFilterByControlM() {
        return this.filterByControlM;
    }

    public boolean setFilterByControlM(String filterByControlM) {
        this.filterByControlM = filterByControlM;
        return true;
    }

    public String getFilterByFolder() {
        return this.filterByFolder;
    }

    public boolean setFilterByFolder(String filterByFolder) {
        this.filterByFolder = filterByFolder;
        return true;
    }

    public String getFilterByJobname() {
        return this.filterByJobname;
    }

    public boolean setFilterByJobname(String filterByJobname) {
        this.filterByJobname = filterByJobname;
        return true;
    }

    public String getForecastCompareLevel() {
        return this.forecastCompareLevel;
    }

    public boolean setForecastCompareLevel(String forecastCompareLevel) {
        if (!forecastCompareLevel.equals("jobs") && !forecastCompareLevel.equals("folders")) {
            return false;
        }
        this.forecastCompareLevel = forecastCompareLevel;
        return true;
    }

    public String getZekeGroupBy() {
        return this.zekeGroupBy;
    }

    public boolean setZekeGroupBy(String zekeGroupBy) {
        if (!(zekeGroupBy.equals("APP") || zekeGroupBy.equals("APPGRP") || zekeGroupBy.equals("EVT") || zekeGroupBy.equals("JOB") || zekeGroupBy.equals("USERID"))) {
            return false;
        }
        this.zekeGroupBy = zekeGroupBy;
        return true;
    }

    public int getZekeJobLen() {
        return this.zekeJobLen;
    }

    public boolean setZekeJobLen(String sZekeJobLen) {
        int jobLen;
        try {
            jobLen = Integer.parseInt(sZekeJobLen);
        }
        catch (Exception e) {
            return false;
        }
        if (jobLen > 8 || jobLen < 1) {
            return false;
        }
        this.zekeJobLen = jobLen;
        return true;
    }

    public String getJobnameMappingFile() {
        return this.zenaJobnameMappingFile;
    }

    public boolean setZenaJobnameMappingFile(String zenaJobnameMappingFile) {
        if (!this.fileExists(zenaJobnameMappingFile) && !zenaJobnameMappingFile.isEmpty()) {
            return false;
        }
        this.zenaJobnameMappingFile = zenaJobnameMappingFile;
        return true;
    }

    public String getIncludeOKJobs() {
        return this.includeOKJobs;
    }

    public boolean setIncludeOKJobs(String includeOKJobs) {
        if (!"YES".equals(includeOKJobs) && !"NO".equals(includeOKJobs)) {
            return false;
        }
        this.includeOKJobs = includeOKJobs;
        return true;
    }

    public String getMapCtmToLegacy() {
        return this.mapCtmToLegacy;
    }

    public boolean setMapCtmToLegacy(String mapCtmToLegacy) {
        if (!"YES".equals(mapCtmToLegacy) && !"NO".equals(mapCtmToLegacy)) {
            return false;
        }
        this.mapCtmToLegacy = mapCtmToLegacy;
        return true;
    }

    public String getNewdayTime() {
        return this.newdayTime;
    }

    public boolean setNewdayTime(String newdayTime) {
        this.newdayTime = newdayTime;
        return true;
    }

    public void setJarDateTime(String jarDateTime) {
        this.jarDateTime = jarDateTime;
    }

    public String getAAPIEndpoint() {
        String server = this.getGuiServer();
        if (server.startsWith("https://")) {
            return server;
        }
        if (server.matches(".*:\\d{4}$")) {
            return "https://%s/automation-api".formatted(server);
        }
        return "https://%s:8443/automation-api".formatted(server);
    }

    public String getAutomationAPIVerificationReportName() {
        return automationAPIVerificationReportName;
    }

    public boolean setExcludeJobsFile(String excludeFilename) {
        if (!this.fileExists(excludeFilename) && !excludeFilename.isEmpty()) {
            return false;
        }
        this.excludeFilename = excludeFilename;
        return true;
    }

    public String getExcludeJobsFile() {
        return this.excludeFilename;
    }

    public int getMaxRowsForExcelReport() {
        return Integer.parseInt(this.maxRowsForExcelReport);
    }

    public Boolean setMaxRowsForExcelReport(String maxRowsForExcelReport) {
        int i = 0;
        try {
            i = Integer.parseInt(maxRowsForExcelReport);
        }
        catch (NumberFormatException ex) {
            i = -1;
        }
        if (i < 0) {
            return false;
        }
        this.maxRowsForExcelReport = maxRowsForExcelReport;
        return true;
    }
}

