/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation;

import com.bmc.cnvvalidation.CommonJobFH;
import com.bmc.cnvvalidation.ExcludeFile;
import com.bmc.ctmconvert.io.csv.CsvReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Optional;

public class CommonRepositoryReader {
    private final ExcludeFile excludeFile;
    private final CsvReader csvReader;

    CommonRepositoryReader(InputStream inputStream, ExcludeFile excludeFile) {
        this.csvReader = new CsvReader((Reader)new BufferedReader(new InputStreamReader(inputStream)));
        this.excludeFile = excludeFile;
    }

    public CommonJobFH fetch() throws IOException {
        CommonJobFH job = null;
        while (job == null && this.csvReader.readRecord()) {
            job = this.excludeJob(this.fieldsToJob(this.csvReader.getValues()));
        }
        return job;
    }

    private CommonJobFH fieldsToJob(String[] fields) {
        CommonJobFH job = new CommonJobFH();
        int index = 0;
        job.setJobMemName(fields[index++]);
        job.setJobMemNameOccurrence(fields[index++]);
        job.setControlm(fields[index++]);
        job.setFolder(fields[index++]);
        job.setSchedulingLibraryDsn(fields[index++]);
        job.setRunCount(fields[index++]);
        job.setStartRun(fields[index++]);
        job.setEndRun(fields[index++]);
        job.setRunDate(fields[index++]);
        job.setUpdatedTimeStamp(fields[index++]);
        job.setOriginalJobname(fields[index++]);
        job.setOrigin(fields[index++]);
        job.setVendorSpecific(this.getFieldOrEmpty(fields, index++));
        job.setOrderDate(this.getFieldOrEmpty(fields, index));
        return job;
    }

    private String getFieldOrEmpty(String[] fields, int index) {
        if (fields.length > index) {
            return fields[index];
        }
        return "";
    }

    public void term() {
        this.csvReader.close();
    }

    private CommonJobFH excludeJob(CommonJobFH job) {
        return Optional.ofNullable(job).filter(j -> !this.excludeFile.isExcluded((CommonJobFH)j)).orElse(null);
    }
}

