/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation;

import com.bmc.cnvvalidation.CommonJobFH;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class CommonRepository {
    private final OutputStream stream;
    private BufferedWriter output;

    public CommonRepository(OutputStream outStream) {
        this.stream = outStream;
        this.init();
    }

    public void init() {
        this.output = new BufferedWriter(new OutputStreamWriter(this.stream));
        CommonJobFH header = new CommonJobFH("jobMemName", "jobMemNameOccurrence", "Control-M", "folder", "schedulingLibraryDsn", "runCount", "startRun", "endRun", "runDate", "updatedTimeStamp", "originalJobname", "origin", "vendorSpecific", "orderDate");
        this.insert(header);
    }

    public void term() {
        try {
            this.output.flush();
            this.output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void insert(CommonJobFH job) {
        StringBuilder csvLine = new StringBuilder();
        this.appendLineToCsv(job, csvLine);
        csvLine.append(",");
        csvLine.append(job.getJobMemNameOccurrence());
        csvLine.append(",");
        csvLine.append(job.getControlm());
        csvLine.append(",");
        csvLine.append(job.getFolder());
        csvLine.append(",");
        csvLine.append(job.getSchedulingLibraryDsn());
        csvLine.append(",");
        csvLine.append(job.getRunCount());
        csvLine.append(",");
        csvLine.append(job.getStartRun());
        csvLine.append(",");
        csvLine.append(job.getEndRun());
        csvLine.append(",");
        csvLine.append(job.getRunDate());
        csvLine.append(",");
        csvLine.append(job.getUpdatedTimeStamp());
        csvLine.append(",");
        csvLine.append(job.getOriginalJobname());
        csvLine.append(",");
        csvLine.append(job.getOrigin());
        csvLine.append(",");
        csvLine.append(job.getVendorSpecific());
        csvLine.append(",");
        csvLine.append(this.addQuotesIfNeeded(job.getOrderDate()));
        try {
            this.output.write(csvLine.toString());
            this.output.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void appendLineToCsv(CommonJobFH job, StringBuilder csvLine) {
        csvLine.append(job.getJobMemName());
    }

    private String addQuotesIfNeeded(String field) {
        if (field.contains(",")) {
            return "\"" + field + "\"";
        }
        return field;
    }
}

