/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation;

import com.bmc.cnvvalidation.ExternalParameters;
import com.bmc.cnvvalidation.GetParmsGUI;
import com.bmc.cnvvalidation.MessageCollector;
import com.bmc.cnvvalidation.RunCompare;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class App {
    protected static Consumer<String> printer = System.out::println;

    public static void main(String[] args) {
        try {
            Files.createDirectories(Paths.get("workarea\\", new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            System.out.print("Can't create directories " + String.valueOf(Paths.get("workarea\\", new String[0]).toAbsolutePath()));
            e.printStackTrace(System.out);
            System.exit(-1);
        }
        ExternalParameters externalParameters = new ExternalParameters();
        if (App.hasParameters(args)) {
            externalParameters = App.getParameters(args);
            if (externalParameters != null) {
                MessageCollector messages = new MessageCollector();
                messages.add("Starting Verification!");
                new RunCompare().run(externalParameters, messages);
                messages.add("End of Verification!");
                messages.getAll().forEach(App::print);
            }
        } else {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
                // empty catch block
            }
            new GetParmsGUI(externalParameters);
        }
    }

    private static boolean hasParameters(String[] args) {
        return args.length > 0;
    }

    public static ExternalParameters getParameters(String[] args) {
        ExternalParameters externalParameters = new ExternalParameters();
        String currentArg = "";
        boolean parametersOK = true;
        block50: for (String arg : args) {
            switch (currentArg) {
                case "": {
                    currentArg = arg;
                    continue block50;
                }
                case "-legacy": {
                    if (!externalParameters.setTypeOfLegcy(arg)) {
                        parametersOK = App.invalidValue(currentArg, arg);
                    }
                    currentArg = "";
                    continue block50;
                }
                case "-legacy2": {
                    if (!externalParameters.setTypeOfLegcy2(arg)) {
                        parametersOK = App.invalidValue(currentArg, arg);
                    }
                    currentArg = "";
                    continue block50;
                }
                case "-compare": {
                    if (!externalParameters.setTypeOfCompare(arg)) {
                        parametersOK = App.invalidValue(currentArg, arg);
                    }
                    currentArg = "";
                    continue block50;
                }
                case "-emuser": {
                    if (!externalParameters.setEmUser(arg)) {
                        parametersOK = App.invalidValue(currentArg, arg);
                    }
                    currentArg = "";
                    continue block50;
                }
                case "-empass": {
                    if (!externalParameters.setEmPass(arg)) {
                        parametersOK = App.invalidValue(currentArg, arg);
                    }
                    currentArg = "";
                    continue block50;
                }
                case "-emserver": {
                    if (!externalParameters.setGuiServer(arg)) {
                        parametersOK = App.invalidValue(currentArg, arg);
                    }
                    currentArg = "";
                    continue block50;
                }
                case "-report": {
                    if (!externalParameters.setLegacyForecastReport(arg)) {
                        parametersOK = App.invalidValue(currentArg, arg);
                    }
                    currentArg = "";
                    continue block50;
                }
                case "-report2": {
                    if (!externalParameters.setLegacyForecastReport2(arg)) {
                        parametersOK = App.invalidValue(currentArg, arg);
                    }
                    currentArg = "";
                    continue block50;
                }
                case "-forecastreport": {
                    if (!externalParameters.setCtmForecastReport(arg)) {
                        parametersOK = App.invalidValue(currentArg, arg);
                    }
                    currentArg = "";
                    continue block50;
                }
                case "-histexecreport": {
                    if (!externalParameters.setCtmHistExecReport(arg)) {
                        parametersOK = App.invalidValue(currentArg, arg);
                    }
                    currentArg = "";
                    continue block50;
                }
                case "-outputreport": {
                    if (!externalParameters.setOutputReportDirectory(arg)) {
                        parametersOK = App.invalidValue(currentArg, arg);
                    }
                    currentArg = "";
                    continue block50;
                }
                case "-filterbycontrolm": {
                    if (!externalParameters.setFilterByControlM(arg)) {
                        parametersOK = App.invalidValue(currentArg, arg);
                    }
                    currentArg = "";
                    continue block50;
                }
                case "-filterbyfolder": {
                    if (!externalParameters.setFilterByFolder(arg)) {
                        parametersOK = App.invalidValue(currentArg, arg);
                    }
                    currentArg = "";
                    continue block50;
                }
                case "-filterbyjobname": {
                    if (!externalParameters.setFilterByJobname(arg)) {
                        parametersOK = App.invalidValue(currentArg, arg);
                    }
                    currentArg = "";
                    continue block50;
                }
                case "-zekegroupby": {
                    if (!externalParameters.setZekeGroupBy(arg)) {
                        parametersOK = App.invalidValue(currentArg, arg);
                    }
                    currentArg = "";
                    continue block50;
                }
                case "-zekejoblen": {
                    if (!externalParameters.setZekeJobLen(arg)) {
                        parametersOK = App.invalidValue(currentArg, arg);
                    }
                    currentArg = "";
                    continue block50;
                }
                case "-zenajobnamemappingfile": {
                    if (!externalParameters.setZenaJobnameMappingFile(arg)) {
                        parametersOK = App.invalidValue(currentArg, arg);
                    }
                    currentArg = "";
                    continue block50;
                }
                case "-excludeFile": {
                    if (!externalParameters.setExcludeJobsFile(arg)) {
                        parametersOK = App.invalidValue(currentArg, arg);
                    }
                    currentArg = "";
                    continue block50;
                }
                case "-includeokjobs": {
                    if (!externalParameters.setIncludeOKJobs(arg)) {
                        parametersOK = App.invalidValue(currentArg, arg);
                    }
                    currentArg = "";
                    continue block50;
                }
                case "-mapctmtolegacy": {
                    if (!externalParameters.setMapCtmToLegacy(arg)) {
                        parametersOK = App.invalidValue(currentArg, arg);
                    }
                    currentArg = "";
                    continue block50;
                }
                case "-excelreportlimit": {
                    if (!externalParameters.setMaxRowsForExcelReport(arg).booleanValue()) {
                        parametersOK = App.invalidValue(currentArg, arg);
                    }
                    currentArg = "";
                    continue block50;
                }
                case "-legacyTZ": {
                    if (!externalParameters.setLegacyTZ(arg)) {
                        parametersOK = App.invalidValue(currentArg, arg);
                    }
                    currentArg = "";
                    continue block50;
                }
                default: {
                    if (!parametersOK) continue block50;
                    App.print("Command Line parameter " + currentArg + " is illegal");
                    App.print("Valid Command Line parameters: -legacy -compare -dbtype -dbuser -dbuser -dbpass -dbname -dbserver -emuser -empass -emserver -report -forecastreport -histexecreport -outputreport -filterbycontrolm -filterbyfolder -filterbyjobname -zekegroupby -zekejoblen -zenajobnamemappingfile -mapctmtolegacy -excelreportlimit -legacyTZ");
                    currentArg = "";
                    parametersOK = false;
                }
            }
        }
        return parametersOK ? externalParameters : null;
    }

    private static boolean invalidValue(String currentArg, String arg) {
        App.print("Command Line parameter " + currentArg + " - invalid value " + arg);
        return false;
    }

    private static void print(String text) {
        printer.accept(text);
    }

    public static void overridePrinter(Consumer<String> testPrinter) {
        printer = testPrinter;
    }
}

