/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.Context;
import com.bmc.ctmconvert.InputStreamNamePair;
import com.bmc.ctmconvert.SelfConversionDataParser;
import com.bmc.ctmconvert.common.draftwriter.DataAccumulator;
import com.bmc.ctmconvert.common.draftwriter.EmptyMessageHandler;
import com.bmc.ctmconvert.common.draftwriter.MessageMappingInterface;
import com.bmc.ctmconvert.common.draftwriter.VersionControl;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.common.exceptions.ConvertorException;
import com.bmc.ctmconvert.project.SelfConversionProject;
import com.bmc.ctmconvert.rule.RulesProvider;
import com.bmc.ctmconvert.workspace.IWorkspace;
import com.bmc.ctmconvert.workspace.Workspace;
import com.bmc.ctmconvert.workspace.utilties.WorkspaceWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import org.json.JSONArray;

public class SelfConversionExecuter {
    private DataAccumulator dataAccumulator;
    private ByteArrayOutputStream outputXmlWriter;
    private SelfConversionDataParser dataParser;

    public SelfConversionExecuter(SelfConversionDataParser dataParser) {
        this.dataParser = dataParser;
    }

    public Workspace executeConversion(JSONArray projectDataFilesPathArray, RulesProvider rulesProvider, Path resultDraftPath, String version) throws ConvertorException, ConvertorCancelClickException, IOException {
        List<InputStreamNamePair> inputData = this.dataParser.parse(projectDataFilesPathArray);
        Context.setInputData(inputData);
        VersionControl versionControl = new VersionControl();
        String projectTargetCTMVersion = versionControl.getVersionValue(version);
        SelfConversionProject selfConversionProject = new SelfConversionProject(rulesProvider);
        Workspace workspace = selfConversionProject.convert();
        EmptyMessageHandler msgMapping = new EmptyMessageHandler();
        this.dataAccumulator = new DataAccumulator((MessageMappingInterface)msgMapping);
        WorkspaceWriter workspaceWriter = new WorkspaceWriter((IWorkspace)workspace, this.dataAccumulator, projectTargetCTMVersion);
        this.outputXmlWriter = new ByteArrayOutputStream();
        workspaceWriter.write((OutputStream)this.outputXmlWriter);
        Files.write(resultDraftPath, this.outputXmlWriter.toByteArray(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        return workspace;
    }

    public DataAccumulator getDataAccumulator() {
        return this.dataAccumulator;
    }

    public ByteArrayOutputStream getOutputXmlWriter() {
        return this.outputXmlWriter;
    }
}

